; TIP923.LSP: DDUNLOAD.LSP   Unload ADS Programs    (c)1993, Michael Jenkins

; This is a dialog box for unloading ADS applications from AutoCAD Release 12.
; You will be presented with a list of the currently loaded applications. You
; can tag one or more and they will be unloaded. If no applications are loaded,
; the list will be blank. Be careful when unloading the ACADAPP ADS application
; because Release 12 depends on its presence.
; Written by:
; Michael Jenkins
; Gray Construction
; Lexington, Kentucky

(defun C:DDUNLOAD (/ _accept app_list id)

   (defun _accept (/ return counter string)
      (setq
         return (get_tile "apps")
      )
      (if (= return "")
         (set_tile "error" "Empty or invalid input")
         (progn
            (setq
               counter 1
               string ""
               return (strcat return " ")
            )
            (while
               (/= counter
                  (1+
                     (strlen return)
                  )
               )
               (if (/= (substr return counter 1) " ")
                  (setq string (strcat string (substr return counter 1)))
                  (progn
                     (xunload (nth (atoi string)app_list))
                     (setq string "")
                  )
               )
               (setq counter (1+ counter))
            )         
            (done_dialog)
         )
      )
   )

   ;set up the dialog identification
   (setq id (load_dialog "ddunload"))

   ;open dialog
   (new_dialog "ddunload" id)

   (start_list "apps")
   (setq app_list (ads))
   (foreach n app_list (add_list n))
   (end_list)

   (action_tile "accept" "(_accept)")
   (start_dialog)
   (unload_dialog id)
   (princ)
); end ddunload.lsp
