; TIP883A: DDE.LSP (C)1993, Allen S. Johnson
; Edit Text, Attributes, and Dimensions

;; combined dd editor for blocks, attdefs & text

(defun C:DDE (/ SP E)
     (while (not E) (setq E (entsel "Select Object: ")))
     (if E (setq SP (cadr E)
               E  (entget (car E))
          )
     )
     (cond ((member (field 0 E) '("TEXT" "ATTDEF")) (command ".ddedit" SP ""))
          ((and (= (field 0 E) "INSERT") (= (field 66 E) 1)) (command ".ddatte" SP))
          ((= (field 0 E) "DIMENSION")  (ddedim E))
          ( T  (prompt "Not Text, Attdef or Block with Attributes...\n"))
     )
(princ))

(defun ddedim (E / DCL_ID DIMTXT EDITXT) 
     (setq DCL_ID (load_dialog "DDE.DCL"))
     (if  (not (new_dialog "DDEDIM" DCL_ID)) (exit))

     (if (member (field 0 E) '("DIMENSION"))
          (progn
               (setq DIMTXT "")
               (set_tile "DEFTXT"    (rtos (actual E)))
               (set_tile "USRTXT"          (field 1 E))
               (set_tile (cond  ((= (field 1 E) ""    )    "DEF")
               ( t (mode_tile "USRTXT" 2) "USR")) (itoa 1))     

               (action_tile "DEF"    "(setq DIMTXT \"\")" )
               (action_tile "USR"    "(setq DIMTXT (get_tile \"USRTXT\")) (mode_tile \"USRTXT\" 2)"    )
               (action_tile "USRTXT" "(setq EDITXT $value DIMTXT EDITXT)  (set_tile \"USR\" (itoa 1))" )

               (if (eq (start_dialog) 1) (echg E 1 DIMTXT))
               (unload_dialog dcl_id)
          )
     )
(princ))

(defun ECHG (ENT FLD VAL)
(entmod (subst (cons FLD VAL) (assoc FLD ENT) ENT)))

(defun FIELD (VAL E)
(cdr (assoc VAL E)))

(defun actual (E / DT DLF SP EP HYP ANG PRO) 
     (setvar "cmdecho" 0)
     (setq SP  (field 13 E) 
          EP  (field 14 e)
          DT  (logand 127 (field 70 E))
          DLF (if (= (field 3 E) "*UNNAMED") 
               (getvar "dimlfac")
               (field 144 (tblsearch "dimstyle" (field 3 E)))
          )
          HYP (distance SP EP)
          ANG (if (= DT 1) 0 (- (angle SP EP) (field 50 E)))
     )
     (abs (* (cos ANG) HYP DLF))              ;returns projected length
); end dde.lsp


