;TIP888.LSP  Smart Polar Array: ARRQ.LSP (C)1993, John K. Sherman

(defun C:ARRQ  (/ ANS CMD OSM LN1 AR1 AR2 AR3 ANG1 
   ANG2 ANG3 C1 QTY) 
   (setq CMD (getvar "CMDECHO"))
   (setvar "CMDECHO" 0)
   (setq OSM (getvar "OSMODE"))
   (setvar "OSMODE" 0)
   (prompt "\nArray is counter-clockwise, ")
   (prompt "Select line accordingly.") 
   (setq LN1 (entsel "\nSelect line to array: "))
   (setq AR1 (entsel "\nSelect arc: "))
   (setq AR2 (entget (car AR1)))
   ; get entity association list
   (setq AR3 (cdr (assoc 0 AR2))) 
   ; get entity type of arc
   (if (= AR3 "POLYLINE")
      (progn
         (prompt "\nWarning: arc is a polyline, explode iT ")
         (prompt "TO use arrq.lsp or use array command")
      )
      (progn
         (setq ANG1 (cdr (assoc 50 (entget (car AR1))))) 
         ; start angle
         (setq ANG2 (cdr (assoc 51 (entget (car AR1))))) 
         ; end angle
         (if (< ANG2 ANG1)
            (setq ANG2 (+ ANG2 (* PI 2))) 
            ;compensates for angles ending => ZERO
         )
         (setq ANG3 (- ANG2 ANG1))                       
         ; difference angle
         (setq ANG3 (* 180.0 (/ ANG3 PI)))
         ; Radians To Degrees
         (setq C1 (cdr (assoc 10 (entget (car AR1)))))   
         ; center of arc
         (initget 0 "Yes No")                            
         ; 0 accepts null return
         (setq ans (getkword 
               "\nDo you want to specify the quantity
               of lines? Yes/<No> "))
               (if (or (= ans "yes") (= ans "Yes")) 
                  (setq QTY (getint "\nEnter Quantity: "))  ; then
                  (progn                                    ; else
                     (setq QTY (cdr (assoc 40 (entget (car AR1)))))
                     ; get radius
                     (setq QTY (/ QTY 3))     
                     ;calculate quantity of lines to array
                     (setq QTY (fix QTY))      ; returns an integer
                     (setq QTY (MAX 3 QTY))
                     ; cures one-element array PROBLEM
                  )                  ; end progn
               )                    ; end if
               (command "ARRAY" LN1 "" "P" C1 QTY ANG3 "Y")
               (setvar "CMDECHO" cmd) ; reset CMDECHO
               (setvar "OSMODE" osm)  ; reset OSMODE
               (redraw)
            )                      ; end progn
         )                        ; end if
         (princ)                  ; end without nil
      ); end arrq.lsp
