;==========================================================
; CPOLYGON.LSP Copyright 1993 by Looking Glass Microproducts
;==========================================================
; Create Selection Set using a Polyline as a Crossing Polygon 
;==========================================================
(defun C:CPOLYGON (/ ERROR PUSHVARS POPVARS SYSVARS OLD-ERROR 
               ITEM BITSET VBLIST SS GET_CPOLYGON SSCPOLYGON)
   ;==========================================================
   ; Error Handler
   (defun ERROR (S)
      (if (not
             (member
                S
                '("Function cancelled" "console break")
             )
          )
         (alert S)
      )
      (POPVARS)
      (princ)
   )
   ;==========================================================
   ; Set and Save System Variables
   (defun PUSHVARS (VLIST)
      (foreach PAIR VLIST
         (setq
            SYSVARS (cons
                       (cons
                          (strcase (car PAIR))
                          (getvar
                             (car PAIR)
                          )
                       )
                       SYSVARS
                    )
         )
         (if (cdr PAIR) (setvar (car PAIR) (cdr PAIR)))
      )
   )
   ;==========================================================
   ; Restore System Variables
   (defun POPVARS ()
      (foreach PAIR SYSVARS (setvar (car PAIR) (cdr PAIR)))
      (setq
         *error* OLD-ERROR
      )
      (setq SYSVARS nil)
   )
   ;==========================================================
   ; Item from association list
   (defun ITEM (A B) (cdr (assoc A B)))
   ;==========================================================
   (defun BITSET (A B) (/= 0 (logand A B)))
   ;==========================================================
   ; Return, in current ucs, a vertex/bulge list 
   ; for a polyline -- ((point . bulge)...) 
   (defun VBLIST (PNAME / ENT ENAME CLOSED PLIST)
      (setq
         ENT    (entget PNAME)
         ENAME  PNAME
         CLOSED (BITSET 1 (ITEM 70 ENT))
      )
      (while (=
                "VERTEX"
                (ITEM
                   0
                   (setq
                      ENAME (entnext ENAME)
                      ENT   (entget ENAME)
                   )
                )
             )
         (if (not (BITSET 16 (ITEM 70 ENT))) ; not a spline control point
            (setq
               V     (cons
                        (trans (ITEM 10 ENT) PNAME 1)
                        (ITEM
                           42
                           ENT
                        )
                     )
               PLIST (cons V PLIST)
            )
         )
      )
      (if CLOSED (setq PLIST (cons (last PLIST) PLIST)))
      (reverse
         PLIST
      )
   )
   ;==========================================================
   ; Return a list of points from a 2D or 3D Polyline
   (defun GET_CPOLYGON (/ ESEL ENAME ENT VLIST)
      (while (and
                (setq
                   ESEL (entsel
                           (strcat
                              "\nSelect Crossing Polygon: "
                           )
                        )
                )
                (setq ENT (entget (setq ENAME (car ESEL))))
                (or
                   (/= "POLYLINE" (ITEM 0 ENT))
                   (BITSET
                      (+ 16 64)
                      (ITEM 70 ENT)
                   )
                   (not (BITSET 1 (ITEM 70 ENT)))
                   (not
                      (apply
                         'and
                         (mapcar
                            '(lambda (X) (zerop (cdr X)))
                            (setq
                               VLIST (VBLIST ENAME)
                            )
                         )
                      )
                   )
                )
             )
         (prompt
            (strcat
               "\nNot a Closed Rectilinear 2D or 3D Polyline."
            )
         )
      )
      (if ENAME (cons ENAME (mapcar 'car VLIST)))
   )
   ;==========================================================
   ; Get Objects inside crossing polygon
   (defun SSCPOLYGON (/ CPOLY)
      (while (null (setq CPOLY (GET_CPOLYGON))))
      (ssget
         "CP"
         (cdr CPOLY)
      )
   )
   ;==========================================================
   ; Body of c:cpolygon  
   (setq OLD-ERROR *error* *error* ERROR)
   (setvar "cmdecho" 0)
   (PUSHVARS
      '(("osmode" . 0) ("highlight" . 0) ("blipmode" . 0))
   )
   (setq SS (SSCPOLYGON))
   (POPVARS)
   (if (/= 0 (getvar "cmdactive"))
      SS
      (progn
         (princ
            (strcat
               (itoa (cond ((sslength SS)) (0)))
               " found"
            )
         )
         (princ)
      )
   )
)
(princ
   (strcat
      "  CPOLYGON.LSP (Copyright 1993 by"
      " Looking Glass Microproducts) loaded."
   )
)
(princ)

