/*    LRAND.C
  This ADS program is makes a random number generator available
  to LISP.

  Program developed by Clayton L. Cranor
                       Denali Computing Services
                       3520 International Way
                       Fairbanks, Alaska
                       (907)451-5003
                       CI$ 71121,773


  Copyright (C) 1991 by Denali Computing Services.

Permission is hereby granted to anyone to do anything with this code.
The template for ADS communication was modified from that supplied by
Autodesk, Inc.  SOOoooo..... :
     ________________________________________________________________________

      Copyright (C) 1990 by Autodesk, Inc.
     
      Permission to use, copy, modify, and distribute this software and its
      documentation for any purpose and without fee is hereby granted.	
   
      THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
      ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
      MERCHANTABILITY ARE HEREBY DISCLAIMED.				    
     ________________________________________________________________________

      Prototype for ADS application.
   
      by Amy Berger	  
      April 16, 1990
  
      Updated July 30, 1990

*/

#include  <string.h>
#include  <stdio.h>
#include  <stdlib.h>
#include  "c:\acad\ads\adslib.h"

static int loadfuncs();


/* MAIN - the main routine */


void main(argc, argv)
  int argc;
  char *argv[];
{
    int stat;
    short scode = RSRSLT;	      /* This is the default result code */

    ads_init(argc, argv);	      /* Initialize the interface */

    for ( ;; ) {		      /* Note loop conditions */

	if ((stat = ads_link(scode)) < 0) {

      printf("LRAND: bad status from ads_link() = %d\n", stat);
	    fflush(stdout);
	    exit(1);
	}

	scode = RSRSLT; 	      /* Default return value */

	/* Check for the following cases here */
	switch (stat) {

  case RQXLOAD:         /* Register ADS external functions.
                           Required for all applications.  */

	    scode = loadfuncs() ? RSRSLT : RSERR;
	    break;

	case RQSUBR:		      /* This case is normally expanded to 
                           select one of the application's
                           external functions, in this case,
                           run the code... */

        switch (ads_getfuncode()) {
            case 0:     /* run the command RAND */
                  static int seed;
                  int i=0;
                  double x,numb=2147483648.0;     /*  this number is 2^31,
                                                      the cyclic period of
                                                      High C's rand()... */
                  seed=rand();
                  srand(seed);
                  x=seed/numb;
                  stat = ads_retreal(x);
                  if (stat < 0)
                    ads_printf("\nAbnormal return from LRAND --");
                  break;

            default:
                  break;
        }
        break;

	default:
	    break;
	}
 }
}


/* LOADFUNCS  --  Define external functions with AutoLISP.

*/

static int loadfuncs()
{
    int status,fcode;

    fcode=0;
    if ((status=ads_defun("rand",fcode)) != RTNORM) {
        ads_fail("Cannot define function RAND().");
        return 0;
    }
    return 1;
}

