; TIP898:  GARMENTS.LSP  Garments for a Closet   (C)1993, Watson Kilbourne

; Draws row of random spaced garments for plan view of wardrobe closets
;
(defun rn () ; Random number generator, from 1.200 to 2.199
   (if (not sd) (setq sd (getvar "DATE")))
   (setq md 65536 mx 25173 nc 13849 sd (rem (+ (* mx sd) nc) md))
   (setq nx (+ 1.2 (/ sd md)))
)
(defun c:GARMENTS (/ ce om bm fr sp ep dx an wd tk p1 p2 p3 p4 px py)
   (setq ce (getvar "CMDECHO"))
   (setq om (getvar "OSMODE"))
   (setq bm (getvar "BLIPMODE"))
   (setq fr (getvar "FILLETRAD"))
   (defun ne (ne)
      (setvar "CMDECHO" ce)
      (setvar "OSMODE" om)
      (setvar "BLIPMODE" bm)
      (setvar "FILLETRAD" fr)
      (princ "\nFunction cancelled ")
      (princ)
   )
   (setq oe *error* *error* ne)
   (setvar "CMDECHO" 0)
   (setvar "OSMODE" 0)
   (while (= sp nil) (setq sp (getpoint "\nStart <CL> of garment row: ")))
   (while (= ep nil) (setq ep (getpoint "\nEnd point of garment row: ")))
   (setq dx (distance sp ep))
   (setq an (angle sp ep))
   (setq wd (getdist "\nEnter width for garments <Default = 1/3 row length>: "))
      (if (= wd nil) (setq wd (/ dx 3)))
   (setvar "BLIPMODE" 0)
   (setvar "FILLETRAD" (/ wd 20))
   (setq tk (/ wd 8)
         p1 (polar sp (+ an (/ pi 2)) (/ wd 2))
         p2 (polar p1 an tk)
         p3 (polar sp (+ an (* pi 1.5)) (/ wd 2))
         p4 (polar p3 an tk)
         px p1 py p3
   )
   (while (not (or (> (distance p2 px) (- dx tk))
                   (> (distance p4 py) (- dx tk ))))
      (command ".PLINE" p1 "W" 0 0 p2 p4 p3 "C" ".FILLET" "P" "L")
      (setq p1 (polar p1 an (* tk 1.2))
            p2 (polar p1 an tk)
            p3 (polar p3 an (* tk (rn)))
            p4 (polar p3 an tk)
      )
      (command ".PLINE" p1 p2 p4 p3 "C" ".FILLET" "P" "L")
      (setq p1 (polar p1 an (* tk (rn)))
            p2 (polar p1 an tk)
            p3 (polar p3 an (* tk 1.2))
            p4 (polar p3 an tk)
      )
   )
   (if (and (< (distance px p2) dx) (< (distance py p4) dx))
       (command ".PLINE" p1 p2 p4 p3 "C" ".FILLET" "P" "L")
   )
   (setvar "FILLETRAD" fr)
   (setvar "BLIPMODE" bm)
   (setvar "OSMODE" om)
   (setvar "CMDECHO" ce)
   (setq *error* oe oe nil)
   (princ)
)

