; XINT.LSP
; Intersection of Lines/Arcs/Circles Snap Program  
; Selects two entities (lines, arcs, or circles) 
; and returns a point of intersection.  
; If NF=0 
; the near point is returned.  
; If NF=1 
; the far point is returned.  
; The point of intersection is found even if the 
; intersection is off the screen.  If the entities will 
; intersect only if they are extended, the theoretical 
; extended intersection will be returned.
; Version: 1.1
; Author: Glenn S. Lyford 5/20/90
; Revised: George E. Zinsmeister 10/20/90
;==============================================
; Parameters
; Name               Definition
;----------------------------------------------
; NF         : flag to indicate whether near or far 
;              intersection is desired.
;              N=0 near point is returned.
;              N=1 far point is returned.
; ---------------------------------------------
; Local Variables
; Variable name      Definition
; ---------------------------------------------
; A1, A2, AL : angles, see documentation figures
; C1, C2     : center points of selected entities
; D          : distance from center to closest point of a
;              line
; DC         : distance from first end point of a line
;              to center
; DP         : distance to desired point from PP
; DR         : sum of radii R1 and R2
; E1, E2     : list returned by entsel for first and 
;              second entities selected
; EL         : utility variable for swapping variables
; EL1, EL2   : association lists for first and second
;              entities selected
; ET         : utility variable for swapping variables
; ET1, ET2   : type (i.e. line, arc, circle) of first 
;              and second entities selected
; P          : returned intersection point; nil is 
;              returned if there is no intersection point
; P1, P2     : intersection points when there are two
;              intersection points
; PL1, PL2   : end points of a line
; PP         : closest point of a line
; PNEAR,PFAR : near/far intersection points
; PS1        : point where first entity is selected
; R          : utility variable for swapping variables
; R1, R2     : radii of selected entities
; S          : (/ (+ R1 R2 DC) 2), see documentation figures
;-----------------------------------------------
;
(defun XINT (NF / A1 A2 AL C1 C2 D DC DP DR E1 E2 EL
             EL1 EL2 ET ET1 ET2 P P1 P2 PL1 PL2 PP 
             PS1 R R1 R2 S)
  (setq  E1 (entsel "intersection of\n"))
  (if E1
    (progn
      (setq E2 (entsel "and\n"))  ; select first entity
      (if E2
        (progn
          (setq
            PS1 (cadr E1)  ; get point at which first 
                           ; entity was selected
            EL1 (entget (car E1))   ; association list for
                                    ; first entity
            EL2 (entget (car E2))   ; association list for
                                    ; second entity
            ET1 (cdr (assoc 0 EL1)) ; type of first entity
            ET2 (cdr (assoc 0 EL2)) ; type of second entity
          )
; swap data if arc/circle and line so that 
; line is first entity - this
; eliminates some code needed later
          (if (and (/= ET1 "LINE") (= ET2 "LINE"))
            (setq ET ET1 EL EL1 ET1 ET2 EL1 EL2 ET2 
                  ET EL2 EL))
          (cond
            ((and (= ET1 "LINE") (= ET2 "LINE")) 
                  (load "LL_INT"))
            ((and (= ET1 "LINE") (or (= ET2 "ARC") 
                  (= ET2 "CIRCLE")))
              (load "LA_INT"))
            ((and (or (= ET1 "ARC") (= ET1 "CIRCLE"))
               (or (= ET2 "ARC") (= ET2 "CIRCLE"))) 
                   (load "AA_INT"))
            (T (setq P nil))
          )
        ) ;end progn
        (prompt "No entity selected\n")
      ) ;end E2 if
    )  ;end progn
    (prompt "No entity selected\n")
  )
); end defun xint.lsp

