;TIP #858:  AREA.LSP (c)1993, BILL BRATT

; This lisp routine is by: Bill Bratt  12-27-92  
; The idea of these functions is for architectural plans, to  
; simplify doing square footages.
; Both functions put the square footage in the center of the room
; on layer a-sq_ft-1. This layer can be turned off or frozen.
;
; AREAW.LSP   This function will calculate the area of a rectangle 
;             with a window. The area must be parallel to the
;             horizontal.
; AREA3P.LSP  This function will calculate the area of a rectangle 
;             by picking 3 points. The area may be at an angle to
;             the horizontal.
;
;****************************************************************
;                            AREAW.LSP                                            
; This function will calculate the area of a rectangle with window.
;********************************************************************
(defun C:AREAW (/ PNT1 PNT2 PNT3 PNT4 PNT5)
   (start_function)
   (command "layer" "m" "a-sq_ft-1" "c" "1" "" "")
   (setvar "osmode" 32)  ;intersection
   (prompt "\nOSNAP is set at Intersection")
   (setq PNT1 (getpoint "\nPick Lower Left corner of Area  "))
   (prompt "\nOSNAP is set at Intersection\n")
   (setq PNT3 (getcorner  "\nPick Upper Right corner of Area " PNT1))
   (setq PNT2 (list (car PNT1)(cadr PNT3)))
   (setq PNT4 (list (car PNT3)(cadr PNT1)))
   (command "area" PNT1 PNT2 PNT3 PNT4 PNT1 "")
   (setq H_DIST (distance PNT1 PNT4))
   (setq V_DIST (distance PNT1 PNT2))
   (setq HH_DIST(/ H_DIST 2.0))
   (setq HV_DIST(/ V_DIST 2.0))
   (setq PNT5 (list (+ (car PNT1) HH_DIST) (+ (cadr PNT1 ) HV_DIST)))
   (setq RECT_AREA (getvar "area"))
   (setq RECT_AREA (/ RECT_AREA 144))
   (setq RECT_AREA (rtos RECT_AREA 2 2))
   (setq SF " sq. ft.")
   (setq RECT_AREA (strcat RECT_AREA SF))
   (setq TXT_SIZE  (getvar "textsize"))
   (command "text" "m" PNT5 TXT_SIZE "0" RECT_AREA ) (terpri)
   (end_function)
)

;********************************************************************
;                            AREA3P.LSP                                            
; This function will calculate the area of a rectangle with 3 points.
;********************************************************************
(defun C:AREA3P (/ PNT1 PNT2 PNT3 PNT4 PNT5)
   (start_function)
   (command "layer" "m" "a-sq_ft-1" "c" "1" "" "")
   (setvar "osmode" 32)  ;intersection
   (prompt "\nOsnap is set at Intersection")
   (setq PNT1 (getpoint "\nPick Lower Left Corner of Room: "))
   (prompt "\nOsnap is set at Intersection")
   (setq PNT2 (getpoint "\nPick Upper Left Corner of Room: " PNT1))
   (prompt "\nOsnap is set at Intersection")
   (setq PNT4 (getpoint "\nPick Lower Right Corner of Room: " PNT1))
   (setq V_DIST (distance PNT1 PNT2))
   (setq VA (angle PNT1 PNT2))
   (setq PNT3 (polar PNT4 VA V_DIST))
   (command "area" PNT1 PNT2 PNT3 PNT4 PNT1 "")
   (setq PNT5 (inters PNT1 PNT3 PNT2 PNT4 nil))
   (setq RECT_AREA (getvar "area"))
   (setq RECT_AREA (/ RECT_AREA 144))
   (setq RECT_AREA (rtos RECT_AREA 2 2))
   (setq SF " sq. ft.")
   (setq RECT_AREA (strcat RECT_AREA SF))
   (setq TXT_SIZE  (getvar "textsize"))
   (command "text" "m" PNT5 TXT_SIZE "0" RECT_AREA ) (terpri)
   (end_function)
)
;****************************************************************
; Function resets beginning values if an error occurs or (ctrl-C).
(defun *error* (MSG)
   (if (/= MSG "Function cancelled")
      (princ (strcat "\nAutoLISP Error:  " MSG))
      (terpri)
   )
   (setvar "cmdecho" SAVE_CMDE )
   (setvar "blipmode" SAVE_BLIP )
   (setvar "orthomode" SAVE_ORTHO )
   (setvar "osmode" SAVE_OSMODE )
   (command
      "layer" "s" CL ""
      "redraw"
   )
)  ; END OF FUNCTION
;****************************************************************
(defun start_function ()
   (graphscr)
   (setq CL (getvar "clayer"))
   (setq SAVE_CMDE (getvar "cmdecho"))
   (setq SAVE_BLIP (getvar "blipmode"))
   (setq SAVE_ORTHO (getvar "orthomode"))
   (setq SAVE_OSMODE (getvar "osmode"))
   (setvar "cmdecho" 0)
   (setvar "blipmode" 0)
   (setvar "orthomode" 0)             ;Ortho off
   (setvar "osmode" 0)   ; none
)   ;end of function
;****************************************************************
(defun end_function ()
   (setvar "cmdecho" SAVE_CMDE )
   (setvar "blipmode" SAVE_BLIP )
   (setvar "orthomode" SAVE_ORTHO )
   (setvar "osmode" SAVE_OSMODE )
   (command
      "layer" "s" CL ""
      "redraw"
   ) ; end of command
   (mnu)
   (princ)
)   ; end of function

(defun mnu ()
   (princ "\nMNU OPTIONS: (Type MNU to see options)") 
   (princ "\n  AREAW - calculates area w/ window parallel to horizontal.")
   (princ "\n  AREA3P- calculates area w/ 3 points - area can be angled to horizontal.")
   (princ)
)   ;End of Function
(defun C:MNU ()
   (mnu)
   (princ)
)   ;End of Function
(mnu)
(princ)
; end
