; BALLOON.LSP  A program to place text centered in a circle at the end
; of a leader.  A useful customization would be to have the function
; switch to a specific layer.
; Invoke the function after it is loaded by entering BLN at any
; Autocad prompt.
; The text height is the same as the current dimension text height - DIMTXT
; The diameter of the circle is 3/8 multiplied by DIMSCALE
; The current text style must not have a set height

(defun C:BLN ( / Scale Radius Po Pe Pm Txt)
  (setvar "CMDECHO" 0)
  (setq Scale (getvar "DIMSCALE")
        Radius (* 0.15625 Scale)                  ; radius of the bubble
        Po (getpoint "\nStart of Leader: ")
        Pe (getpoint Po "\nEnd of Leader: ")
        Pm (polar Pe (angle Po Pe) Radius))      ; center of bubble and text
  (command "dim1" "leader" Po Pe ^C^C)
  (command "circle" Pm Radius)
  (Setq Txt (getstring "\nEnter Part Number: "))
  (command "text" "M" Pm (* Scale (getvar "DIMTXT")) 0 Txt)
  (princ)
) ; end BLN
