(defun c:lne ( / pt pt1 pt2 plist)
  (setvar"cmdecho" 0)
  (setq pt (getpoint "\nFrom point: "))
  (initget "Polar Delta Undo")
  (while
     (setq pt1
       (getpoint pt "\nPolar/Delta/Undo/To point: "))
     (setq f 0)
     (if (not (member pt1 '("Polar" "Delta" "Undo")))
       (progn
         (command "line" pt pt1 "")
         (setq pt2 pt)
         (setq pt pt1))
       (cond
          (  (eq pt1 "Polar")
             (c:polarl pt))
          (  (eq pt1 "Delta")
             (c:deltal pt))
          (  (eq pt1 "Undo")
             (command ".erase" "l" "")
             (setq pt pt2 pt1 pt2))))
     (initget "Polar Delta Undo")
  )
  (princ)
)

(defun c:polarl (pt / ro alfa)
  (command "ortho" "off")
  (setvar "cmdecho"0)(terpri)(terpri)(terpri)
  (while
    (setq ro (getdist pt "\nDistance: "))
    (setq alfa (getangle pt "\nDirection: "))
    (setq pt1 (polar pt alfa ro))
    (command "line" pt pt1 "")
    (setq pt2 pt)
    (setq pt pt1)
  )
  (princ)
)

(defun c:deltal (pt / dx dy )
  (command "ortho" "on")
  (setvar"cmdecho"0)
  (while
    (setq dx (getdist pt "\nDelta X: "))
    (setq dy (getdist pt "\nDelta Y: "))
    (setq pt1 (mapcar '+ pt (list dx dy 0.0)))
    (command "line" pt pt1 "")
    (setq pt2 pt)
    (setq pt pt1)
  )
  (princ)
)
