;dis.lsp
(defun C:DIS (/ P1 P2 DI ANG P1X P1Y P1Z P2X P2Y P2Z
                CMDE DELTAX DELTAY DELTAZ FLDIS ZANG PB PC)

(defun *ERROR* (msg)
		(setvar "CMDECHO" CMDE)  
		(prin1)
)
	(setq CMDE (getvar "CMDECHO"))
	(setvar "CMDECHO" 0)

(defun DISTO ()
  (setq
    DI (distance P1 P2)
    ANG (angle P1 P2)
    P1X (car P1)
    P1Y (cadr P1)
    P1Z (caddr P1)
    P2X (car P2)
    P2Y (cadr P2)
    P2Z (caddr P2)
    DELTAX (- P2X P1X)
    DELTAY (- P2Y P1Y)
    DELTAZ (- P2Z P1Z)
    FLDIS (distance (list P1X P1Y) (list P2X P2Y))
    PB (polar P1 (* -1 (/ pi 2)) DELTAZ)
    PC (polar PB PI FLDIS)
    ZANG (angle PC P1)
  )
(command "DIST" P1 P2)
; ** Eliminate this line for Release 11
  (princ
  (strcat "\nDistance = " (rtos DI)
    ", Angle in XY Plane = " (angtos ANG)
    ", Angle from XY Plane = " (angtos ZANG)
    "\nDelta X = " (rtos DELTAX)
    ", Delta Y = " (rtos DELTAY)
    ", Delta Z = " (rtos DELTAZ)
  )
  )
)

	(setq P1 (getpoint "First point: "))
	(if (= P1 nil) (setq P1 (getvar "LASTPOINT")))
	(setq P2 (getpoint P1 " Second point: "))
	(DISTO)
	(setvar "LASTPOINT" P2)
	(defun CONT ()
		(setq P1 P2 P2 (getpoint P1 "\nSecond point: "))
		(DISTO)
		(setvar "LASTPOINT" P2)
	)
	(while (/= P2 nil) (CONT))
	(setvar "CMDECHO" CMDE)
	(princ)  
)
