 (defun M_ELIM (A / T1 T2 X U)
  (cond
    ((= (length (car A)) 2) A) ;;elimination completed
    (t ;;reduce matrix
       ;;find max car of A, switch with front of matrix
       (setq T1 (apply 'max (mapcar '(lambda (X) (abs (car X))) A))
             T1 (if (assoc T1 A) (assoc T1 A) (assoc (* -1 T1) A))
             T2 (car A)
       )
       (if (not (equal T1 T2))
         (setq A (cdr A)
               A (subst T2 T1 A)
               A (cons T1 A)
         )
       )
       ;; eliminate in remaining members.
       (foreach U (cdr A)
         (setq T2 (/ (car U) (car T1))
               T2 (mapcar '(lambda (T3 T4) (- T4 (* T3 T2))) T1 U)
               A (subst T2 U A)
         )
       )
       ;; reduce order and return result of further elimination...
       (cons T1
             (mapcar 
                '(lambda (T2) 
                   (cons 0.0 T2)) 
                (M_ELIM (mapcar 'cdr (cdr A)))))
    )
  )
)
  (defun M_BACKSUB (A / U V)
  (cond
    ((= (length (car A)) 2)
       (list (/ (cadr (car A)) (car (car A))))
    )
    (t
       (setq U (car A)
             V (M_BACKSUB (mapcar 'cdr (cdr A)))
             W (/ (- (last U) (apply '+ (mapcar '* V (cdr U)))) (car U))
       )
       (cons W V)
    )
  ))

;;  Test 1 example equation set
s;;  10x1 +  x2 -  5x3 = 1
;; -20x1 + 3x2 + 20x3 = 2
;;   5x1 + 3x2 +  5x3 = 6
(setq TEST1 '(( 10.0 1.0 -5.0 1.0)
              (-20.0 3.0 20.0 2.0)
              (  5.0 3.0  5.0 6.0))

     ;;Test 2 example equation set
     ;;  8.3x1 -  3.2x2          - 2.7x4 =  15.3293
     ;; -3.2x1 + 13.7x2 -  5.6x3         =  22.4903
     ;;        -  5.6x2 + 10.5x3 - 2.7x4 = -28.53
     ;; -2.7x1          -  2.7x3 + 9.2x4 =   8.1167
          TEST2 '(( 8.3 -3.2  0.0 -2.7  15.3293)
              (-3.2 13.7 -5.6  0.0  22.4903)
              ( 0.0 -5.6 10.5 -2.7 -28.53)
              (-2.7  0.0 -2.7  9.2   8.1167))
     ;; Calculate tension in members of a statically determinate truss
      TEST3 '((0.7071 0.0  0.0 -1.0 -0.866 0.0  0.0  0.0  0.0      0.0)
              (0.7071 0.0  1.0  0.0  0.5   0.0  0.0  0.0  0.0  -1000.0)
              (0.0    1.0  0.0  0.0  0.0  -1.0  0.0  0.0  0.0      0.0)
              (0.0    0.0 -1.0  0.0  0.0   0.0  0.0  0.0  0.0      0.0) 
              (0.0    0.0  0.0  0.0  0.0   0.0  1.0  0.0  0.7071 500.0)
              (0.0    0.0  0.0  1.0  0.0   0.0  0.0  0.0 -0.7071   0.0)
              (0.0    0.0  0.0  0.0  0.866 1.0  0.0 -1.0  0.0      0.0)
              (0.0    0.0  0.0  0.0 -0.5   0.0 -1.0  0.0  0.0   -500.0)
              (0.0    0.0  0.0  0.0  0.0   0.0  0.0  1.0  0.7071   0.0))
)
;; Typing (GAUSS TEST1) or (GAUSS TEST2) will display
;; the orginal matrix, the reduced triangular matrix, and the
;; calculated values of the varialbes x1...xN.
(defun GAUSS (A / B C)
  (foreach TMP A
    (prompt (strcat "\n"
                    (rtos (car TMP))
            ))
    (foreach TMP2 (cdr TMP)
      (prompt (strcat "\t" (rtos TMP2))))
  )

  (setq B (M_ELIM A))

  (prompt "\n\nElimination matrix result")
  (foreach TMP B
    (prompt (strcat "\n"
                    (rtos (car TMP))
            ))
    (foreach TMP2 (cdr TMP)
      (prompt (strcat "\t" (rtos TMP2))))
  )

  (setq C (M_BACKSUB B))

  (prompt "\nBack substitution result")
  (print C)
  ;;
  (princ)
)
