
	OUTPUT	"lib.o"
	OPTIMIZE
	LINKABLE

 	CODE	"TEXT"


*
*	_C_LMUL	LONG SIGNED MULTIPLY
*
*	MULTIPLIES TWO LONG OPERANDS ON THE STACK AND RETURNS THE
*	RESULT ON THE STACK WITH NO GARBAGE.
*

	XDEF	_C_LMUL

_C_LMUL:
	MOVEM.L	D0-D3,-(A7)		*SAVE REGISTERS
	MOVE.L	20(A7),D0		*GET PARAMETER 1
	MOVE.W	D0,D2
	MOVE.W	D0,D1
	EXT.L	D1
	SWAP	D1
	SWAP	D0
	SUB.W	D0,D1
	MOVE.W	26(A7),D0		*GET MSW OF PARAMETER 2
	MOVE.W	D0,D3
	EXT.L	D3
	SWAP	D3
	SUB.L	24(A7),D3		*SUBTRACT LSW OF PARAMETER 2
	MULS	D0,D1
	MULS	D2,D3
	ADD.W	D1,D3
	MULS	D2,D0
	SWAP	D0
	SUB.W	D3,D0
	SWAP	D0
	MOVE.L	D0,24(A7)
	MOVE.L	16(A7),20(A7)		*MOVEE RETURN ADDRESS
	MOVEM.L	(A7)+,D0-D3		*RESTORE REGISTERS
	ADD.W	#4,A7			*ADJUST STACK
	RTS



*
*	_C_SWITCH - EXECUTE C SWITCH STATEMENT
*
*	THE SWITCH TABLE IS ENCODED AS FOLLOWS:
*
*		LONG	LABEL1,CASE1
*		LONG	LABEL2,CASE2
*		LONG	LABEL3,CASE3
*		... FOR ALL CASES
*		LONG	0,DEFAULTCASE
*
*	THE CASE VARIABLE IS PASSED IN D0
*

	XDEF	_C_SWITCH

_C_SWITCH:
	MOVE.L	(A7)+,A0		*GET TABLE ADDRESS
_C_SW1:
	MOVE.L	(A0)+,A1		*GET A LABEL
	MOVE.L	A1,D1			*TEST IT FOR DEFAULT
	BEQ.S	_C_SW2			*JUMP IF DEFAULT CASE
	CMP.L	(A0)+,D0		*SEE IF THIS CASE
	BNE	_C_SW1			*NEXT CASE IF NOT
	JMP	(A1)			*JUMP TO CASE
_C_SW2:
        MOVE.L  (A0),A0 *GET DEFAULT ADDRESS.
        JMP     (A0)    *JUMP TO DEFAULT CASE.

        END


