********************************************************************
*: COMMAND FILE telWord.PRG                                        *
*: Author: LOUIS HEMMI (STARSHIP LATIMER AND TORTILLA FACTORY)     *
*:         309 Avondale - Houston, Texas 77006                     *
*:         713/526-4530                                            *
*:                                                                 *
*: Date:                                                           *
*: 06/89 - program started                                         *
*: 05/94 - Clipper 5 syntax (05-04-94 10:13am)                     *
*:                                                                 *
*: System: LOUPHONE                                                *
*: Purpose:                                                        *
*: USED TO GENERATE THE POSSIBLE COMBINATIONS OF THE LETTERS       *
*: ASSOCIATED WITH NUMBERS ON THE TELEPHONE KEYPAD.                *
*: NOTE: THE LETTERS 'Q' AND 'Z' ARE NOT INCLUDED on the telephone *
*:       keypad, and the numbers '1' & '0' are not translated.     *
*:                                                                 *
*: There are 15,309 iterations to yield 2,187 possible combinations*
*:                                                                 *
*: There are no duplicate combinations, except for those using     *
*:  0 or 1, since there are six occurrences of these two           *
*:  "characters." It would be easy to save these to a .dbf, but    *
*:  what I do is print to a text file, and scroll through to find  *
*:  interesting combinations. A SOUNDEX approach might make this   *
*:  easier to use, but I doubt that there is a way to automate the *
*:  selection process.                                             *
*:                                                                 *
*: Suggestions for improvements would be greatly appreciated !     *
*:                                                                 *
********************************************************************
FUNCTION MAIN
  LOCAL GETLIST
  SETCOLOR("W+/B,GR+,B")
  CLEAR
  do while lastkey()#27
    interface()
    clear
  enddo
return(nil)
*-----------------------------------------------------------*
FUNCTION TELWORD(In_Phone)
  LOCAL GETLIST
  LOCAL J                                        // COUNTER
  LOCAL nPROCESSED                               // COUNT TOTAL 7-LETTER COMBINATIONS
  LOCAL cWord [7,1]                              // component of a single word
  LOCAL cCurWord                                 // current 'word'
  LOCAL I[7,1]                                   // COUNTER
  LOCAL X[10,1]                                  // THREE CHARACTERS ASSOCIATED WITH EACH NUMERAL
  LOCAL KeyLetters := "000111ABCDEFGHIJKLMNOPRSTUVWXY" // LETTERS ON TELEPHONE KEYPAD
  LOCAL nPOSITION := 1
  nPROCESSED := 0
  ****IN_PHONE := "5264530"                      // USER-INPUT TELEPHONE NUMBER TO PROCESS
  * Set up the array of three-character trios for each numeral
  if empty(In_Phone)
  return(0)                                      // value of nProcessed
endif
FOR J = 1 TO 10
  X[J]=SUBS(KeyLetters,nPOSITION,3)
  nPOSITION := nPOSITION + 3
NEXT J

FOR I[1] = 1 TO 3
  FOR I[2] = 1 TO 3
    FOR I[3] = 1 TO 3
      FOR I[4] = 1 TO 3
        FOR I[5] = 1 TO 3
          FOR I[6] = 1 TO 3
            FOR I[7] = 1 TO 3
              FOR J = 1 TO 7
                if nextkey()=27 // allow processing abort
                return (nil)
              endif
              ?? SUBS(X[VAL(SUBS(In_Phone,J,1))+1],I[J],1)
              cWord[J] := SUBS(X[VAL(SUBS(In_Phone,J,1))+1],I[J],1)
            NEXT J
/*                  nProcessed := nProcessed + 1
                    cCurWord := cWord[1]+;
                    cWord[2] +;
                    cWord[3] +;
                    cWord[4] +;
                    cWord[5] +;
                    cWord[6] +;
                    cWord[7]
                    altd()
                    with this section, you could save each combination
                    to a record, provided you had a database with a
                    character field of length 7. I saw no need for my
                    purposes [Louis Hemmi]
*/
            ?? SPACE(2)
          NEXT I[7]
          ?? SPACE(2)
        NEXT I[6]
        ?                   &&                   //// HERE'S THE CARRIAGE RETURN
      NEXT I[5]
    NEXT I[4]
  NEXT I[3]
NEXT I[2]
NEXT I[1]
RETURN (nil)
** end of function telword
** end of function telword
*------------------------------------------------------------------*
FUNCTION INTERFACE
  LOCAL GETLIST
  LOCAL mDEST,DONE,In_Phone,mFILE
  local nProcessed                               // returned from telnum(In_Phone)
  DO WHILE lastkey() # 27
    CLEAR
    mDEST := 'S'
    In_Phone := space(7)
    @02,10 TO 12,69 DOUBLE
    @04,14 SAY "      During Processing, Hit <ESC> To Interrupt     "
    @23,00 SAY PADC(" telWord: Give Me a Number, I'll Give You 2,187 Words ",MaxCol(),"")
    @06,14 SAY "Please input a 7-digit telephone number  "  GET In_Phone PICTURE "#######"
    @08,14 SAY "TO P)rinter S)creen F)ile Q)uit ? " GET MDEST  PICTURE "@!" VALID (MDEST $ "PSFQ")
    READ
    *
    IF MDEST = "Q"
      In_Phone := ""
      EXIT
    ENDIF                                        && MDEST = "Q"
    *
    if lastkey()=27
      exit
    endif
    IF ( VAL(In_Phone) = 0 .AND. LASTKEY() # 27 .AND. NEXTKEY() # 27 )  .OR. ( LEN(TRIM(In_Phone)) # 7 )
      tone(2000,3)
      @23,00 SAY SPACE(MaxCol())
      @23,00 SAY padc(" INVALID ENTRY ",MaxCol())
      INKEY(0)
      LOOP
    ENDIF                                        && ( VAL(In_Phone) = 0 .AND. LASTKEY() # 27
    IF VAL(In_Phone) = 0 .AND. (LASTKEY() = 27 .OR. NEXTKEY() = 27)
      ? CHR(7)
      @23,00 SAY SPACE(MaxCol())
      @23,00 SAY padc(" TRY AGAIN ",MaxCol())
      INKEY(2)
      LOOP
    ENDIF                                        && VAL(In_Phone) = 0 .AND. (LASTKEY() = 27
    *
    DO CASE
      *
    CASE MDEST = "P"
      SET PRINTER TO
      SET DEVICE TO PRINT
      SET PRINT ON
      ? "Report for number->"+In_Phone
      ?
      *
    CASE MDEST = 'F'
      STORE "telWord.TXT" +SPACE(34) TO MFILE
      @14,00 SAY "Enter Destination Filename  " GET MFILE
      READ
      SET ALTERNATE TO (mFILE)  &&               //// SINCE WE'RE NOT USING @SAYS
      SET ALTERNATE ON          &&               //// SINCE WE'RE NOT USING @SAYS
      ? "Report for number->"+In_Phone
      ?
      *
    ENDCASE

    telword(In_Phone)
  enddo

  SET ALTERNATE OFF
return(nil)
*
* END OF COMMAND FILE telWord.PRG
* END OF COMMAND FILE telWord.PRG
