



                                       Preface


      The Foxpro SAC System is a set of programs designed to record and
      track the Saguaro Astronomy Club Database.  The SAC System is written
      in a dBASE IV compatible language called Foxpro.

      Among the SAC System features is the ability to run in a Multi-user
      environment.  It can access records by either object name or by memo
      notes.  The SAC system also will let you keep user logs.

      SunShow utilities are included in the SAC system.  These utilities
      allow the SAC system to display and print graphic pictures stored in
      the SAC database or on file.

      An IBM personal computer (80386 or better) is recommended.  For
      improved performance, it is highly recommended that the user obtain
      at least three megabytes of extended memory.  A color monitor and a
      mouse are also recommended.

      Considerable effort was expended to make the user reference manual as
      complete as possible.  However, this documentation is in no way to be
      considered an instructive guide to MS-DOS, the Saguaro Astronomy Club
      Database, Astronomy, or Foxpro.  Many reference texts are available
      on the market that explain the MS-DOS operating system and dBASE
      programming.  If you need more information, your reference materials
      should include one of these texts.

      My advice is to read the contents of this user manual.  Familiarize
      yourself with its information.  If you have any questions concerning
      this application, feel free to write or call.



























                                     - Page 1 -







                             Copyright/License/Warranty




      This document and the program Foxpro SAC ("the software") are
      copyrighted by the author.  The copyright owner hereby licenses you
      to use the software given these restrictions:


           o  the program shall be supplied in its original, unmodified
              form, which includes this documentation;

           o  for-profit use without a license is prohibited;

           o  the program may not be included - or bundled - with other
              goods or services.  Exceptions may be granted upon written
              request only.

           o  no fee is charged beyond a reasonable amount for the media
              and handling ($10 maximum suggested);


           There is no warranty of any kind.  The copyright owner may not
           be held liable for any damages, including any lost profits or
           other incidental or consequential damages arising out of or
           inability to use the software.  By using the software, you agree
           to this.


      Shareware

           SAC is distributed as Shareware.  It is not free software.
           You are free to try it and make copies for others.  If you
           continue to use this application beyond a reasonable trial
           period, you are required to register it with the distributor
           and author.


      ASP Ombudsman

           This program is produced by a member of the Association of
           Shareware Professionals (ASP).  ASP wants to make sure that the
           shareware principle works for you.  If you are unable to resolve
           a shareware-related problem with an ASP member by contacting the
           member directly, ASP may be able to help.  The ASP Ombudsman can
           help you resolve a dispute or problem with an ASP member, but
           does not provide technical support for members' products.

           Please write to the ASP Ombudsman at 545 Grover Road, Muskegon,
           MI 49442-9427 USA, FAX 616-788-2765 or send a CompuServe message
           via CompuServe Mail to ASP Ombudsman 70007,3536.



           Copyright (C) 1987 Dennis Allen.  All rights reserved.  All
           trademarks mentioned herein belong to their respective owners.

                                     - Page 2 -







                                SunShow Image Toolkit


      The SAC System does include utilities from the SunShow Image Toolkit.
      These utilities gives us the ability to display and print GIF files.
      There are, however, limitations you MUST be aware of:


      1)  If the SHOWGIF utility attempts to display a GIF picture having a
      pixel resolution larger than your best video mode, a computer lock-up
      is possible.

      There are many 1024x768 pixel resolution GIF files in the SAC System.
      If you video card cannot handle 1024x768 pixels, you can prevent a
      lockup by removing all SHOWGIF.* files from your system.


      Note:  The SunShow Image Toolkit does include a utility called
      VIEWGIF.EXE.  This utility, while capable of displaying any size GIF
      file, cannot presently work within Foxpro.


      2)  The SunShow utilities can only display and print GIF files
      containing a global color map.  If SHOWGIF tries to display a GIF
      with no global color map, a blank screen is displayed.


      3)  The current version of SunShow cannot print interlaced GIF files.
      About a third of the SAC System GIF files are interlaced.  We are
      hoping the next release of SunShow will solve this problem.


      4)  The SunShow utilities does NOT give a progress report in loading
      a graphic file for display.  Just a blank screen.  The speed that
      graphic file will load and display depends on your machine.


      5)  If you are running in multi-user mode, use the same video driver
      (VESA for example), for each user.  The current version of Sunshow
      cannot assign different video drivers to different users.


      I've tried to check all the GIF files in the SAC System to ensure
      they're within 1024x768 pixel resolutions and contain a global color
      map.  If you do a find bad GIF file, however, please write or call.













                                     - Page 3 -







                                  TABLE OF CONTENTS


      Preface                                                    1
      Copyright/License/Warranty                                 2
      SunShow Image Toolkit                                      3
      Introduction                                               6
          Manual Content                                         6
          Notation Convention                                    7
      Invoking SAC                                               8
          Maintaining SAC Deep Sky Database                     11
              Updating a SAC Deep Sky Record                    15
              Creating a Log Record                             16
          Maintaining SAC Double Star Database                  17
          Quit                                                  17
      Printing SAC Database                                     18
          Printing SAC Database                                 19
          Quit                                                  20
      System Setup                                              21
          Expression Builder                                    22
          Printer Control Codes                                 22
          Change Color Set                                      25
              Customizing Color Sets                            25
          Problems & Suggestions                                25
          Default Settings                                      26
          SunShow Video Setup                                   26
          SunShow Print Setup                                   26
          Display/Print Manual                                  28
          Quit                                                  28
      Utilities                                                 29
          Access GIF's to .\GIF                                 30
          Convert RA/Dec <-> Alt/Az                             30
          Burham Coordinates                                    30
          Epoch Coordinates                                     31
          Double Star Separation                                31
          Rebuilding Indices                                    32
          Initializing Databases                                32
          Sorting Databases                                     32
      Quit to DOS                                               33



















                                     - Page 4 -







                                  TABLE OF CONTENTS


      Appendices                                                34
          Appendix A/ Generic Editor                            34
          Appendix A-1/ System Menu                             41
              Sysmenu edit                                      41
              Foxpro Calculator                                 41
              Foxpro Calendar                                   41
              Foxpro DOS Shell                                  42
              Printer Eject                                     42
              Video Mode                                        42
              Print Mode                                        42
          Appendix B/ Data Files                                43
              Import Files                                      45
              Backup/Restore Data files                         46
          Appendix C/ Error Handling                            47
              Disk Space                                        47
              Printer not Ready                                 47
              Multi-User Errors                                 48
              Syntax Error                                      48
          Appendix D/ Configuring Application                   49
              Foxpro Runtime Unit                               49
                  FOXR.EXE                                      49
                  FOXRW.EXE                                     50
              CONFIG.FP                                         50
                  EMS                                           51
                  MEMLIMIT                                      51
                  PROGWORK                                      51
                  RESOURCE                                      52
                  TIME                                          52
              FOXPRO.INI                                        53
                  DATA                                          53
                  FONTNAME                                      54
                  FONTSIZE                                      54
                  FONTSTYLE                                     54
                  GIF                                           55
                  INIT                                          55
                  LAST                                          55
                  MULT                                          55
                  PROG                                          56
                  RECALL                                        56
                  SYSMENU                                       56
                  TEMP                                          57
                  TERM                                          57
              FOXUSER.DBF                                       58
              FOXUSER2.DBF                                      58
              Printer Codes                                     59
              Record Filters                                    59
              Configuring Sideways                              59
      Glossary                                                  60
      Index                                                     63






                                     - Page 5 -







                                    Introduction


      The Foxpro SAC System is a set of programs designed to record and
      track the Saguaro Astronomy Club Database.  The Foxpro SAC System is
      written in a dBASE IV compatible language called Foxpro.

      Before continuing, we should explain a couple of terms.  We refer to
      the Saguaro Astronomy Club database as the SAC database.  We will be
      refering to the Foxpro SAC System as the SAC System, or simply as
      "SAC".

      When we refer to an "editor", it is a program module that allows us
      to add, delete, or change database records. The word "edit" means to
      update, maintain, or change a database record.

      When we refer to a "window", it is a section of the screen that is
      receiving output.  Windows may overlap each other on the screen.
      They are characterized by a double line border and usually have some
      sort of title.

      A "record filter" determines the access allowed to a database.  Only
      those records, defined by a record filter, may be viewed, edited, or
      printed.  Record filters are created/selected using an "expression
      builder".

      The term "GIF" refers to the Compu-Serve Graphic Information Format.
      A graphic picture file format.  The graphic file extension (GIF, PCX,
      TIF, etc.) actually used depends on the graphic file viewer.  The SAC
      system, however, will use GIF files exclusively.

      A "memo field" is a field that can store text or files.  All
      databases in the SAC System contain two memo fields.  One for notes
      and one for GIF files.  Note memo fields may be edited by the user.
      GIF memo fields must first be copied to disk before they can be
      viewed.

      The following sections of this manual will describe all available
      menu options, one at a time.  Each menu option will be illustrated.
      Appendices are included to describe all the files in the SAC system,
      the generic operations of editors, error handling, optimizing SAC,
      and establishing a backup procedure.
















                                     - Page 6 -







                                    Introduction


                              Notation Conventions


      CAPITAL LETTERS

           Capital letters indicates a command.  During command entry, this
           text should be entered exactly as it appears.  Unless specified,
           any command may be in upper or lower-case letters.

      lower case

           Parameters to commands are usually typed in lower-case
           characters.

      Ellipsis "..."

           The ellipsis represent repetition of a previous item.

      Single Key "[ ]"

           The single key command is represented by the characters "[" and
           "]".

      Control keys

           Control keys are designated with a "[Ctrl]-" followed by the
           name of another key (for example: [Ctrl]-[S]).  To enter a
           control key, press [Ctrl] on your keyboard and, while holding it
           down, press the additional key.  On some Foxpro menus, control
           keys are designated with a "^" followed by the name of another
           key (for example: ^[End] for [Ctrl]-[End]).

      Carriage Return

           Depending on your keyboard, the same key may be represented by
           different descriptions.  For example, the carriage return may be
           represented as [Enter], [Return], or [Bent arrow symbol].  For
           the most part, this should not be a problem.  Make sure,
           however, that you understand the function of each key so that
           you understand how they appear in this manual.

      Alternate key

           On an IBM PC keyboard, alternate keys are designated with a
           "[Alt]-" followed by the name of another key (for example:
           [Alt]-[V]).  To enter a control key, press [Alt] on your
           keyboard and, while holding it down, press the additional key.

           On a Macintosh keyboard, [Alt] is produced by holding down both
           the [Ctrl] key and the [Option] key.  To produce [Alt]-[V], for
           example, you must press [Ctrl], [Option], and [V] at the same
           time.



                                     - Page 7 -







                                 Invoking SAC System


      The purpose of this section is to help you get started using SAC.
      Your computer should be running and you should be at the DOS prompt.

      You should have already installed the SAC application and the Foxpro
      runtime unit.  You should also have a functional backup procedure
      (See Appendix B).

      Note:  If you are importing the SAC deep sky and/or double star
      databases, see Appendix B/Import files.

      To invoke SAC, at the DOS prompt, type:

           SAC

      and press [Enter].  Since this is the first time you invoked SAC, you
      should see the following screen:


      +--------------------------------------------------------------------+
      |                                                                    |
       ------------------------- Default Settings ------------------------
      |                                                                    |
                     SAC Word for Windows (Form Data File) :
      |                                                                    |
                     Longitude (DDD.MMSS):
                     Latitude  (DDD.MMSS):
                     Time Zone           :
                     Daylight Saving Time:
                     Epoch Year          :
      |                                                                    |
      |--------------------------------------------------------------------|
               Press [ESC] to abort and return to main menu...
      +--------------------------------------------------------------------+


      This screen defines the default SAC settings and can be found in the
      system setup menu.  For now, press [Enter] to ignore the first line.

      The next five input fields are needed to configure SAC to your
      location.  The time zone is the number of hours from UT (example: 5
      for EST).  Specifying Daylight Saving will subtract one hour from the
      time zone.

      Press [F10] when done.  The next screen you see will be the SunShow
      Video Setup.  This screen is available in the system setup menu.
      Simply type in the number of your video card and press [Enter].

      Warning:  If you are running in multi-user mode, use the same video
      driver (VESA for example), for each user.  The current version of
      Sunshow cannot assign different video drivers to different users.





                                     - Page 8 -







                                 Invoking SAC System


      The final setup screen will configure the SunShow printer utility.
      This screen is also found in the system setup menu.  Select your
      printer and press [Enter].  There are other options, but just press
      [F10] to complete the screen.

      After all setup screens are completed, you should see is the
      following:


      +--------------------------------------------------------------------+
                              SAC Database, Version 01.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       -----------------------  M A I N    M E N U -----------------------
      |                                                                    |
                           E - Edit SAC  Databases
      |                                                                    |
                           P - Print SAC Databases
      |                                                                    |
                           S - System Setup
      |                                                                    |
                           U - Utilities
      |                                                                    |
                           Q - Quit this program
      |                                                                    |
      |--------------------------------------------------------------------|
                                 Your selection:
      +--------------------------------------------------------------------+


      This is our normal initial screen.  Option 'E' allows you to create
      and maintain all SAC deep sky and double star records.  Option 'P'
      will print SAC deep sky and double star reports.  Option 'S' allows
      you to change printer control codes and system default settings.
      Option 'U' contain miscellaneous options that allow the user to
      maintain SAC.  Option 'Q' will return you to the DOS prompt.

      By default, SAC runs in a single-user mode.  If you are running in a
      Multi-user environment, you will need to configure SAC to run Multi-
      user mode.  Please refer to Appendix D for more information.

      There are three ways to select an option.  One way is simply to press
      the highlighted key, (example: press [S] for system setup).  Another
      way is to press the up and down cursor keys to highlight the desired
      option.  Then, by pressing [Enter], the highlighted option is
      selected.

      Note:  If you have a mouse, you can move the mouse cursor to the
      desired option.  Pressing the left mouse button will then select the
      option.





                                     - Page 9 -







                                 Invoking SAC System


                           Maintaining Sample Records


      Editing SAC records is simple.  At the main menu, press [E].  The
      following screen will appear:


      +--------------------------------------------------------------------+
                            SAC Database, Version 01.00.00
                        (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ----------------------  E D I T    M E N U ------------------------
      |                                                                    |
                          1 - Edit SAC Deep Sky Database
                          2 - Edit SAC Double Star Database
                          3 - Edit SAC Variable Star Database
                          4 - Edit Lunar Object Database
                          5 - Edit Celestial Object Database
      |                                                                    |
                          Q - Return to main menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+

      This is the edit menu.  Here, all components of the SAC system can be
      maintained.  Option '1' will allow you to maintain the SAC deep sky
      database.  Option '2' will allow you to maintain the SAC double star
      database.  Option '3' will allow you to maintain the SAC variable
      star database.  Option '4' will allow you to maintain the Lunar
      object database.  Option '5' will allow you to maintain the planetary
      object database.  Option 'Q' will return you to the main menu.

      Before continuing, notice that the edit window is slightly smaller
      than the main menu window.  This is a built-in feature.  This feature
      allows the user to see how far he/she is into the program.  It is
      intended to give the user a sense of depth.


















                                     - Page 10 -







                          Maintaining SAC Deep Sky Database


      Maintaining SAC deep sky records is simple.  At the edit menu, press
      [1].  The following screen will appear:


      +--------------------------------------------------------------------+
                            SAC Database, Version 01.00.00
                        (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ---------------------- SAC Deep Sky Database ----------------------
       Object Name:                 Other Names:
       Type of Object:
       Constellation:                    L.S.T.:
       Right Ascension :            Azimuth  (DDD.MMSS):
       Declination     :            Altitude (DDD.MMSS):
       Magnitude  :                 Magnitude of Brightest Star:
       Description:
       Size       :                 Class:         Source:
       # of Stars :                 U 2000     :
       Clubs:                       Tirion 2000:
       ------------------------------ Notes ------------------------------
      |                                                                    |
      |--------------------------------------------------------------------|
            Edit Log      1 Create File 2 Print File  3 View File
                          Create Memo
            Toggle Index (None)         Toggle Order (Ascending)
            Add    Browse Delete Find   Goto   Help   Update    Quit
      +--------------------------------------------------------------------+


      This screen is typical of a generic editor used with Foxpro.  At the
      bottom of the screen are all the one-character options available to
      the user.

      Like the main menu, there are three ways of selecting a function.  By
      direct keystroke, by the cursor keys and [Enter], or by the mouse.
      Before continuing, we will briefly describe each function.

                                  Add Function

      Pressing [A] will allow you to add a record to the current database.
      The cursor will be positioned on the first field in the record.
      Whether adding or updating a record, there only a few keystrokes you
      need to know.

      You can move the cursor from field to field using the arrow keys.
      For instance, the Right arrow, the Down arrow, and the Enter key,
      moves the cursor forward one field at a time.  The up arrow moves the
      cursor back one field.

      Note:  If you have a mouse, you also can move from field to field.
      Simply move the mouse cursor to the desired field and press the left
      mouse button.



                                     - Page 11 -







                          Maintaining SAC Deep Sky Database


      The [Home] key will move the cursor to the beginning of a field.  If
      it is already there, [Home] will move the cursor to the first field
      in the screen.  [End] will move the cursor to the end of the field.
      If it is already there, [End] will move the cursor to the last field
      in the screen.

      If you need more information on any field, press [F1].  If there is
      help information, a help window will be displayed.  The help window
      will remain until you press either [Esc] or [F10].

      Note:  If you have a mouse, move the mouse cursor to the desired
      field.  Press the right mouse button, once to move to the field, and
      once for the help text.

      After you have entered your data, moving the cursor beyond the last
      input field on the screen tells the editor to accept the record.  You
      can either use the arrow keys to move the cursor, or press [F10].
      [Esc] will abort any updating, returning the screen to its original
      condition.

                                 Browse Function

      Pressing [B] will invoke the Foxpro browse function.  The browse
      function will display as many database records as will fit on one
      screen.  You use the arrow keys to move from record to record.
      Pressing [F10] will return you to the edit screen.  The browse
      function is explained in more detail in Appendix A.

                                 Delete Function

      Pressing [D] will allow you to delete the currently displayed record.
      You will be prompted whether you are sure.  Pressing [Y] deletes the
      record from the database.

                                  Find Function

      Pressing [F] will invoke the find function.  This option is a quick
      way of finding a desired record.  If the current database is indexed
      by object name, this option will prompt you for the object.  Type the
      desired object and press [Enter].  If found, the object will be
      displayed as well as the current azimuth/altitude location.  You
      could then delete it, or update it.

      A couple of notes:  If the [T]oggle option is set to (none), no index
      is active.  You must press [T] to activate one of this SAC indices.

      Also, the find function is capable of wild-carding.  Very useful when
      used with the notes index.  See Appendix A for more information.







                                     - Page 12 -







                          Maintaining SAC Deep Sky Database


                                  Goto Function

      Pressing [G] will create a pop-up menu.  This popup menu allows the
      user to display different records in the current database.  Press [F]
      for the first record in the database.  Press [L] for the last record.
      Press [N] for the next record.  Press [P] for the previous record.
      For example, if the current record is customer 5, pressing [P] will
      display customer 4.  The goto window remains active until you press
      [Esc].

                                  Help Function

      Pressing [H] will display a summary of commands used in the edit
      menu.  Pressing any key after that returns you to the edit menu.

                              Toggle Index Function

      For a database with multiple indices, the toggle option will be
      displayed.  The toggle option allows the user to change what index
      will be used with the [F]ind option.  The current index is displayed
      in parenthesis.

      For example, if the current index is (none), no index is active.
      Pressing [T] will activate the object name index.  Upon pressing [F],
      the user will be prompted for the object name.  Pressing [T] will
      change the current index back to other names.  Pressing [T] again
      will change the index to notes.  Press [T] once more will return you
      to (none).

                              Toggle Order Function

      This option toggles the order of the current index.  The current
      order is displayed in parenthesis.

      For example, if the current order is ascending, pressing [O] will
      toggle the order to descending.  If the current index is by object
      name, then 'ALPHA' will come after 'BETA'.  Pressing [O] again will
      change the current index back to ascending.

                                 Update Function

      Pressing [U] allows you to update the currently displayed record.
      Like the add function, pressing [F10] will complete the update.
      Pressing [Esc] will abort the update.


                                    Edit Log

      Pressing [L] allows the user to add/maintain log reports for the
      current database record.  This option will be explained later.





                                     - Page 13 -







                          Maintaining SAC Deep Sky Database


                                1 Create GIF File

      If there is a GIF memo field, corresponding to the current record,
      the user may press [1] to create a graphic picture file from it.
      This option is not available if there is already an existing graphic
      picture file.

                                2 Print GIF File

      If there is a graphic picture file, corresponding to the current
      record, the user may press [2] to print it.  There will be a slight
      delay while the file is printed.  Use option [8], of the system setup
      menu, to configure the SunShow print utility.

                                 3 View GIF File

      If there is a graphic picture file, corresponding to the current
      record, the user may press [3] to display it.  Use option [7], of the
      system setup menu, to configure the SunShow video utility.  Press
      [Esc] to exit the GIF viewer.

                                 Create GIF Memo

      Every record has a GIF memo field.  A GIF memo field can contain a
      graphic picture.  If the GIF memo field does not contain a graphic
      picture the user may press [C] to create one.  The user will be
      prompted for the GIF file name.  Pressing [Enter] accepts the file
      name.  If the file is found in the GIF directory, it's copied into
      the GIF memo field.  Once stored in a GIF memo field, a GIF picture
      becomes part of the record.

                                 Delete GIF Memo

      If there is already a graphic picture in the GIF memo field, the user
      may press [e] to delete it.  The user is prompted whether he/she is
      sure.  If the user presses [Y], the graphic picture in the GIF memo
      field is deleted.

                                 Modify GIF Memo

      If there is already a graphic picture in the GIF memo field, the user
      may press [M] to modify it.  The user will be prompted for the GIF
      file name.  If found, the picture is displayed.  After exiting the
      viewer, the user will be asked if the new picture is correct.  If the
      user presses [Y], the old picture is over-written.

                                 Print GIF Memo

      If there is already a graphic picture in the GIF memo field, the user
      may press [P] to display it.  There will be a slight delay while the
      GIF memo field is printed.  Use option [8], of the system setup menu,
      to configure the SunShow print utility.



                                     - Page 14 -







                          Maintaining SAC Deep Sky Database


                                  View GIF Memo

      If there is already a graphic picture in the GIF memo field, the user
      may press [V] to display it.  Use option [7], of the system setup
      menu, to configure the SunShow video utility.  Press [Esc] to exit
      the GIF viewer.

      Note:  An asterisk in the upper right hand corner of the screen
      indicates a GIF memo image is present.  Also note that this option is
      only available if the GIF viewer exists.

                                  Quit Function

      Finally, pressing [Q] will return you the menu that invoked the
      editor.  For more information on the capabilities of this type of
      editor, see Appendix A.


                          Updating SAC Deep Sky Record


      The SAC deep sky database should already contain about 10,000
      records.  Pressing [U] will place you into the update mode.  To
      understand the SAC deep sky database, move the cursor to each input
      field.  At each input field, press [F1] for help information.  Since
      we do not want to update, press [Esc] to abort the update function.

      Note:  If you press [F1] on the Right Ascension field, you will see a
      help window.  If you then press [F10], the Burham coordinate
      converter will be displayed.  Simply type the Burham 1950 coordinates
      and press [Enter].  The right Ascension and declination fields will
      then contain the converted J2000 coordinates.























                                     - Page 15 -







                                Creating a Log Record


      From the SAC deep sky editor, press [L] for the log editor.  You
      should see the following screen:


      +--------------------------------------------------------------------+
                            SAC Database, Version 01.00.00
                        (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ------------------------- SAC LOG Editor --------------------------
       Object Name:                 Other Names:
      |                                                                    |
       Log Date:   /  /             Log Time:   :  :
      |                                                                    |
      |                                                                    |
      |--------------------------------------------------------------------|
                          Create Memo
                                        Toggle Order (Ascending)
            Add    Browse Delete Find   Goto   Help   Update    Quit
      +--------------------------------------------------------------------+


      The edit functions are exactly the same as in the SAC deep sky
      editor.  Use this editor to add or maintain log reports on the
      current SAC deep sky record.  You may even use the Create/View GIF
      options to include a drawing with your log notes.

      To create a log, press [A] to add.  You will see the current date and
      time.  The memo window "notes" will be displayed.  Type in your
      notes, then press [F10] to save.  You will be prompted for another
      record.  Press [Esc] to abort the add mode.

      If you wish to change the date and time, press [U] for the update
      mode.  Since we don't have any more notes, press [Q] to return to the
      SAC editor.  From the SAC editor, press [Q] to quit to the main menu.





















                                     - Page 16 -







                        Maintaining SAC Double Star Database


      At the edit menu, we also can edit the SAC double star database.  At
      the edit menu, press [2].  You should see the following screen:


      +--------------------------------------------------------------------+
                            SAC Database, Version 01.00.00
                        (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       -------------------- SAC Double Star Database ---------------------
       Name:                        Star:
       Constellation:                    L.S.T.:
       Right Ascension :            Azimuth  (DDD.MMSS):
       Declination     :            Altitude (DDD.MMSS):
       Magnitude of Primary:        Magnitude of Secondary:
       Component:                   Separation:    Position Angle:
       Spectrum:                    Year      :    ADS Catalog:
                                    U 2000     :
       Clubs:                       Tirion 2000:
       ------------------------------ Notes ------------------------------
      |                                                                    |
      |--------------------------------------------------------------------|
            Edit Log      1 Create File 2 Print File  3 Print File
                          Create Memo
              Toggle Index (None)       Toggle Order (Ascending)
            Add    Browse Delete Find   Goto   Help   Update    Quit
      +--------------------------------------------------------------------+


      The edit functions are exactly the same as in the SAC Deep Sky
      editor.  You may create/delete/view GIF pictures.  You may toggle
      between the Name, Star, Notes, or no index at all.  You also may
      maintain an observer's log for each record.  Since we do not, press
      [Q] to return to the edit menu.


                                      Quit


      Well, that's all you need to know about the SAC editors.  Later, you
      can experiment with finding, deleting, and updating records.  For
      now, simply press [Q] to return to the main menu.














                                     - Page 17 -







                                 Print SAC Database


      From the previous examples, you should now be at the main menu.  We
      will be printing a report, so make sure your printer is connected and
      on-line.  If you wish to print GIF pictures, make sure your screen
      capture program is active.  If not, you may wish to skip this
      section.  If your printer is ready, press [P].  You should see the
      following screen:


      +--------------------------------------------------------------------+
                           SAC Database, Version 01.00.00
                      (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ------------------------- P R I N T    M E N U --------------------
      |                                                                    |
                           1 - SAC Deep Sky Reports
                           2 - SAC Double Star Reports
                           3 - Variable Star Reports
                           4 - Lunar Object Reports
                           5 - Celestial Object Reports
      |                                                                    |
                           Q - Return to main menu
      |                                                                    |
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      Options '1' through '5' allow you to print all the reports available
      in the SAC database.  Option 'Q' returns you to the main menu.

      Upon a selection, you will be given a choice of reports.  For
      example, select option '1'.  You should see the following:


      +--------------------------------------------------------------------+
                           1 - 80 Column Deep Sky Report
                           2 - 132 Column Deep Sky Report
                           3 - Word for Windows (Data file)
                           4 - 80 Column Deep Sky Log Report
                           Q - Return to report menu
      +--------------------------------------------------------------------+


      Option '1' will print the SAC deep sky database, one record per page.
      The user may wish to print GIFs as well1.  Option '2' will print a
      132 column report.  Option '3' will create a Word for Windows print
      merge File.  Option '4' will print the deep sky log report.  Option
      'Q' will return you to the report menu.


      ____________________
      1 See option [8], of the system setup menu, to configure the SunShow
      print utility.

                                     - Page 18 -







                                 Print SAC Database


                              Printing SAC Database


      Just to show you how simple it is, press [2].  You should see the
      following screen:

      +--------------------------------------------------------------------+
                            SAC Database, Version 01.00.00
                        (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ----------------------- 132 Column Report -------------------------
       Object Name:                 Other Names:
       Type of Object:
       Constellation:
       Right Ascension :            Azimuth  (DDD.MMSS):     /  /
       Declination     :            Altitude (DDD.MMSS):     :  :
       Magnitude  :                 Magnitude of Brightest Star:
       Description:
       Size       :                 Class:         Source:
       # of Stars :                 U 2000     :
       Clubs:                       Tirion 2000:
      |                                                                    |
       Starting Log Date:           Ending Log Date:
      |                                                                    |
       Numeric Factor:
      |                                                                    |
                 Index File:                    Index Order:
      |--------------------------------------------------------------------|
                  Print   Screen    Help   Update    Quit
      +--------------------------------------------------------------------+


      You are given an option grid.  The option grid will look like the SAC
      edit window.  The option grid prompts will determine what records
      will be printed and in what order.

      For example, specifying "NGC" for object name will print all records
      containing "NGC".  In addition, specifying "CMA" for type will print
      all "NGC" records within the constellation Canis Major.

      You may specify the Azimuth and/or Altitude of an object.  You will,
      of course, need to specify the date and time the object will be at
      the location.

      Which brings us to the numeric factor.  On all numeric fields (i.e.
      Declination, Magnitude, Altitude, etc.) you may specify a numeric
      factor.  For example, say you specified an altitude of 20 and a
      numeric factor of 10.  That means you want all objects with an
      altitude between 10 and 30 degrees.

      Another example:  Say you specified a Magnitude of 7 and a numeric
      factor of 2.  Therefore, only objects with a magnitude between 5 and
      9 will be printed.


                                     - Page 19 -







                                 Print SAC Database


      From this option grid, you are also allowed to select the index file
      and index order.  These field are the push button equivalent to the
      toggle index/toggle order found in the SAC editor.

      For the log reports only, there are two additional fields.  They
      allow the user to specify the starting and ending log dates.

      Press [F10] to complete the option grid.  You will be given a menu of
      choices, depending on the report.  You can press [U] to update the
      option grid.  You can press [H] for help, or press [Q] to quit to the
      print menu.

      Pressing [S] for screen mode, or [P] for print mode, will start
      creating a print file.  During this operation, you can abort by
      pressing [Esc].

      If you pressed [S], you will see the report displayed upon the
      screen.  Press [Pgup] or [Pgdn] to view the report.  Press [Esc] or
      [F10] to return to the option grid.

      Pressing [P] will copy the report to the printer device specified in
      the system setup.  If you need to adjust the printer controls, use
      option S of the main menu.  See System setup.

      When you are finished, press [Q] to return to the print menu.

      Note:  Some popup menu options, such as the word for windows (data
      file) option, send output directly to a file.  Instead of offering
      [S]creen and [P]rinter, therefore, the option grid will allow you to
      press [C] to continue.

      That is why 80 Column Reports prompt you if you're printing GIFs.  If
      you want to print GIF's, the option grid must send output directly to
      the printer.  It cannot, therefore, give you [S]creen or [P]rint.


                                      Quit


      Keep in mind, the option grid works on top of any record filter
      selected from the system setup.  Explore the two facilities.  You may
      find them a very powerful combination.  When you have experimented
      enough, press [Q] at the print menu to return to the main menu.












                                     - Page 20 -







                                    System Setup


      Option 'S' of the main menu offers several facilities.  Among them,
      the ability to change printer control codes.  Upon pressing [S] at
      the main menu, you should see the following:


      +--------------------------------------------------------------------+
                              SAC Database, Version 01.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       -------------------  S Y S T E M   S E T U P  ---------------------
      |                                                                    |
                           1 - Edit Expression Builder
                           2 - Edit Printer Control Codes
                           3 - Change Color Set
                           4 - Problems & Suggestions
                           5 - All about.."
                           6 - System Default Settings.."
                           7 - SunShow Video Setup.."
                           8 - SunShow Printer Setup.."
      |                                                                    |
                           M - Display/Print Manual
      |                                                                    |
                           Q - Quit this Menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                 Your selection:
      +--------------------------------------------------------------------+


      Option '1' will invoke the expression builder.  The expression
      builder creates a record filter.  A record filter defines those
      records that can be viewed, edited, and printed.

      Option '2' allows you to change printer control codes.

      Option '3' will allow you to change the current color set.  If you
      don't like the colors used by SAC, this option lets you change them.

      Option '4' will allow you to leave a message to the application
      author.  Messages can point out a problem or can offer a suggestion.

      Option '5' will display status information about this application.
      What version of Foxpro is running, about much memory is available,
      and the different kinds of application modes (Multi-user, debug,
      system administration).

      Option '6' allows you to specify the longitude and latitude of your
      location.  Such information is needed to convert Right
      Ascension/Declination to Azimuth/Altitude.

      Options '7' & '8' allow you to configure SunShow's video and printer
      utilities.



                                     - Page 21 -







                                    System Setup


      Option 'M' allows you to display and/or print the user manual.
      Option 'Q' allows you to return to the main menu.


                               Expression Builder


      The expression builder allows you to select a record filter from a
      list of record filters.  A record filter defines those records in a
      database that can be viewed, edited, or printed.  The record filter
      is in effect only while your application is running.  Filters can be
      redefined as often as desired.

      At the system setup menu, press [1].  Upon entry, you are prompted
      for one of the SAC databases.  For our example, select the deep sky
      database and press [Enter].  You will be given a list of existing
      record filters.  Chose an existing filter.  For example, move the
      cursor to the filter named "GIF's".  Press [Enter].  The filter
      "GIF's" is now active and will allow you to view only deep sky
      records containing a GIF picture.

      You also might want to create a record filter.  At the system setup
      menu, press [1].  Press [F10] for the menu and press "N" to create an
      expression.  Enter "No GIF's" for the name of your expression.  You
      will be given a choice of the custom expression builder, or the
      Foxpro expression builder.  Unless you know how to use the Foxpro
      expression builder, select the custom builder.

      You will be given a popup list of available field names.  Select the
      field "GIF".  The next popup will display the action that can be
      taken on "GIF".  Select the popup "Empty".

      The record filter is displayed.  You may add, delete, or edit phrases
      in the expression.  But just press [F10] to accept the current one.

      That's all there is to it!  You've created a filter that views only
      deep sky records that do not contain a GIF image.  Press [Enter] to
      select the filter.  You will be returned to the system setup menu.
      If you don't want to use this filter, simply return to the expression
      builder.  Press "S" for the deep sky database, and then press [Esc]
      to abort.

      Note:  If you are running on a network, see Appendix D:  Record
      filters.


                              Printer Control Codes


      At the system setup menu, press [2].  The following screen will be
      displayed:




                                     - Page 22 -







                                    System Setup


      +--------------------------------------------------------------------+
                           SAC Database, Version 01.00.00
                      (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------- S Y S T E M   S E T U P ---------------------
      |                                                                    |
                     Printer Name         : Default
                     Printer Device       : PRN
                     Printer Default      : CHR(27)+"@"
                     Printer Condense On  :
                     Printer 10 cpi       :
                     Printer 12 cpi       :
                     Printer Bold      On :
                     Printer Bold      Off:
                     Printer Underline On :
                     Printer Underline Off:
      |                                                                    |
                     Number of Straight Lines/Page:
                     Number of Sideways Lines/Page:
      |                                                                    |
                     Print in Draft mode?
      |--------------------------------------------------------------------|
               Press [ESC] to abort and return to main menu...
      +--------------------------------------------------------------------+

                                  Printer Name


      The printer name is simply identifies the current configuration.  If
      the database P_CODES.DBF is available, you may press [F1] for a list
      of all available printers.  A selection changes all printer codes to
      the selected printer.  Press [F10] to complete the screen.

                                 Printer Device

      The printer device defines where output is to be sent.  Typically,
      you would use LPT1 or LPT2.  In the Multi-user environment, this
      option also allows you to define the network spooler.

















                                     - Page 23 -







                                    System Setup


                                  Printer Codes

      If you have an 80 column printer, define the control codes required
      by your printer to invoke compressed printing.  These control codes
      are sometimes referred to as 16.7 or 17 characters per inch.  Also
      define the control codes required to cancel condensed printing.
      These control codes are sometimes referred to as the default.  SAC
      will use these codes for reports normally requiring a 132 column
      printer.  Printer control codes are specified with dBASE expressions
      such as:

      CHR(27) + CHR(64)

      or:


      CHR(27) + '@'

      In general, most printer manuals give printer control strings as
      BASIC programming statements using the BASIC function CHR$().  The
      dBASE CHR() function is identical, so simply removing the "$" sign
      from the examples in your printer manual should do the job.

      Note:  If you press [F1], you will see a browse popup of available
      printers.  Simply select your printer and press [Enter].  All printer
      codes will be converted to the selected printer.

                             Straight lines per page

      To this day, there are some printers that do not accept form feeds.
      So rather than asking for form feed code, SAC asks for the number of
      lines per page.  Most printers use 66 lines.  Laser printers usually
      need 57 lines.

                                    Sideways

      It is sometimes necessary to print large reports using a sideways
      print utility.  So in case it is ever needed, the system setup
      prompts for the number of lines to print sideways.  For an 80 column
      printer, use 53 lines. For a 132 column printer, use 90 lines.

                                   Draft mode

      A report option grid creates a report file.  From the option grid,
      there are two ways to print this file:  Regular mode and draft mode.
      In regular mode the report file is read and printed, one line at a
      time.  The user may press [Esc] to abort.  If the printer becomes
      off-line, the user can usually restart at the point of interruption.

      In draft mode, the report file is copied directly to the print
      device.  In MS-DOS windows, draft mode will bypass the print spooler.
      Draft mode, however, does not allow the user to press [Esc] or nor
      does it allow the user to restart a print job.


                                     - Page 24 -







                                    System Setup


      The mode you use depend on your needs.  Regular mode is the most
      reliable method.  Under MS-DOS windows, draft mode is the quickest.


                                Change Color Set


      A Foxpro color set defines all color attributes used by this
      application.  Upon pressing [3] at the system setup, a popup menu
      will display all the different color sets available.  These color
      sets reside within the Foxpro resource file (FOXUSER.DBF).  Use the
      cursor keys to highlight the desired color set.  Then, select by
      pressing [Enter].

                             Customizing Color Sets


      A new feature has been added to the color selector.  The user now has
      the ability to customize colors.  Once a color has been selected, the
      color selector will search for a second Foxpro resource file
      (FOXUSER2.DBF).  In this file, color sets are stored in ASCII text
      format.

      If you are a system administrator, you will be prompted whether to
      edit the ASCII text of your selected color set.  The text layout is
      simple.  Twelve lines for the twelve color schemes used by this
      application.  Each line contain ten color pairs.  A color pair
      "W*/B+", for example, would denote a white foreground, blue
      background ("*" denotes blinking and "+" denotes intensity).  For a
      description of color pairs used within a scheme, check the color
      picker portion of the Foxpro manual.

      Experiment with different color sets.  Note that the top of the
      screen may not change color until you exit and reenter the
      application.  Be warned, however.  The color set becomes permanent
      until the next time you select a different color.

      Note:  The second Foxpro resource file can only be created and edited
      by the system administrator.


                             Problems & Suggestions


      Upon pressing [4], you will be presented with a memo window.  Type
      any message you wish to leave the application programmer.  Press
      [F10] to complete the message, or [Esc] to abort.  Your message will
      be placed in the Foxpro error file (FOXERR.DBF).

      If you have already created messages, you may wish to modify them.  A
      browse, indicating the date and time of each message, will be
      displayed.  Select the desired message record.  Then, press [Ctrl]-
      [Pgdn] to expand the message window.


                                     - Page 25 -







                                    System Setup



                                Default Settings


      At the setup menu, press [6].  The following screen will be
      displayed:


      +--------------------------------------------------------------------+
                           SAC Database, Version 01.00.00
                      (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------- S Y S T E M   S E T U P ---------------------
      |                                                                    |
                     SAC Word for Windows (Form Data File) :
      |                                                                    |
                     Graphic file extension                :
      |                                                                    |
                     Longitude (DDD.MMSS):
                     Latitude  (DDD.MMSS):
                     Time Zone           :
                     Daylight Saving Time:
                     Epoch Year          :
      |                                                                    |
      |--------------------------------------------------------------------|
               Press [ESC] to abort and return to main menu...
      +--------------------------------------------------------------------+


      Most of the reports, from the print menu, allows you create a SAC
      deep sky word for window print merge file.  The first input field
      specifies the file name.

      The next five input fields are needed to convert RA/Dec into
      Azimuth/Altitude.  The time zone is the number of hours from UT.
      Specifying Daylight Saving will subtract one hour from the time zone.


                               SunShow Video Setup


      At the system setup menu, press [7].  A selection of video cards will
      be displayed.  Type in the number of the video card and press
      [Enter].  You will be returned to the system setup menu.


                               SunShow Print Setup


      At the system setup menu, press [8].  You will be given a popup of
      available printers.  Selecting 'none', of course, will prevent you
      from printing any graphic files.



                                     - Page 26 -







                                    System Setup


      The following screen should then appear:


      +--------------------------------------------------------------------+
                           SAC Database, Version 01.00.00
                      (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ------------------- SunShow Printer Setup ---------------------
      |                                                                    |
                     Desired Printer
      |                                                                    |
                     Brightness (-255 to 255):
      |                                                                    |
                     Dots to inch (75, 100, 150 or 300):
      |                                                                    |
                     Left Coordinate:
                     Top Coordinate :
                     New Width  in Inches:
                     New Height in Inches:
      |                                                                    |
                     Include Form Feed ?
      |                                                                    |
      |--------------------------------------------------------------------|
               Press [ESC] to abort and return to main menu...
      +--------------------------------------------------------------------+


      You can adjust the brightness and the number of dot's per inch.
      Press [Enter] and [Enter] to accept the defaults.

      The next four fields are in inches.  The left and top coordinates
      determines output margins.  The new width and height determine
      picture dimension.  The final prompt will throw a form feed after the
      picture is printed.  Press [F10] to complete the screen.  You will be
      returned to the system setup menu.




















                                     - Page 27 -







                                    System Setup



                              Display/Print Manual



      Option 'M', of the system menu, will display the user manual.  You
      may use [PgUp] or [PgDn] to view various pages.  You may print the
      entire user manual by pressing [Alt]-P].  Press [Esc] to return to
      the system setup menu.


                                      Quit


      Before leaving the system setup menu, a reminder.  Record filters
      remain in effect only for the duration of the application.  Color
      sets and printer control codes, on the other hand, are permanent.
      When you have experimented enough, press [Q] at the system setup menu
      to return to the main menu.




































                                     - Page 28 -







                                      Utilities


      Option 'U' of the main menu provides the miscellaneous options needed
      to maintain the SAC Database system.  Upon pressing [U] at the main
      menu, you should see the following:


      +--------------------------------------------------------------------+
                              SAC Database, Version 01.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       -------------------  U T I L I T Y    M E N U ---------------------
      |                                                                    |
                           1 - Access GIF's in .\GIF
                           2 - Convert RA/DEC <--> ALT/AZ
                           3 - Convert Burham Coordinate
                           4 - Convert RA/DEC Epochs
                           5 - Compute Double Star Separation
      |                                                                    |
                           A - Rebuild indices
                           B - Initialize Databases
                           C - Sort Databases
      |                                                                    |
                           Q - Quit this Menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                 Your selection:
      +--------------------------------------------------------------------+


      Option '1' will copy graphic pictures, stored in GIF memo fields, to
      the hard disk for viewing by your graphic file viewer.  Option '2'
      will allow you to convert Right Ascension/Declination coordinates to
      Altitude/Azimuth and visa versa.  Option '3' will convert Burham
      coordinates, epoch 1950, to epoch 2000 coordinates.  Option '4' will
      let you convert the coordinates of any object from one epoch to
      another.  Option '5' provides the arc second separation of any two
      objects, given the right ascension/declination.

      Option 'A' reconstructs all system indices in the event of a crash or
      other strange system behavior.  Option 'A' also removes deleted
      records, thereby reclaiming disk space.

      Option 'B' will allow you to reset any or all database files in the
      SAC system.  Option 'Q' will return you to the main menu.

      Option 'C' will allow you to sort all databases, in the SAC system,
      by right ascension/declination.  Option 'Q' will return you to the
      main menu.

      Note:  Options 'A', 'B', & 'C' are available only in single-user
      mode.  Options 'B' & 'C' are only available to the system
      administrator.  See Appendix D.




                                     - Page 29 -







                                      Utilities




                              Access GIF's to .\GIF


      Option '1' will give you a list of choices.  You may:  Copy, move,
      append, delete, or view.

      Copy will copy graphic files, in GIF memo fields, into the graphic
      directory.

      Move will copy graphic files, in GIF memo fields, into the graphic
      directory.  The graphic files, however, from deleted from GIF memo
      fields.

      Append will copy graphic files, in the graphic directory, into GIF
      memo fields.

      Delete simply deletes graphic file from GIF memo fields.

      View simply allows you to view graphic files in the graphic
      directory.

      After selecting your option, another popup will appear.  This popup
      allows you to select which database to perform the selected function.
      Press [Enter] to select the desired database, or press [Esc] to
      abort.


                           Convert RA/Dec <--> Alt/Az


      Option '2' will allow you to convert Right Ascension/Declination
      coordinates to Altitude/Azimuth and visa versa.

      Conversion is simple.  To convert RA/Dec coordinates to
      Altitude/Azimuth, simply type RA/Dec coordinates and press [F10].  To
      convert Altitude/Azimuth coordinates, simply type the Alt/Az
      coordinates and press [F10].  To exit, press [Esc].

      Note.  This option uses the same procedures that display Alt/Az
      locations within the SAC editor.


                               Burham Coordinates


      Option '3' will prompt you for Burham coordinates, format
      "9999n9999".  Epoch 2000 coordinates will then be displayed.  Press
      [Esc] to return to the utility menu.





                                     - Page 30 -







                                      Utilities


                                Epoch Coordinates


      Option '4' will prompt you for Right ascension/Declination
      coordinates, the epoch of these coordinates (old epoch), and the
      conversion epoch (new epoch).  The coordinates will then be converted
      to the new epoch.  Press [Esc] to return to the utility menu.


                             Double Star Separation


      Option '5' will prompt you for Right ascension/Declination
      coordinates of your two objects.  The arc second separation will then
      be displayed.  Press [Esc] to return to the utility menu.








































                                     - Page 31 -







                                      Utilities




                               Rebuilding Indices


      Option 'A' of the utility menu will reconstruct all system indices in
      the event of a crash or other strange system behavior.  You will be
      prompted whether to continue.  Upon pressing [Y], all indices will be
      rebuilt.  Option 'A' also removes deleted records, thereby reclaiming
      disk space.  You will then be returned to the utility menu1.


                             Initializing Databases


      Option 'B' of the utility menu will allow you to "reset" any or all
      database files in the SAC system by removing all data from them.  You
      probably will want to use this option after completing the sample
      entries and exercises in this manual, so you can begin fresh with
      "real" data.

      Upon pressing [B] at the utility menu, you will be prompted whether
      to reset each database file, one at a time.  You will then be
      returned to the utility menu2.


                                Sorting Databases


      All SAC databases usually come sorted by right ascension/Declination.
      That is why you need not use an index to browse by RA/DEC.  All new
      records, however, are appended to the bottom of a database.  It may
      be necessary, therefore, to physically sort the various databases.

      Upon pressing [C] at the utility menu, you will be prompted whether
      to sort all database files.  All databases will be sorted and all
      indices will be rebuilt.  You will then be returned to the utility
      menu3.  When you have experimented enough, press [Q] at the utility
      menu to return to the main menu.











      ____________________
      1 Not available in Multi-user mode.  See Appendix D
      2 System Administration function only.  See Appendix D
      3 System Administration function only.  See Appendix D

                                     - Page 32 -







                                     Quit to DOS


      Once you have returned to the main menu, press [Q] to return to the
      DOS ready.  It is VERY important that you do not leave the SAC System
      without returning to DOS.  NEVER turn off the machine while in the
      SAC system.  Doing so may result in file corruption and lots of
      headaches to us developers.

      This concludes the system overview.  If you wish to know more about
      the SAC Database editor, or any other editor in the SAC system, see
      Appendix A.  If you wish to know about the file layouts, see Appendix
      B.  If you ever see the infamous error message "Ignore, Retry,
      Suspend, or Quit", see Appendix C.












































                                     - Page 33 -







                                     Appendix A


      This section describes all characteristics, in detail, of the generic
      editor used in this type of Foxpro application.  While this editor
      may be customized for many applications, all share common functions.
      Thus, to learn one version is to know another version.

      This type of Foxpro application usually has an edit menu.  This menu
      allows the user to invoke one or more editors.  The following is an
      example of the edit menu used in the dMAIL4 System:


      +--------------------------------------------------------------------+
                          Mailing List, Version 03.05.00
                    (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ----------------------  E D I T    M E N U ------------------------
      |                                                                    |
                          1 - Edit Mailing List
                          2 - Edit User IDs
      |                                                                    |
                          Q - Return to main menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      In this edit menu, the user has the option to use two editors.  Each
      editor allows the user to maintain separate, but related, databases
      in the dMAIL4 System.  While we really don't need to go any further,
      but it is good to know where most editors are invoked.

      Once a generic editor is invoked, its window will be displayed.  The
      window consists of a window title, field descriptions, and all fields
      of the database record that happens to be current.  A menu window is
      also displayed.  The menu window contains all the one-character
      options available to the user.  The following is a sample screen of
      the mailing list editor used in the dMAIL4 System:


















                                     - Page 34 -







                                     Appendix A


      +--------------------------------------------------------------------+
                            Mailing List, Version 03.05.00
                        (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------------- Mailing List --------------------------
       User ID:
       First Name:                       Last:
                  Billing                Shipping
       Address 1 :
       Address 2 :
       City/State:
       Zip Code  :
       Sex:          Status:             Head of HouseHold:
       Home: (  )    -                   Birth:
       Work: (  )    -                   Wedding:
       Soc.Sec. #:   -  -                Active Date:
            [ ] MS-DOS    +------------ Message Memo -------------+
            [ ] CP/M      |                                       |
            [ ] TRSDOS    |                                       |
                          +---------------------------------------+
      |--------------------------------------------------------------------|
              Toggle Index (Last Name)    Toggle Order (Ascending)
              Add    Browse Delete Find   Goto   Help  Update   Quit
      +--------------------------------------------------------------------+


      All editors have the same basic functions.  Before continuing, we
      will describe each function in detail.

                                  Add Function

      Pressing [A] will allow you to add a record to the current database.
      The cursor will be positioned on the first field in the record.  Now
      whether adding or updating a record, there only a few keystrokes you
      need to know.

      You can move the cursor from field to field using the arrow keys.
      For instance, the Right arrow, the Down arrow, and the [Enter] key,
      moves the cursor forward one field at a time.  The left arrow and up
      arrow will move the cursor back one field.

      Note:  If you have a mouse, you also can move from field to field.
      Simply move the mouse cursor to the desired field and press the left
      mouse button.

      The [Home] key will move the cursor to the beginning of a field.  If
      the cursor is already there, [Home] will move the cursor to the first
      field in the screen.  The [End] key will move the cursor to the end
      of the field.  If the cursor is already there, [End] will move the
      cursor to the last field in the screen.

      If you need more information on any field, press [F1].  If there is
      help information, a help window will be displayed.  The help window
      will remain until you press either [Esc] or [F10].

                                     - Page 35 -







                                     Appendix A



      Note: By pressing [F1] (then [F10] if there is help text), you may
      invoke another Foxpro editor.  If the current input field is
      validated against another file, the editor of that file will appear.
      Use the Goto option to display the desired record.  Then press [Q] to
      quit.  Your input field will be filled with the corresponding field
      in the chosen record.

      Pressing [Ctrl]-[Home] will repeat the last text that was displayed
      in the current field.  This function provides a convenient means of
      adding many records with similar field descriptions.

      Once you have entered your data, moving the cursor beyond the last
      field on the screen tells the editor to accept the record.  Pressing
      [F10] also will tell the editor to accept the record.  You would then
      be prompted to add another record.  The [Esc] key will abort the add
      function, returning the screen to its original condition.

                                 Browse Function

      Pressing [B] will invoke the Foxpro browse function.  The browse
      function will display as many database records as will fit in one
      window.  You can use the left arrow, right arrow, [Tab], and [Shift]-
      [Tab] keys to move the cursor from field to field.  You can move from
      record to record with the up and down arrow keys.  You use the page
      up/down keys to display the next/previous window of records in the
      current database.

      If you have a mouse, you also can use the characters located on the
      right side of the window.  Place the mouse cursor on the up/down
      arrow characters and press the left button to move one record at a
      time.  The diamond character show where you're located in relation to
      the rest of the database.  Place the mouse cursor on the diamond and
      press the left button.  Dragging the diamond will re-position you in
      the database.

      Mouse Note:  After you found the record you want, place the mouse
      cursor on the record and press the left button.  Otherwise, the first
      time you try to update a record will put you back to the last record
      displayed before using the mouse.

      If there are more fields than can be displayed in one window,
      pressing [TAB] will scroll to the next field.  Pressing [Shift]-[TAB]
      will scroll back one field.

      If you have a mouse, you also may use the characters located across
      the bottom of the window.  Place the mouse cursor on the left/right
      arrow characters and press the left button to move one field at a
      time.  The diamond character show where you're located in relation to
      the rest of the database.  Place the mouse cursor on the diamond and
      press the left button.  Dragging the diamond will re-position the
      fields displayed in the database.



                                     - Page 36 -







                                     Appendix A


      Mouse Note:  After you found the field you want, place the mouse
      cursor on the field and press the left button.  Otherwise, the first
      time you try to update a field will put you back to the last field
      displayed before using the mouse.

      In the browse function you may edit any field as desired.  Press
      [Ctrl]-[N] to add a record from the browse.  Press [Ctrl]-[T] to
      delete the current record from the browse.  When finished, press
      [F10] to return to the edit menu.  Pressing [Esc] also will return
      you to the edit menu, but it will abort any change to the current
      record.

      Note:  The JKEY incremental search has recently been added to the
      browse command.  When performing a browse, press [Ctrl]-[J] to
      activate JKEY.  A search will begin on the current index.  Each new
      keystroke will be added to the search string and the record, closest
      matching to the current string, will be displayed.  You may press
      [BackSpace] to revise the search string, or press [Ctrl]-[Y] to clear
      it.  To abort JKEY, simply press [Ctrl]-[J] once again (or [Esc] to
      abort the browse).

                                 Delete Function

      Pressing [D] will allow you to delete the currently displayed record.
      You will be prompted whether you are sure.  Pressing [Y] deletes the
      record from the database.

                                  Find Function

      Pressing [F] will invoke the find function.  This option is only
      available if a database is indexed.

      If invoked, you would type the key of the desired record, and press
      [Enter].  If found, the record would be displayed.  You could then
      delete it, or update it.


      Note:  The key doesn't have to be a complete description.  For
      incomplete keys, the find function will try to find the record with
      the closet matching key.

      Recently, wild-carding has been introduced into the [F]ind function.
      For example, suppose we have a customer file.  It has an index by
      last name.  When the find function prompts us, we could type:

           Last Name:  ..ll..

      In this example, we are searching for a customer whose last name
      contain a "ll".  In another example:

           Last Name:  ..en

      We are searching for a customer whose last name ends with "en".  In
      one more example:

                                     - Page 37 -







                                     Appendix A



           Last Name:  al..

      We are searching for a customer whose last name begins with "al".

      Here's where wild-carding get interesting.  Let's use the first
      example.  Say we find a customer whose last name contains a "ll".  If
      we use the [G]oto function, we get an extra option.  This option,
      called [C]ontinue, will allow us to find the next customer whose last
      name contains a "ll".

      The continue option will remain in effect until you perform another
      find.  It will search for the next wild-card occurrence no matter
      where you are in the database.  In that sense, think of wild-carding
      as an implicit record filter.

      Oh, a new feature has been added to wild-carding:  The triple period
      "...".  Like the double period "..", the triple period denotes wild-
      carding.  Using the triple, however, will also disable the current
      index during the search.

      You see, wild-card searches are a LOT faster when done on an
      unordered database.  So if you are looking for just one record or two
      records, don't care about viewing order, and are using a huge
      database, the triple period might save you valuable time.

                                  Goto Function

      Pressing [G] will create a pop-up menu.  This popup menu allows the
      user to display different records in the current database.  Press [F]
      for the first record in the database.  Press [L] for the last record.
      Press [N] for the next record.  Press [P] for the previous record.
      The goto window remains active until you press [Esc] or [Q] to quit.

      If the current database is indexed, order is defined by the toggle
      order function.  For example, if the current record is customer 5,
      pressing [N] will display customer 6.  If the index order is
      descending, however, pressing [N] will display customer 4.  See
      toggle index order.

      A new option, [W] for window, has been added.  Pressing [W] activates
      the goto window.  The user may then move the goto window to any
      location on the screen.  That location remains in effect for the
      duration of the editor.

      To move the window, press [Ctrl]-[F7].  The goto window border will
      flash.  Press any cursor key to move the window.  Press [Ctrl]-[F7]
      to stop the window from flashing.  Then press [Esc] to resume the
      normal goto prompts.

      Note:  You also may use a mouse to move the goto window.  Press [W].
      Place the mouse cursor on the border of the goto window.  Press the
      left button.  Drag the mouse cursor (and window) to the desired
      location.  Then, press the right button to resume the goto prompts.

                                     - Page 38 -







                                     Appendix A



                                  Help Function

      Pressing [H] will display a summary of commands used in the edit menu
      as in the following screen.  Pressing any key after that returns you
      to the edit menu.


          Command prompt

          [T]oggle Index -  Change Index used by [F]ind command
          Toggle [O]rder -  Current Index in Ascending/Descending Order

          [A]dd        -  Add a record to the current database
          [B]rowse     -  List all records a page at a time
          [D]elete     -  Delete the currently displayed record
          [F]ind       -  Search database for record with specified key
          [G]oto       -  Display the First, Last, Next, or Previous record
          [H]elp       -  Display help information
          [R]ecall     -  Recall Deleted Records
          [U]pdate     -  Update the currently displayed record
          [Q]uit       -  Return to calling program

          Common full screen keystrokes

          [ESC]        -  Abort operation, return to prompt/menu
          [HOME]       -  move cursor to beginning field
          [END]        -  move cursor to ending field
          [CTRL][HOME] -  repeat last input field completed
          [CTRL][END]  -  Complete operation, return to prompt/menu
          [F1]         -  Display Help text/call another editor
          [F10]        -  Complete operation, return to prompt/menu























                                     - Page 39 -







                                     Appendix A



                                 Recall Function

      Pressing [R] allows you to recall a deleted record.  You will be
      presented with a browse window of all deleted records.  Simply locate
      the record to be recalled and press [Enter].

      Note:  If the current database has no deleted() index, you will be
      prompted for the record key (just like the find function).  Type the
      key of the record to be recalled and press [Enter].  If the deleted
      record is found, it is made active again.


                              Toggle Index Function

      For databases with multiple indices, the toggle option will be
      displayed.  The toggle option allows the user to change what index
      will be used with the [F]ind option.  The current index is displayed
      in parenthesis.

                              Toggle Order Function

      This option toggles the order of the current index.  The current
      order is displayed in parenthesis.

      For example, if the current order is ascending, pressing [O] will
      toggle the order to descending.  If the current index is by last
      name, then 'ALPHA' will come after 'BETA'  Pressing [O] again will
      change the current index back to ascending.

                                 Update Function

      Pressing [U] allows you to update the currently displayed record.
      Like the add function, moving the cursor past the last field will
      complete the updating.  Pressing [Esc] will abort any update.

                                  Quit Function

      Finally, pressing [Q] will quit the editor.  You will be returned to
      the menu that invoked the editor.















                                     - Page 40 -







                                    Appendix A-1




      If you ever been on an input field, you may have noticed that
      pressing [Alt] displays a menu at the very top of the screen.  This
      is called the system menu, or sysmenu for short.  The system menu
      displayed is a customized version of the Foxpro sysmenu.  It contains
      a variety of functions and is available to all users.  The following
      describes only a few features available through the sysmenu.  For
      more information, see the Foxpro users manual.


                                  Sysmenu edit


      The sysmenu edit popup is very powerful.  It gives any input field a
      variety of edit functions.  For example, highlighting a section of
      text ([Shift] and cursor key) and pressing [Del] will delete this
      text.  But [Ctrl]-[C] would have copied this text into the clipboard.
      You would then use [Ctrl]-[V] to paste this text.

      Note:  The sysmenu edit popup provides a [Ctrl]-[U] option to undo a
      deletion, copy, cut, or paste.

      Another example:  Suppose you are editing a memo field.  The sysmenu
      edit popup provides a [Ctrl]-[F] option to find specified text.  This
      popup also provides a [Ctrl]-[G] option to repeat the last find.

      There are other functions in the sysmenu edit popup.  See the Foxpro
      users manual for details.


                                Foxpro Calculator


      Simply enter a numeric value on any input field.  Press [Alt]-[F4] to
      activate the Foxpro calculator.  The Foxpro calculator will display
      your numeric value.

      When you have a new calculated value, press [Ctrl]-[F4] to deactivate
      the calculator.  Your new numeric value will be placed into the
      current input field.

      Note:  If you just want the calculator, press [F4].  But you must be
      on an input field to invoke [F4].


                                 Foxpro Calendar


      Simply enter a date on any input field.  Press [Alt]-[F5] to invoke
      the Foxpro calendar.  The Foxpro calendar will display the year,
      month, and day of the specified date.



                                     - Page 41 -







                                    Appendix A-1


      Select any desired date.  When you have a new date, press [Ctrl]-[F5]
      will deactivate the calendar.  Your new date will be placed into the
      current input field.

      Note:  If you just want the calendar, press [F5].  But you must be on
      an input field to invoke [F5].


                                Foxpro DOS Shell


      In Foxpro for DOS, the system pulldown menu provides a DOS shell.  If
      you are a system administrator, pressing [Alt]-[S] [O] brings up the
      DOS command window.  Type any desired DOS command.  Type 'EXIT' and
      press [Enter] to leave the DOS shell.


                                  Printer Eject


      Press [F7] for a page eject.  A form feed will be sent to the printer
      device, specified in the System Setup.  Very useful for people with
      Laser Printers.

                                   Video Mode


      Press [Alt]-[V] for the video mode.  In Foxpro for DOS, a VGA screen
      will toggle between 25 and 43 line modes.  All subsequent windows
      will conform to the specified mode.  Very useful in displaying
      reports.

      In Foxpro for windows, [Alt]-[V] will display a font selector.  All
      sub-windows, to the current window, will conform to the specified
      font.  If you change the main menu window, the font becomes permanent
      to your application.

                                   Print Mode


      In Foxpro for windows, you can print a report with the current font.
      Send the report to the screen and use the 'Print' option of the
      'File' popup in sysmenu.  'Print' will print the entire contents of
      the current window, fonts and all.  Remember, however, that 'Print'
      will not use your printer codes.

      Note:  'Print' may not be available with the Foxpro for windows
      runtime unit.  To print font reports, obtain the developers copy of
      Foxpro for windows.






                                     - Page 42 -







                                      GLOSSARY


      ANSI  -  American National Standards Institute.  A standard for both
           screen output and keyboard input.

      Arrow Keys  -  Equivalent to cursor keys.  Those keys on the keyboard
           labeled with arrows.

      ASCII  -  American Standard Code for Information Interchange.  A
           standard 7 bit code used to represent data.

      Batch File  -  A file containing multiple DOS commands.  These
           commands are executed by DOS, one at a time, as if typed by the
           user.

      Byte  -  A unit of information.  In text form, equivalent to an ASCII
           character.

      Code  -  Program code.  Another way of saying program instructions.

      Compiler  -  A program that converts program code from one form to
           another, usually more primitive, form.  The converted code is
           then ready for execution.

      CONFIG.FP  -  The Foxpro configuration file.  This file tells Foxpro
           where is find the resource file.  On a network, there is a one
           copy for each Foxpro user.

      CONFIG.FPM  -  The Foxpro for Macintosh configuration file.

      CONFIG.FPW  -  The Foxpro for windows configuration file.

      Cursor  -  A flashing character on the screen.  It indicates where
           typed text will be next placed.

      Cursor Keys  -  Equivalent to arrow keys.  Those keys on the keyboard
           labeled with arrows.

      Data Dictionary  -  A database file that defines the input/output to
           database files in an application.

      dBASE  -  Popular database management language.  The software package
           dBASE III+ is an interpreter for dBASE code.

      Disk  -  A unit where information is stored.  There are two major
           types: hard disk, and floppy disk.

      Disk Error  -  An error occurring when a program is unable to read or
           write properly to a disk.

      Diskspace  -  A unit of how much room is available on a drive.  It is
           usually measured in bytes.

      DOS  -  Disk Operating System.



                                     - Page 60 -







                                      GLOSSARY


      EMS  -  Refers to expanded memory.  Most 80286 computers have
           expanded memory.  80386 computers have extended memory.  There
           are, however, 80386 software drivers (QEMM for example), that
           can offer either extended or expanded memory.

      Extended  -  Extended memory.  80386 (or better) computers have
           extended memory.  The extended version of Foxpro needs at least
           three megabytes of extended memory.  The standard version of
           Foxpro requires expanded memory.

      Filespec  -  any DOS filename.ext including catalog names, passwords,
           etc.

      Floppy Disk  -  A self contained unit where information is stored.
           Depending on the type, floppy disks are easily transportable.
           Sometimes called a diskette.

      Foxbase  -   A dBASE III plus compatible language.

      Foxpro  -   A dBASE IV compatible language.

      FOXERR.DBF  -  The Foxpro error file.  Every major error event is
           recorded in this file.

      FOXUSER.DBF  -  The Foxpro resource file.  This file stores all the
           attributes of the user.  It also stores all the color sets
           available to Foxpro.  On a network, there is a one copy for each
           Foxpro user.

      GIF  -  Refers to the Compu-Serve Graphic Information Format.  A
           graphic picture format.

      Hard Disk  -  A self contained unit where information is stored.
           Usually not removable.

      HELP  -  A facility that provides on-line assistance in the use of a
           given program.

      Highlight  -  A form of a cursor, where an entire field is considered
           the cursor.

      Interpreter  -  A program that executes language code.  Whereas a
           compiler translates program code to executable code, an
           interpreter translates a single line of program code before
           executing it.

      L.S.T.  -  Local Sidereal Time.

      Kilobyte  -  One kilobyte of memory equals 1,024 bytes.

      Megabyte  -  One megabyte of memory equals 1,024,000 bytes.

      Multi-user  -  When more one than one person is capable of
           accessing/updating the same database at the same time.

                                     - Page 61 -







                                      GLOSSARY



      MS-DOS  -  Microsoft Disk Operating System.

      SAC  -  Saguaro Astronomy Club Database.  A comma delimited text file
           containing 10,000 records.  Mostly NGC objects.

      SHOWGIF  -  A SunShow utility to diaplay a GIF file.

      Sidereal Time  -  The current Right Ascension at the median.

      Sideways  -  A Utility that will print text up and down instead of
           across the paper.

      Source Code  -  What a translator/compiler takes in as input.

      Syntax  -  The rules for the arrangement of statements in a
           programming language

      UT  -  Universal Time.




































                                     - Page 62 -







                                        Index


      *.ESL  49                            Code  60
      *.ESO  49                            Compiler  60
      .BAT  43                             Compu-Serve  6, 61
      .BIN  43                             CONFIG.FP  49, 50, 60
      .CDX  43                             CONFIG.FPM  60
      .DBF  43                             CONFIG.FPW  50, 51, 60
      .DRV  43                             Configuring Sideways  59
      .EXE  43                             Convert RA/Dec <--> Alt/Az  30
      .FPT  43                             Copyright/License/Warranty  2
      .FXP  43                             Create GIF Memo  14
      .LIB  43                             Creating a Log Record  16
      .PRG  43                             Cursor  35, 60
      [Alt]-[F4]  41                       Cursor Keys  60
      [Alt]-[F5]  41                       Customizing Color Sets  25
      [Alt]-[V]  42                        DATA  53
      [Ctrl]-[F4]  41                      Data dictionary  44, 56, 60
      [Ctrl]-[F5]  42                      DBASE  60
      [Ctrl]-[Home]  36                    DBL.DBF  43
      [Ctrl]-[J]  37                       DBL.TXT  45
      [Ctrl]-[N]  37                       DBL20.DBF  45
      [Ctrl]-[T]  37                       DBLLOG.DBF  43
      [Ctrl]-[Y]  37                       Default Settings  26
      [End]  35                            Delete Function  12, 37
      [Esc]  36                            Delete GIF Memo  14
      [F1]  35                             Disk  60
      [F10]  37                            Disk Error  60
      [F4]  41                             Disk Space  47
      [F5]  42                             Diskspace  60
      [F7]  42                             Display/Print Manual  28
      [Home]  35                           DOS  60
      [Shift]-[TAB]  36                    Double Star Separation  31
      [TAB]  36                            Draft mode  24
      1 Create GIF File  14                Edit Log  13
      2 Print GIF File  14                 Editor  6
      3 View GIF File  14                  EMS  49, 51, 61
      Access GIF's to .\GIF  30            Epoch Coordinates  31
      Add Function  11, 35                 Expanded  51
      ANSI  57, 60                         Expression builder  6, 22
      Appendix A  34                       Extended  1, 51, 61
      Appendix A-1  41                     Filespec  61
      Appendix B  43                       Filter  21, 22
      Appendix C  47                       Find Function  12, 37
      Appendix D  49                       Floppy Disk  61
      Arrow Keys  60                       FONTNAME  54
      ASCII  60                            FONTSIZE  54
      Astronomy  1                         FONTSTYLE  54
      BACK  46                             Foxbase  61
      Backup/Restore Data Files  46        FOXERR.DBF  25, 44, 48, 61
      Batch File  60                       Foxpro  1, 6, 61
      Browse Function  12, 36              Foxpro Calculator  41
      Burham  15, 30                       Foxpro Calendar  41
      Burham Coordinates  30               Foxpro DOS Shell  42
      Byte  60                             Foxpro for DOS  42
      Change Color Set  25

                                     - Page 63 -







                                        Index


      Foxpro for windows  42, 51, 53,      OBJ.DBF  43
          54                               OBJLOG.DBF  44
      Foxpro runtime unit  8, 49           P_CODES.DBF  23
      Foxpro runtime unit directory        Preface  1
          49                               Print GIF Memo  14
      FOXPRO.INI  53                       Print Mode  42
      FOXR.EXE  49                         Print SAC Database  18
      FOXRUN  49                           Printer Codes  24, 59
      FOXRW.EXE  50                        Printer Control Codes  22
      FOXSWAP.COM  49                      Printer Device  23
      FOXUSER.DBF  25, 44, 58, 61          Printer Eject  42
      FOXUSER2.DBF  25, 58                 Printer Name  23
      GIF  6, 55, 61                       Printer not Ready  47
      GLOSSARY  60                         Printing SAC Database  19
      Goto Function  13, 38                Problems & Suggestions  25
      Hard Disk  61                        PROG  56
      HELP  61                             PROGWORK  51
      Help Function  13, 39                Q*.*  44
      Highlight  61                        Quit  17, 20, 28
      Import Files  45                     Quit Function  15, 40
      Index  63                            Quit to DOS  33
      INIT  55                             Ramdisk  57
      Initializing Databases  32           Rebuilding Indices  32
      Interpreter  61                      RECALL  56
      Introduction  6                      Recall Function  40
      Invoking SAC System  8               Record filter  6, 21, 22
      JKEY  37                             Record Filters  59
      Kilobyte  61                         Regular mode  24
      L.S.T.  61                           RESOURCE  52
      Laser Printers  42                   Resource directory  49
      LAST  55                             SAC  1, 6, 8, 62
      LIM 4.0  51                          SAC.DBF  44
      LUN.DBF  43                          SAC.TXT  45
      LUNLOG.DBF  43                       SAC60.DBF  45
      Macintosh  7                         SACLOG.DBF  44
      Maintaining SAC Deep Sky             SACSYS.MEM  44
          Database  11                     Saguaro Astronomy Club  1, 6
      Maintaining SAC Double Star          SCR.DBF  44
          Database  17                     SHOWGIF  62
      Maintaining Sample Records  10       Sidereal Time  62
      MANUAL  43                           Sideways  24, 62
      Megabyte  61                         SIDEWAYS.COM  59
      Megabytes  1                         SIDEWAYS.DFT  59
      MEMLIMIT  51                         Sorting Databases  32
      Memo  16, 25                         Source Code  62
      Memo field  6                        Straight lines per page  24
      MODE  47                             SunShow  1, 8, 14, 15, 21, 27,
      Modify GIF Memo  14                      43
      MS-DOS  1, 62                        SunShow Image Toolkit  3
      MULT  55                             SunShow Print Setup  26
      Multi-user  23, 61                   SunShow Video Setup  26
      Multi-User Errors  48                SWSETUP.COM  59
      Network  49, 55                      Syntax  62
      Notation Conventions  7              Syntax Error  48

                                     - Page 64 -







                                        Index


      Sysmenu  41, 56
      Sysmenu edit  41
      System administration  55
      System administrator  25, 42, 47
      System Setup  21
      TABLE OF CONTENTS  4
      TEMP  57
      TERM  57
      TIME  52
      Toggle Index Function  13, 40
      Toggle Order Function  13, 40
      UNBACK  46
      Update Function  13, 40
      Updating SAC Deep Sky Record  15
      UT  62
      Utilities  29
      VBL.DBF  44
      VBLLOG.DBF  44
      Video Mode  42
      View GIF Memo  15
      Wild-carding  37
      Window  6
      Word for Windows  18
































                                     - Page 65 -



