
/*
 * File......   : SAVEARR.PRG
 * Author....   : Peter Kulek
 * Date......   : $Date:   06 Aug 1993  $
 * Compuserve ID: 100140,1220
 * 
 * This is an original work by Peter Kulek
 * And is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 */

/*
   
   Endor Ltd 
   63 Church Road
   Albrighton 
   Shropshire
   WV7 3HL
   England

   Specialists in design and implementation of EIS and MIS systems 

   
   Telephone: 
       Analysis  081 558 2279    Peter Jordan  MD 
       Technical 0902 374 900    Peter Kulek   Technical Director
   
   Compuserve ID 100140,1220
   
   We design EIS and MIS systems for large data users for use on
   laptops to large networks with auto downloading from mainframes.

   If you have a large database and cannot get it into a user friendly 
   format please give us a call and we will send you a live sample 
   application that will show you how to manipulate vast quantities 
   of data EASILY, with a minimum of tables. 
   
   For example a complete hierachy from parent holding company through 
   to salesperson with profit and loss at each level, targeting, variances 
   both monetary and percentage, graphs at each level for period and weekly 
   figures all with five tables and designed and implemented within a month 
   from recieving TOR. 
   
   Directors and Managers in large corporations have found it very friendly 
   and most important they use it daily. 
   
   To really appreciate the vast amount of data and the easy interface a
   copy of the application has to be seen.
   
   This is not some system using commercial EIS applications which need
   months of training and have heaps of files floating all over the place.
   This is far superior methodology to any of the current commercial offerings.
    

   No Problem to large to solve.
*/

/*  $DOC$
 *  $FUNCNAME$
 *     ARRAY2FILE()
 *  $CATEGORY$
 *     Array
 *  $ONELINER$
 *     Save Clipper array to a disc file.
 *  $SYNTAX$
 *     Array2File( <aArray>, <cFileName>)
 *  $ARGUMENTS$
 *     <aArray> is any Clipper array including nested
 *     <cFileName> is a DOS file name.
 *  $RETURNS$
 *     number of bytes in file
 *  $DESCRIPTION$
 *     Array2File saves a Clipper Array to a disc file.  Compiled 
 *     code blocks or objects are not saved, but are stored as a NIL
 *  $EXAMPLES$
 *  $SEEALSO$
 *     File2Array()
 *  $END$
 */

#include "FILEIO.CH"

#define ISARRAY(x)    (valtype(x)=='A')
#define ISLOGIC(x)    (valtype(x)=='L')
#define ISNUMERIC(x)  (valtype(x)=='N')
#define ISCHAR(x)     (valtype(x)=='C')
#define ISDATE(x)     (valtype(x)=='D')
#define ISOBJECT(x)   (valtype(x)=='O')
#define ISNIL(x)      x=NIL


#ifdef TEST
//Clipper /n/b/dTEST   use debug to test
function test()
     local nMaxLen := 1000
     local bBlock := {||'test'}
     local oTest  := TbrowseNew()
     local aLarge := array(nMaxLen)
     local i,nStart,aArray
     cls
     nStart := seconds()
     for i := 1 to nMaxLen
         aLarge[i] := 'Element No '+str(i,4)
     next
     ? ' Saving Array To File - Number of Elements '+alltrim(str(nMaxLen))
     Array2File('test.ary',;
                       {bBlock,oTest,aLarge,46.78,789.065,45.78,;
                       {date(),{'Another Element'},;
                       'peter','was','here','testing'},;
                       {NIL,{46,78,8,8,8,{date(),.f.,.t.,NIL}}}})
     ? 'Seconds To Write '
     ?? seconds()-nStart
     wait
     ? ' Reading Array From File '
     nStart := seconds()
     aArray := File2Array('test.ary')
     ? 'Seconds To Read '
     ?? seconds() - nStart
     wait
     DispArray(aArray)
return(NIL)
//--------------------------------------------------
static function DispArray(aArray,nDepth)
local nLen := len(aArray)
local i
nDepth  := if(ISNUMERIC(nDepth),nDepth,0)
nDepth++
for i := 1 to nLen
    if ISARRAY(aArray[i])
        DispArray(aArray[i],nDepth)
    else
        ? space(nDepth*4)
        ?? aArray[i]
    endif
next
nDepth--
return(NIL)
#endif
********************************************************************
function Array2File(cFile,aRay,nDepth,hFile)
local nBytes := 0
local i
nDepth := if(ISNUMERIC(nDepth),nDepth,0)
if hFile == NIL
   if (hFile := fCreate(cFile,FC_NORMAL)) == -1
      return(nBytes)
   endif
endif
nDepth++
nBytes += WriteData(hFile,aRay)
if ISARRAY(aRay) 
   for i := 1 to len(aRay)
      nBytes += Array2File(cFile,aRay[i],nDepth,hFile)
   next
endif
nDepth--
if nDepth == 0
   fClose(hFile)
endif
return(nBytes)
//-----------------------------------------------------------------------------
static function WriteData(hFile,xData)
local cData  := valtype(xData)
local nLen
   if ISCHAR(xData)
       cData += i2bin(len(xData))+xData
   elseif ISNUMERIC(xData)
       cData += i2bin(len(alltrim(str(xData))) )+alltrim(str(xData))
   elseif ISDATE(xData)
       cData += i2bin(8)+dtos(xData)
   elseif ISLOGIC(xData)
       cData += i2bin(1)+if(xData,'T','F')
   elseif ISARRAY(xData) 
       cData += i2bin(len(xData))
   else
       cData += i2bin(0)   // NIL
   endif
return( fWrite(hFile,cData,len(cData)) )


