

  'This is a sample application as described in the chapter
  'Liberty BASIC Graphical Features

    'The purpose of this application is to allow the entry of three
    'sets of numerical data and then to plot them in contrasting
    'colors superimposing each other.    The concepts utilized here
    'include handling the spreadsheet, using buttons, and drawing
    'into a graphical window using several colors

    nomainwin  ' do not open a main window

    'create 3 arrays
    dim columnOne(10)
    dim columnTwo(10)
    dim columnThree(10)

    'set up the size of the spreadsheet window
    WindowWidth = 500
    WindowHeight = 348

    'set up the buttons
    bmpbutton #sheet, "grphbttn.bmp", [graph], LR, -17, -15
    bmpbutton #sheet, "loadbttn.bmp", [load], LR, 18, -15
    bmpbutton #sheet, "savebttn.bmp", [save], LR, 53, -15

    'open the window
    open "GRAPHER, a Liberty BASIC application"  for spreadsheet as #sheet

    print #sheet, "trapclose [quit]"
    print #sheet, "indirect"        'use indirect control mode
    print #sheet, "select B4"       'position the selector at B4

    'display some simple instructions and also the column headings
    print #sheet, "cell A1 'Please enter 3 columns of data below and click on Graph."
    print #sheet, "cell A3 'Item #     Set 1      Set 2      Set 3"

    'place the numbers 1 to 10 to the left of the column information
    for index = 1 to 10
        print #sheet, "cell A"; str$(index+3); " '"; str$(index)
    next index

    'specify columns B,C,D from 4 to 13 as user (entry) columns and to accept numbers
    for index = 4 to 13
        print #sheet, "user B"; str$(index); " number"
        print #sheet, "user C"; str$(index); " number"
        print #sheet, "user D"; str$(index); " number"
    next index

    'display title header and set up the cell to hold it to accept a string
    print #sheet, "cell A15 'Title for the graph:"
    print #sheet, "user A16 string"

    'force display of the spreadsheet
    print #sheet, "flush"


[inputLoop]    ' wait for input (button clicks)
    input r$
    goto [inputLoop]


[graph]     'display a graph of the data in the spreadsheet

    'if a graph is already displayed, then close its window
    if plotFlag > 0 then close #graph
    plotFlag = 1


    'get the column data from the spreadsheet
    'and look for the peak (greatest) y value
    peak = 0
    for index = 4 to 13
        print #sheet, "result? B"; str$(index)
        input #sheet, r$ : columnOne(index-3) = val(r$)
        if val(r$) > peak then peak = val(r$)
        print #sheet, "result? C"; str$(index)
        input #sheet, r$ : columnTwo(index-3) = val(r$)
        if val(r$) > peak then peak = val(r$)
        print #sheet, "result? D"; str$(index)
        input #sheet, r$ : columnThree(index-3) = val(r$)
        if val(r$) > peak then peak = val(r$)
    next index

    'set up the size of the graph window based on peak
    WindowWidth = 320 + 70
    WindowHeight = 64 + peak + 25 + 20
    yScale = 1
    if WindowHeight > 400 then yScale = 400 / WindowHeight : WindowHeight = 450

    'get the title of the graph from the spreadsheet
    print #sheet, "result? A16"
    input #sheet, title$

    ' open a window for the graph with one button
    button #graph, Done, [done], LR, 5, 5
    open title$ for graphics_nsb as #graph

    'draw a scale
    print #graph, "place 0 "; 15 * yScale + 35
    print #graph, "down"
    print #graph, "\   "; peak
    print #graph, "size 2 ; place 50 "; 15 * yScale + 35
    print #graph, "goto 55 "; 15 * yScale + 35
    print #graph, "goto 55 "; (peak + 5 + 15) * yScale + 35
    print #graph, "goto 305 "; (peak + 5 + 15) * yScale + 35

    'set the size of the graphics pen
    print #graph, "size 3"

    'add ten to peak to move it away from the top of the window
    peak = peak + 15

    'plot columnOne in red
    print #graph, "color red"
    print #graph, "up"
    print #graph, "goto 60 "; ((peak - columnOne(1)) * yScale) + 35
    print #graph, "down"
    for x = 60 to 285 step 25
        print #graph, "goto "; x; " "; (peak - columnOne(int((x-35)/25))) * yScale + 35
    next x

    'plot columnTwo in green
    print #graph, "color green"
    print #graph, "up"
    print #graph, "goto 60 "; ((peak - columnTwo(1)) * yScale) + 35
    print #graph, "down"
    for x = 60 to 285 step 25
        print #graph, "goto "; x; " "; (peak - columnTwo(int((x-35)/25))) * yScale + 35
    next x

    'plot columnThree in blue
    print #graph, "color blue"
    print #graph, "up"
    print #graph, "goto 60 "; ((peak - columnThree(1)) * yScale) + 35
    print #graph, "down"
    for x = 60 to 285 step 25
        print #graph, "goto "; x; " "; (peak - columnThree(int((x-35)/25))) * yScale + 35
    next x

    'display the title in black in the upper left corner
    print #graph, "color black"
    print #graph, "up"
    print #graph, "goto 50 "; 20
    print #graph, "font Roman 10 30"
    print #graph, "\   "; title$

    'force display of the graph
    print #graph, "flush"

    goto [inputLoop]    ' drawing finished, go back and poll for input


[done]      'close graph window if Done button is clicked

    plotFlag = 0
    close #graph
    goto [inputLoop]

[load]   'load a spreadsheet

    filedialog "Load Grapher File", "*.ABC", fileName$
    if fileName$ = "" then [inputLoop]
    print #sheet, "load "; fileName$
    goto [inputLoop]


[save]   'save a spreadsheet

    filedialog "Save Grapher File", "*.ABC", fileName$
    if fileName$ = "" then [inputLoop]
    print #sheet, "save "; fileName$
    goto [inputLoop]


[quit]      'exit the Grapher application if desired

    confirm "Quit Grapher?"; quit$
    if quit$ = "no" then [inputLoop]
    if plotFlag = 1 then close #graph
    close #sheet

    end
