REM The Dungeon Player List Utility v9.0

' declare all variables as integer type
DEFINT A-Z

' declares variable storage for user record structure type
TYPE usertype
 codename AS STRING * 32
 password AS STRING * 32
 spell(1 TO 40) AS INTEGER
 wand(1 TO 10) AS INTEGER
 potion(1 TO 10) AS INTEGER
 staff(1 TO 10) AS INTEGER
 ring(1 TO 10) AS INTEGER
 globe(1 TO 10) AS INTEGER
 stats1(1 TO 6) AS DOUBLE
 stats2(1 TO 17) AS INTEGER
END TYPE

' declare structures common to main program
DIM userrec AS usertype

' define function to convert encrypted string to 20 character string
DEF fndecrypt$ (z$)
  i$ = ""
  FOR j = 1 TO 4
    j$ = ""
    z# = CVD(MID$(z$, j * 8 - 7, 8))
    FOR q = 1 TO 5
      dvid# = INT(z# / 1000)
      num# = z# - dvid# * 1000
      z# = dvid#
      j$ = j$ + CHR$(num#)
    NEXT
    y$ = LEFT$(j$, 1)
    MID$(j$, 1, 1) = MID$(j$, 5, 1)
    MID$(j$, 5, 1) = y$
    y$ = MID$(j$, 2, 1)
    MID$(j$, 2, 1) = MID$(j$, 4, 1)
    MID$(j$, 4, 1) = y$
    i$ = i$ + j$
  NEXT
  fndecrypt$ = i$
END DEF

' main program
GOSUB Open.User.File ' open the users data file
GOSUB Header1
p = 5
FOR x = 1 TO LOF(1) / LEN(userrec)
  p = p + 1
  IF p = 24 THEN
    p = 5
    GOSUB Press.Key
    GOSUB Header1
  END IF
  GET 1, x, userrec
  a$ = fndecrypt$(userrec.codename)
  MID$(a$, 1, 1) = UCASE$(MID$(a$, 1, 1))
  b$ = STR$(userrec.stats1(1))
  b$ = b$ + SPACE$(14 - LEN(b$))
  c$ = STR$(userrec.stats1(2))
  c$ = c$ + SPACE$(14 - LEN(c$))
  a$ = a$ + b$ + " " + c$
  z = 0
  FOR y = 1 TO 10
    IF userrec.wand(y) = 1 THEN
      z = z + 1
    END IF
  NEXT
  b$ = STR$(z)
  b$ = b$ + SPACE$(7 - LEN(b$))
  a$ = a$ + b$
  z = 0
  FOR y = 1 TO 10
    IF userrec.potion(y) = 1 THEN
      z = z + 1
    END IF
  NEXT
  b$ = STR$(z)
  b$ = b$ + SPACE$(9 - LEN(b$))
  a$ = a$ + b$
  z = 0
  FOR y = 1 TO 10
    IF userrec.staff(y) = 1 THEN
      z = z + 1
    END IF
  NEXT
  b$ = STR$(z)
  b$ = b$ + SPACE$(8 - LEN(b$))
  a$ = a$ + b$
  z = 0
  FOR y = 1 TO 10
    IF userrec.ring(y) = 1 THEN
      z = z + 1
    END IF
  NEXT
  b$ = STR$(z)
  a$ = a$ + b$
  COLOR 13
  PRINT a$
NEXT
GOSUB Press.Key
GOSUB Header2
p = 5
FOR x = 1 TO LOF(1) / LEN(userrec)
  p = p + 1
  IF p = 24 THEN
    p = 5
    GOSUB Press.Key
    GOSUB Header2
  END IF
  GET 1, x, userrec
  a$ = fndecrypt$(userrec.codename)
  MID$(a$, 1, 1) = UCASE$(MID$(a$, 1, 1))
  b$ = STR$(userrec.stats2(1))
  b$ = b$ + SPACE$(9 - LEN(b$))
  c$ = STR$(userrec.stats2(2))
  c$ = c$ + SPACE$(7 - LEN(c$))
  d$ = STR$(userrec.stats2(3))
  d$ = d$ + SPACE$(10 - LEN(d$))
  e$ = STR$(userrec.stats2(4))
  e$ = e$ + SPACE$(13 - LEN(e$))
  f$ = STR$(userrec.stats2(5))
  f$ = f$ + SPACE$(10 - LEN(f$))
  g$ = STR$(userrec.stats2(6))
  COLOR 13
  PRINT a$ + b$ + c$ + d$ + e$ + f$ + g$
NEXT
GOSUB Press.Key
GOSUB Header3
p = 5
FOR x = 1 TO LOF(1) / LEN(userrec)
  p = p + 1
  IF p = 24 THEN
    p = 5
    GOSUB Press.Key
    GOSUB Header3
  END IF
  GET 1, x, userrec
  a$ = fndecrypt$(userrec.codename)
  MID$(a$, 1, 1) = UCASE$(MID$(a$, 1, 1))
  b$ = STR$(userrec.stats1(3))
  b$ = b$ + SPACE$(16 - LEN(b$))
  c$ = STR$(userrec.stats1(5))
  c$ = c$ + SPACE$(16 - LEN(c$))
  d$ = STR$(userrec.stats1(6))
  COLOR 13
  PRINT a$ + b$ + c$ + d$
NEXT
GOSUB Press.Key
GOSUB Header4
p = 5
FOR x = 1 TO LOF(1) / LEN(userrec)
  p = p + 1
  IF p = 24 THEN
    p = 5
    GOSUB Press.Key
    GOSUB Header4
  END IF
  GET 1, x, userrec
  a$ = fndecrypt$(userrec.codename)
  MID$(a$, 1, 1) = UCASE$(MID$(a$, 1, 1))
  FOR L=7 TO 12
    b$ = STR$(userrec.stats2(L))
    b$ = b$ + SPACE$(7 - LEN(b$))
    a$ = a$ + b$
  NEXT
  COLOR 13
  PRINT a$;
NEXT
GOSUB Press.Key
COLOR 7, 0
CLS
END

Press.Key:
LOCATE 25, 1, 0
COLOR 10
PRINT "Press a key to continue:";
WHILE INKEY$ = ""
WEND
RETURN

Header1:
GOSUB Page.Header
COLOR 14
PRINT "Player Name          Dungeon Level  Player Level  Wands  Potions  Staffs  Rings"
PRINT STRING$(79, "-")
RETURN

Header2:
GOSUB Page.Header
COLOR 14
PRINT "Player Name          Strength Wisdom Intellect Constitution Dexterity Charisma"
PRINT STRING$(78, "-")
RETURN

Header3:
GOSUB Page.Header
COLOR 14
PRINT "Player Name          Experience      Gold            Hit Points"
PRINT STRING$(63, "-")
RETURN

Header4:
GOSUB Page.Header
COLOR 14
PRINT "Player Name          Weapon Shield Armor  Cloak  Helmet Boots"
PRINT STRING$(61, "-")
RETURN

Page.Header:
COLOR 14,1
CLS
COLOR 15
PRINT "The Dungeon Player List 9.0 Utility"
PRINT STRING$(35, "=")
PRINT
RETURN

' open the user file, length of user record
Open.User.File:
 CLOSE 1 ' close file 1
 ' open user file random
 OPEN "players.dat" FOR RANDOM SHARED AS #1 LEN = LEN(userrec)
 RETURN ' exit routine

