/*****************************************************************************/
/* T.A.G. Bulletin Board System                                              */
/* Copyright (c) 1986-1994 by The T.A.G. Team                                */
/* All rights reserved.                                                      */
/*                                                                           */
/*                    ----------------------------------                     */
/*                    T.A.G. Version 2.7 Data Structures                     */
/*                    ----------------------------------                     */
/*             Converted from Turbo Pascal to C by Martin Pollard            */
/*         Converted from 'Martin-C' to ANSI C by Daniel Mecklenburg         */
/*                                                                           */
/* All we ask if you use these record structures is to give credit where     */
/* credit is due.                                                            */
/*                                                                           */
/* Additional structure information may be given out on an individual        */
/* basis depending on the situation.                                         */
/*                                                                           */
/* RELEASE HISTORY:                                                          */
/*                                                                           */
/* 01/24/93 - Initial release.                                               */
/* 02/17/93 - Corrected errors in definitions for SystatRec, ModemRec, and   */
/*            MboardType.                                                    */
/* 04/27/93 - Re-Released without change for version 2.6e (Paul Williams)    */
/* 09/01/93 - Updated for version 2.6f (Victor Capton)                       */
/* 05/09/94 - Updated for version 2.7 (Victor Capton)                        */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/* NOTES TO PROGRAMMERS:                                                     */
/*                                                                           */
/* Turbo Pascal strings are formatted differently than C strings:            */
/*                                                                           */
/*      Turbo Pascal:   length byte + string data                            */
/*      C:              string data + '\0' (zero)                            */
/*                                                                           */
/* You will have to write conversion routines to convert strings back and    */
/* forth between TP and C formats if you wish to use strings.                */
/*                                                                           */
/* Also, C has no direct equivalent to Turbo Pascal's "real" type for real   */
/* numbers (C's "float" and "double" do not use the same format).  If you    */
/* wish to use real numbers, you will have to write conversion routines.     */
/*                                                                           */
/* NOTE THAT THERE IS NO ATTEMPT HERE TO TEACH YOU HOW TO ACCESS T.A.G. DATA */
/* FILES USING THE C LANGUAGE.  IT IS ASSUMED THAT YOU ALREADY KNOW HOW TO   */
/* PROGRAM IN C, AND ARE FAMILIAR WITH THE INS AND OUTS OF ACCESSING FIXED-  */
/* LENGTH RECORD DATA FILES (SUCH AS THE ONES T.A.G. USES).                  */
/*                                                                           */
/*****************************************************************************/

#ifndef __TAGREC_H
#define __TAGREC_H

/* C has no equivalent for TP "real" type! */
typedef unsigned char   Real[6];

/*---------------------------------------------------------------------------*/

/***************************************************************************/
/* The following values are used by the system for user fields             */
/* "ask"  values will be asked of the user the next time they logon if the */
/*        question is part of the new user logon                           */
/* "none" values are normally for optional fields where the user simply    */
/*        pressed <enter>                                                  */
/***************************************************************************/

#define USER_STRING_ASK     " "     /* Ask for user string fields */
#define USER_STRING_NONE    ""      /* None for user string fields */
#define USER_DATE_ASK       0xFE21  /* Ask for user date fields - 1/1/2027 */
#define USER_DATE_NONE      0x0021  /* None for user date fields - 1/1/0 */
#define USER_WORD_ASK       65535U  /* Ask for user word fields */
#define USER_WORD_NONE      65534U  /* None for user word fields */
#define USER_CHAR_ASK       '~'     /* Ask for user character fields */
#define USER_CHAR_NONE      ' '     /* None for user character fields */
#define USER_PHONE_ASK      " "     /* Ask for user phone fields */
#define USER_PHONE_NONE     ""      /* None for user phone fields */

/*---------------------------------------------------------------------------*/

#define DYN_DEFAULT     0           /* Default */
#define DYN_YES         1           /* Yes */
#define DYN_NO          2           /* No */
     
/* Default/yes/no type */
typedef unsigned char DefaultYesNoType;

/* AR flags (@..Z) */
typedef unsigned char ArFlagType;        

/* Set of AR flags                 */
/*  Byte 0 = bits 0..7 = Flags @..G */
/*  Byte 1 = bits 0..7 = Flags H..O */
/*  Byte 2 = bits 0..7 = Flags P..W */
/*  Byte 3 = bits 0..2 = Flags X..Z */
typedef unsigned char ArFlagset[4];      


/* flagset flag1 */
#define USF_AutoPrivDel     0x01
#define USF_NoPostCall      0x02
#define USF_ForceULScan     0x04
#define USF_Ranon           0x08
#define USF_RbbsList        0x10
#define USF_Rchat           0x20
#define USF_NoDLlimit       0x40
#define USF_RpubMsg         0x80

/* flagset flag2 */
#define USF_RprivMsg        0x01
#define USF_Rvoting         0x02
#define USF_OneCall         0x04
#define USF_PubNotVal       0x08
#define USF_ProtDel         0x10
#define USF_NoFilePts       0x20
#define USF_RfileVal        0x40
#define USF_Pause           0x80

/* flagset flag3 */
#define USF_Ansi            0x01
#define USF_Color           0x02
#define USF_OneKey          0x04
#define USF_Alert           0x08
#define USF_FlagRecUnused   0x10
#define USF_MboxClosed      0x20
#define USF_Tabs            0x40
#define USF_ClsChar         0x80

typedef struct
{
    /* User special flags */
    /* 3 bytes used for 24 flags in set */
    unsigned char   flag1;
    unsigned char   flag2;
    unsigned char   flag3;
} FlagSet;


#define ULRF_IsCdRom        0x01

typedef struct
{
    unsigned char   flag1;
} UlRecFlagSet;


/* configflagset flag1 */
#define CF_UseCustomMenus           0x01
#define CF_ClsMsgRead               0x02
#define CF_DoNotDisturbUser         0x04
#define CF_LogonScanAllMsgSections  0x08
#define CF_QWKNewBulletins          0x10
#define CF_QWKNewFiles              0x20

typedef struct
{
    /* User configuration flags */
    /* 3 bytes used for 24 flags in set */
    unsigned char flag1;
    unsigned char flag2;
    unsigned char flag3;
} ConfigFlagSet;      

/************************************************/
/* ColorRec = Array of B&W / Color  Color Bytes */
/************************************************/

/* ColorRec[0][x] = B&W          */
/* ColorRec[1][x] = Color        */
/* x = 0..9 = Actual Color Codes */
typedef unsigned char ColorRec[2][10];   

/*---------------------------------------------------------------------------*/

typedef struct      /* User name index - NAMES.LST */
{
    unsigned char   Name[37];      /* User name */
    int             Number;     /* User number */
} SmalRec;

/*---------------------------------------------------------------------------*/

typedef struct      /* User log - USER.LST */
{
    unsigned char   Uname[37];             /* User name */
    unsigned char   Rname[37];             /* Real name */
    unsigned char   ADDR[31];              /* Address */
    unsigned char   ComType[31];           /* Computer type */
    unsigned char   CityState[31];         /* City/State */
    unsigned char   Snote[31];             /* SysOp note */
    unsigned int    LastDate;              /* Last date on - Semi-MS-DOS 1900 based fmt */
    unsigned int    LastTime;              /* Last time on - MS-DOS format */
    unsigned char   PW[17];                /* Password */
    unsigned char   Phone[13];             /* Phone number 1 */
    unsigned char   Zcode[11];             /* Zip code */
    unsigned char   Phone2[13];            /* Phone number 2 */
    unsigned char   ExtraStr1[41];         /* Extra string 1 */
    unsigned char   ExtraStr2[41];         /* Extra string 2 */
    unsigned char   ExtraStr3[41];         /* Extra string 3 */
    unsigned int    ExtraDate1;            /* Extra date 1 - Semi-MS-DOS 1900 based fmt */
    unsigned int    ExtraDate2;            /* Extra date 2 - Semi-MS-DOS 1900 based fmt */
    unsigned int    ExtraWord1;            /* Extra word 1 */
    unsigned int    ExtraWord2;            /* Extra word 2 */
    unsigned int    ExtraWord3;            /* Extra word 3 */
    unsigned int    ExtraWord4;            /* Extra word 4 */
    unsigned char   ExtraChar;            /* Extra character 1 */
    unsigned char   ExtraChar2;            /* Extra character 2 */
    unsigned char   ExtraChar3;            /* Extra character 3 */
    unsigned char   ExtraChar4;            /* Extra character 4 */
    unsigned char   ExtraPhone[13];        /* Extra phone */
    unsigned char   uureserved[3];         /* Reserved */

    /*************************************************************/
    /* Vote  = An array of Voting Answers, One for each question */
    /*************************************************************/
    unsigned char   Vote[20];              /* Voting */

    /**********************************************************************/
    /* Call spread for last 15 calls - Number  of days between each call: */
    /* 0      = Called the same day                                       */
    /* 1..253 = X number of days between                                  */
    /* 254    = 254 or more days between                                  */
    /* 255    = Element not used yet                                      */
    /**********************************************************************/
    unsigned char   CallSpr[15];           /* Call spread */

    Real            Ttimeon;               /* Total time on system in minutes */
    Real            UlK;                   /* UL K-Bytes */
    Real            Dlk;                   /* DL K-Bytes */

    /**********************************************************/
    /* UserNum = The User number                              */
    /*           0  -----------------------------> Deleted    */
    /*           Same as Record Number ----------> Normal     */
    /*           Different from Record Number ---> Locked Out */
    /**********************************************************/
    int             UserNum;                /* User number */

    unsigned int    PrivPost;              /* Private posts */
    unsigned int    PubPost;               /* Public posts */
    unsigned int    FeedBack;              /* Feedback sent to SysOp */
    unsigned int    NumCalls;              /* Total number of calls to system */
    unsigned int    NumUL;                 /* Number of uploads */
    unsigned int    NumDL;                 /* Number of downloads */
    int             Fmail;                  /* Forward mail to which user number */
    unsigned int    Hbaud;                  /* Highest baud rate user supports */
    unsigned int    TimeToday;              /* Minutes on system date of last call */
    unsigned int    Credit;                 /* Credit for mail in cents */
    unsigned int    Debit;                  /* Debit for mail in cents */
    unsigned int    Points;                 /* File points */
    unsigned int    TimeBank;               /* Minutes in time bank */
    unsigned int    Bday;                   /* Birthdate of user - Semi-MS-DOS format */
    unsigned int    LastChange;             /* Reserved */
    unsigned char   StrtMenu;               /* Reserved */
    unsigned char   SL;                     /* Security level - SL */
    unsigned char   DSL;                    /* Download security level - DSL */
    unsigned char   Hlvl;                   /* Help level */
    unsigned char   Colms;                  /* Number of screen columns */
    unsigned char   Lines;                  /* Number of screen lines */
    unsigned char   Callstoday;             /* Number of calls to system today */
    unsigned char   Illegal;                /* Illegal logon attempts */

    unsigned char   Gender;                 /* User gender M/F/' '=not specified */

    unsigned char   uulMsgBase;             /* Reserved */
    unsigned char   uuLdlBase;              /* Reserved */
    unsigned char   Cls;                    /* Reserved */
    DefaultYesNoType FullEdit;              /* Full screen editor status */
    ArFlagset       Ar;                     /* AR flag set */
    FlagSet         Flags;                  /* Special flag set */
    unsigned int    FirstOn;                /* Date first on - Semi-MS-DOS format */
    unsigned int    Expires;                /* Date expires - Semi-MS-DOS format */
    unsigned char   UserRecUnused[29];      /* Reserved */
    ColorRec        Colors;                 /* User colors */
    unsigned char   TBdeposit;              /* Time deposited in bank today */
    unsigned char   TBwithdraw;             /* Time withdraw from bank today */
    int             AdjTime;                /* Adjusted time date of last call */
    ConfigFlagSet   ConfigFlags;            /* Configuration Flags */
    unsigned int    lMbase;                 /* Last message section */
    unsigned int    lFbase;                 /* Last file section */
    long            LastQWKCRC;             /* CRC of last QWK .REP packet uploaded */
    unsigned char   Unused;                 /* Reserved */
}
UserRec;

/*---------------------------------------------------------------------------*/

typedef struct      
{
    /* Short messages - SHORTMSG.DAT */
    unsigned char   Msg[161];       /* Message text */
    int             Destin;         /* User number of who message is to */
} SmallMessageRec;

/*---------------------------------------------------------------------------*/

typedef struct      /* Voting questions - VOTING.DAT */
{
    unsigned char Question[75];      /* Question */
    unsigned int NumA;              /* Number of answers in below array */
    struct                  /* Array of answer data */
    {
        unsigned char Ans[41];       /* Answer */
        unsigned int NumRes;        /* Number of users who chose this response */
    }
    Answ[10];
}
Vdatar;

/*---------------------------------------------------------------------------*/

typedef struct      /* File section - FBOARDS.DAT */
{
    unsigned char Name[40];          /* Section name 26 Real Len, Rest Colors */
    unsigned char Filename[9];       /* Listing filename (does not include ".DIR")  */
                            /*   If UL and DL paths are different,         */
                            /*     filename for upload section is "FILES"  */
                            /*   If first character is "@" then *.DIR file */
                            /*     is found in main data files directory   */
    unsigned char DlPathname[31];    /* Download pathname */
    unsigned char UlPathName[31];    /* Upload pathname */
    unsigned char Password[16];      /* Password required */
    UlRecFlagSet Flags;
    unsigned char  DSL;               /* DSL required */
    unsigned char  SeeNames;          /* DSL required to see uploader names */
    ArFlagType ArLvl;       /* AR flag required */
    unsigned char  NoRatioGroupNum;     /* Bit 0    = Ratio disabled */
                                        /* Bits 1-7 = Group number */
} UlRec;

/*---------------------------------------------------------------------------*/

#define FRS_NotValidated        0x01
#define FRS_OwnerRestricted     0x02

typedef struct      /* Set of file flags */
{
    unsigned char   flag1;
} FlagRecSet;     /* 1 byte used for 8 flags in set */

typedef struct      /* File listing - *.DIR */
{
    unsigned char Filename[13];      /* File name */
    unsigned char Description[79];   /* Description */
    unsigned int Nacc;              /* Number of times file downloaded */
    unsigned char  Unused;            /* Reserved */
    unsigned int Blocks;            /* Number of 128 byte blocks in file */
    unsigned char Owner[37];         /* Uploader of file */
    unsigned char Date[9];           /* Date file uploaded */
    unsigned int DateN;             /* Date uploaded in days since Jan 1, 1985 */
    FlagRecSet Flag;        /* File status */
    unsigned char  Points;            /* File points */
}
UlfRec;

/*---------------------------------------------------------------------------*/

/* # currently defined internal shell files */
#define NUMSHELLFILES       13  
#define SFRF_shellshowcall  0x01
#define SFRF_shelllogcall   0x02

typedef struct
{
    DefaultYesNoType    useswap;   /* Swap shell setting */
    unsigned char       flag1;
} shellfilerec;

typedef shellfilerec                    /* Array of shell files */
        shellfilelist[NUMSHELLFILES];

#define NUMNEWUSERQUESTS    29  /* Number of current new user questions */

typedef struct
{
    unsigned char  itemnum;       /* Item number to ask or 0=inactive */
    unsigned char required;   /* Required/optional */
}
newuserquestrec;

typedef newuserquestrec                         /* Array of new   */
        newuserquestlist[NUMNEWUSERQUESTS];     /* user questions */

typedef unsigned int Range[256];    /* Range of values for all security levels */

/*****************************************************/
/* Provide for full 4D awareness (And point support) */
/*****************************************************/

typedef struct      /* Fidonet Style Address (23 Bytes) */
{
    unsigned int Zone;          /* Zone, 1   = N. America */
    unsigned int Net;           /* Net,  120 = SE Michigan */
    unsigned int Node;          /* Node, 116 = CRIMP BBS */
    unsigned int Point;         /* Point, 99% of the time = 0 */
    unsigned char Domain[16];    /* As in FIDONET */
}
AddressType;

/*---------------------------------------------------------------------------*/

typedef struct      /* System status - STATUS.DAT */
{
    unsigned char AltPath[41];           /* Alternate file path */
    unsigned char DictPath[41];          /* Dictionary path */

    unsigned char  DefReadMsgMenu;        /* Wait screen read message menu */

    unsigned char dynamicmsg;         /* Dynamic message numbering active */
    unsigned char dynamicfile;        /* Dynamic file numbering active */
    unsigned char waitscreendisable;  /* Wait screen activity disable */
    unsigned char requiredvoting;     /* Require voting when user logs on */

    unsigned char  automsglines;          /* Auto message number of lines */
    unsigned char  uunewuserexpdays;      /* Reserved */
    unsigned char  addwordsl;             /* Add word to dictionary SL */

    unsigned char expvalkey;             /* User expired validation key (#13=None) */

    unsigned char expwarning;            /* # of days to give warning before expires */
    unsigned char modifymailflags;       /* Sl when allowed to modify mail flags */
    unsigned char netmailfilerequest;    /* SL for NetMail file requests */
    unsigned char netmailfileattach;     /* SL for NetMail file attach */

    unsigned char ModemDebug;         /* Modem debug information written to log */
    unsigned char UseXMS;             /* Use XMS memory for swap shell */
    unsigned char ShowFilesOpen;      /* Show Files Open on Top Screen */
    unsigned char LocalSysopWindow;   /* SysOp window when on locally */
    unsigned char AllowSuperFast;     /* Allow SHIFT password override */
    unsigned char WaitSend;           /* FOSSIL buffer inactive */
    unsigned char OverlayEMS;         /* Attempt EMS of overlays */
    unsigned char EMSOverXMS;         /* Use EMS over XMS memory for swap */
    unsigned char DirectScreen;       /* Direct screen writes */
    unsigned char UseEMS;             /* Use EMS memory for swap shell */
    unsigned char useswap;            /* Use swap shell */
    unsigned char UseFossil;          /* Use FOSSIL driver */
    unsigned char SnowCheck;          /* Snow checking active */

    unsigned char BrowseDSL;             /* DSL to have U/D commands on */
                                /*   File Browse Menu          */

    unsigned char BbsID[9];              /* !2.6f - ID used for Qwk Packets */

    unsigned char TempDlPath[41];        /* Temp File Download Path */

    unsigned int MinKpost;              /* Minimum K-Bytes to post */
    unsigned int MinKul;                /* Minimum K-Bytes to upload */

    unsigned char AutoChatBufOpen;    /* Auto chat buffer open */

    unsigned char nettype[21];           /* Multi-user network type */

    unsigned char uusystatrec2[15];      /* Reserved */

    unsigned char LogonPassword;         /* SL when SysOp PW #1 needed to logon */
    unsigned char ReadTextMsg;           /* SL when allowed to use /READ command */

    unsigned char AlertChatOnly;      /* Alert active only when chat on */
    unsigned char genericinfo;        /* Generic mode active */
    unsigned char LogonPhone;         /* Logon requires phone number */

    unsigned char DefMsgGroup[21];       /* Default msg section group mask */
    unsigned char DefFileGroup[21];      /* Default file section group mask */

    unsigned int MaxQWKMsgsSection;     /* Maximum QWK messages allowed per section */
    unsigned int MaxQWKMsgsTotal;       /* Maximum QWK messages allowed total */

    unsigned char uusystatrec3[9];       /* Reserved */

    unsigned char LastCaller[43];        /* Name and number of last caller */

    unsigned char MenuFastKeys[21];      /* Menu fast keys (e.g. "/") */

    unsigned char BoardPW[17];           /* New user password (Null=None) */
    unsigned char BoardPhone[13];        /* Board phone number */

    unsigned char SysopColor;            /* Chat SysOp color */
    unsigned char UserColor;             /* Chat user color */

    ArFlagType PostCallFlag;    /* Post call ratio AR flag */

    unsigned char NoPostCallChk;         /* SL when post call ratio ignored */
    unsigned char ReinitTime;            /* Minutes to re-init modem when no calls */
    unsigned char StartMenu;             /* Starting menu for users */

    unsigned char UseAutoMsg;         /* Display auto-message during logon */
    unsigned char LogonOffHook;       /* Take phone off-hook on local logon */

    unsigned char NoPointChk;            /* DSL when file points ignored */

    unsigned char LastDate[9];           /* Date last user logged on */

    AddressType Address;        /* Zone/Net/Node/Point/Domain */

    unsigned char UserOn11x;          /* Use USERON.BBS version 1.1x */

    shellfilelist shellfile;    /* Shell file information */

    unsigned char uushellfile[10];       /* Reserved for shell files */

    newuserquestlist newuserquest; /* New user question information */

    unsigned char uunewuserquest[270];   /* Reserved */

    unsigned char ActiveModemRecNum;     /* Active Modem Record Number */

    unsigned char MultiUserPath[41];     /* Multi-user path */

    unsigned char defusereditlist;       /* Default user editor list mode           */
                                /*   0=short, 1=normal, 2=extended, 3=info */

    unsigned char uusystatrec5[10];      /* Reserved */

    unsigned char GfilesPath[41];        /* Main data files path */

    unsigned char StoreBadLogon;      /* Store bad logon info in SysOp log */

    unsigned char MaxBdNum;              /* Maximum number of batch DL files */
    unsigned char MaxBuNum;              /* Maximum number of batch UL files */

    unsigned char BoardName[49];         /* Board name */

    unsigned char SysopMenuSL;           /* SL required for SysOp Control-Q menu */
    ArFlagType SysopMenuAR;     /* AR flag required from Control-Q menu */

    unsigned char SysopName[37];         /* SysOp name */

    unsigned char SwapPath[41];          /* Swap shell path */

    unsigned char ChatPW[17];            /* Chat password */

    unsigned char LastTAGVersion[21];    /* Last version of TAG to run */

    unsigned char nodelistpath[41];      /* Nodelist directory */

    unsigned char BoardCityState[33];    /* !2.6f Board City, State for QWK Pkt */

    unsigned char QWKPath[41];           /* !2.6f QWK Path */

    unsigned char RIPPath[41];           /* RIP Path */

    unsigned char uusystatrec6[2193];    /* Reserved */

    unsigned char SysopPW[3][17];        /* Array of SysOp passwords */

    unsigned char uusystatrec7[120];     /* Reserved */

    Real CallerNum;             /* Total number of calls to system */
    Real UlKtoday;              /* K-Bytes uploaded today */
    Real DlkToday;              /* K-Bytes downloaded today */
    Real uur1;                  /* Reserved */
    Real uur2;                  /* Reserved */
    Real uur3;                  /* Reserved */

    unsigned int Users;                 /* Number of active users */
    unsigned int ActiveToday;           /* Minutes active today */
    unsigned int Callstoday;            /* Calls today */
    unsigned int MsgPostToday;          /* Public messages posted today */
    unsigned int EmailToday;            /* Private messages posted today */
    unsigned int FbackToday;            /* Feedback sent to SysOp today */
    unsigned int UlToday;               /* Number of uploads today */
    unsigned int uuw1;                  /* Reserved */
    unsigned int uuw2;                  /* Reserved */
    unsigned int uuw3;                  /* Reserved */
    unsigned int MaxUsers;              /* Maximum users allowed to be active */
    unsigned int ErrorsToday;           /* Number of errors today */
    unsigned int NusersToday;           /* Number of new users today */
    unsigned int DlToday;               /* Number of downloads today */

    int NewUserMsgTo;       /* User number new user message sent to */
    int uui1;               /* Reserved */
    int SysopMailTo;        /* User number mail to "SYSOP" is sent to */
    int GuestUser;
    int FailedLogonMsgTo;   /* Guest user number (0=None) */
    int uuw5;               /* Reserved */
    int UsageLogDays;       /* Number of days to keep USAGE.LOG */
    int WaitMailUser;       /* Mail waiting on wait screen (0=none) */

    unsigned char UEditJumpSL;           /* SL required for SysOp Control-U menu */
    ArFlagType UEditJumpAR;     /* AR flag required from Control-U menu */

    unsigned char NoviceDisplay;         /* Number of calls to display novice msg */

    unsigned char NodeNumber;            /* Multi-user node number */

    unsigned char UEditJumpPassword;  /* Use System pswd for Quick User Edit */
    unsigned char ScanOnUploads;      /* System permits forced scan on uploads */

    unsigned int MaxTimeInBank;         /* Maximum minutes in time bank */

    unsigned char ShowGifRes;         /* Show GIF resolution */
    unsigned char CheckUploadSpace;   /* Show upload drive space */
    unsigned char SystemSecur;        /* Full keyboard security active */
    unsigned char MultiUser;          /* Board in multi-user mode */

    unsigned char TBmaxDeposit;          /* Maximum daily time bank deposit */
    unsigned char TBmaxWithdraw;         /* Maximum daily time bank withdraw */
    unsigned char SysopLvl;              /* SL for SysOp */
    unsigned char CoSysopLvl;            /* SL for CoSysOp */
    unsigned char uub1;                  /* Reserved */
    unsigned char AddBbsLvl;             /* SL for adding boards to bbs listing */
    unsigned char EmailLvl;              /* SL for sending normal private mail */
    unsigned char uub2;                  /* Reserved */
    unsigned char uub3;                  /* Reserved */
    unsigned char SeeUnvalLvl;           /* DSL for seeing unvalidated files */
    unsigned char DlCoSysopLvl;          /* DSL for Download CoSysOp */
    unsigned char NoRatioChk;            /* DSL for no ratio */
    unsigned char ReadAnon;              /* SL to know see anonymous real name      */
    unsigned char ReplyAnon;             /* SL to reply to anonymous private mail   */
    unsigned char PublicAnonAny;         /* SL to post anonymous on any public base */
    unsigned char PrivateAnonAny;        /* SL to send private anonymous mail       */
    unsigned char MaxPublicCall;         /* Maximum public posts per call */
    unsigned char MaxPrivCall;           /* Maximum private messages per call */
    unsigned char MaxFbackCall;          /* Maximum feedback to SysOp per call */
    unsigned char uub4;                  /* Reserved */
    unsigned char SeePasswords;          /* SL to see user passwords remotely */
    unsigned char uub5;                  /* Reserved */
    unsigned char uub6;                  /* Reserved */
    unsigned char ComPort;               /* Communications port */
    unsigned char TimeOut;               /* Minutes for inactivity time-out */
    unsigned char TimeOutBell;           /* Minutes for inactivity bell */
    unsigned char Backlogdays;           /* Number of days to keep SYSOP.LOG's */
    unsigned char PrivilegeSL;           /* Privilege SL */
    unsigned char PrivilegeDSL;          /* Privilege DSL */
    unsigned char CDmask;                /* Carrier detect mask */
    unsigned char MaxLogonTries;         /* Maximum logon attempts per call */
    unsigned char uub7;                  /* Reserved */
    unsigned char uub8;                  /* Reserved */
    unsigned char UlTimePercent;         /* UL time percent refund */
    unsigned char MaxChats;              /* Maximum chat pages per call */
    unsigned char uub9;                  /* Reserved */
    unsigned char TagLineSL;             /* SL for tag line command */

    unsigned char ClosedSystem;       /* System closed */
    unsigned char TitlePause;         /* Allow [PAUSE] on welcome screen */
    unsigned char LogonBulletin;      /* Logon to the bulletin section */
    unsigned char BlankWait;          /* Blank the wait screen if no activity */
    unsigned char Handles;            /* Allow handles */
    unsigned char AutoANSIDetect;     /* Logon auto-detect ANSI */
    unsigned char SecureSystem;       /* Keyboard security active */
    unsigned char TimePerDay;         /* Time limits represent time per day */
    unsigned char Mailer;             /* External mailer active */
    unsigned char SysopFemale;        /* SysOp is female */
    unsigned char scantosysoplog;     /* File scans are saved in SysOp log */

    Range TimeAllowed;          /* SL array of time per call/per day */
    Range UlDlNumRatio;         /* DSL array of number of file UL ratios */
    Range UlDlKratio;           /* DSL array of K-Byte UL ratios */
    Range CallsAllowed;         /* SL array of calls allowed per day */
    Range PostCall;             /* SL array of posts per 1/10 call */

    unsigned char AutoRIPDetect;      /* Logon auto-detect RIP */

    unsigned char uusystatrec8[7];       /* Reserved */
}
SystatRec;

/*---------------------------------------------------------------------------*/

#define MFSF_MenuOrCheck                0x01
#define MFSF_MenuTimeHelpDisplay        0x02
#define MFSF_MenuBoardDisplayOverride   0x04
#define MFSF_MenuNamePrompt             0x08
#define MFSF_AscIIClearBeforeMenu       0x10
#define MFSF_AnsiClearBeforeMenu        0x20
#define MFSF_RipClearBeforeMenu         0x40

typedef struct
{
    /* Set of menu flags */
    /* 2 bytes used for 16 flags in set */
    unsigned char flag1;
    unsigned char flag2;
} MenuFlagSet;    


/* commandflagset flag1 */
#define CFSF_CmdOrCheck             0x01
#define CFSF_CmdHidden              0x02
#define CFSF_CmdLinkToNext          0x04
#define CFSF_AscIIClearBeforeCmd    0x08
#define CFSF_AscIIPauseAfterCmd     0x10 
#define CFSF_AnsiClearBeforeCmd     0x20
#define CFSF_AnsiPauseAfterCmd      0x40
#define CFSF_RipClearBeforeCmd      0x80

/* commandflagset flag2 */
#define CFSF_RipPauseAfterCmd       0x01
#define CFSF_AnsiOnly               0x02
#define CFSF_RipOnly                0x04

typedef struct      
{
    /* Set of command flags */
    /* 2 bytes used for 16 flags in set */
    unsigned char   flag1;
    unsigned char   flag2;
} CommandFlagSet;    

typedef struct      /* Menus - MENUS.LST */
{
    unsigned char LongD[81];  /* Menu description (menu) -or- */
                     /* Long command desc (command)  */

    unsigned char SL;         /* Security level (SL) */
    unsigned char DSL;        /* Download security level (DSL) */

    ArFlagset ArFlags; /* AR flag set */

    unsigned char UUMenu[10]; /* Reserved */

    union   /* Menu or command - Variant section */
    {
        struct      /* Menu information */
        {
            MenuFlagSet MenuFlags; /* Menu flag set */
            unsigned char MenuNum;          /* Menu number */
            unsigned char mPrompt[49];      /* Menu prompt unless MenuNamePrompt active */
            unsigned char Password[17];     /* Menu password */
            unsigned char FallBack;         /* Fallback menu number */
            unsigned char HelpFile[8];      /* Help file ID name */
            unsigned char StartHelp;        /* Starting help level 0=default */
            unsigned char Location;         /* Menu location                     */
                                   /*   (0=Main, 1=File, 2=ReadMessage) */
        }
        vMenu;
        struct      /* Command information */
        {
            CommandFlagSet CmdFlags;  /* Command flag set */
            unsigned char Pkey;                /* Command PKey */
            unsigned char Pdata[31];           /* Command PData */
            unsigned char Shortd[33];          /* Command short description */
            unsigned char CmdKey[13];          /* Command execution key */
        }
        vCommand;
    }
    Menu;
}
MenuRec;

/*---------------------------------------------------------------------------*/

typedef struct      /* Macro list - MACROS.LST */
{
    int UserN;      /* User number of macro owner */
    unsigned char Key[4][161];   /* Text for each of the macros */
}
MacroRec;

/*---------------------------------------------------------------------------*/

typedef struct      /* Single protocols - SPROT.DAT */
{
    unsigned char Key[13];           /* Execution key */
    unsigned char Desc[61];          /* Description */
    unsigned int MinBaud;           /* Minimum baud rate to use */
    unsigned int MaxBaud;           /* Maximum baud rate to use */
    unsigned char DSL;               /* DSL required */
    unsigned char TempLog[53];       /* Temp log path and name */
    unsigned char UlLog[53];         /* UL log path and name */
    unsigned char DlLog[53];         /* DL log path and name */
    unsigned char UlString[71];      /* UL string for DOS call */
    unsigned char DlString[71];      /* DL string for DOS call */
    unsigned char GoodCode;       /* Result codes mean good transfer */
    unsigned char DlCode[6];         /* DL error level result codes */
    unsigned char ULcode[6];         /* DL error level result codes */
}
SprotocolRec;

typedef struct      /* Batch protocols - BPROT.DAT */
{
    unsigned char Key[13];           /* Execution key */
    unsigned char Desc[61];          /* Description */
    unsigned int MinBaud;           /* Minimum baud rate to use */
    unsigned int MaxBaud;           /* Maximum baud rate to use */
    unsigned char DSL;               /* DSL required */
    unsigned char UlString[71];      /* UL string for DOS call */
    unsigned char DlString[71];      /* DL string for DOS call */
    unsigned char UlList[53];        /* UL file list file path and name */
    unsigned char DlList[53];        /* DL file list file path and name */
    unsigned char TempLog[53];       /* Temp log path and name */
    unsigned char UlLog[53];         /* UL log path and name */
    unsigned char DlLog[53];         /* DL log path and name */
    unsigned char MaxCmdLen;         /* Maximum command line length */
    unsigned char PosFn;             /* Position of filename in log */
    unsigned char PosStatus;         /* Position of status in log */
    unsigned char GoodCode;       /* Result codes mean good transfer */
    unsigned char DlCode[6][11];     /* DL status result codes */
    unsigned char ULcode[6][11];     /* UL status result codes */
}
BprotocolRec;

/*---------------------------------------------------------------------------*/

typedef struct      /* Validation information - VALIDATE.DAT */
{
    unsigned char Key;           /* Execution key */
    unsigned char Desc[161];     /* Descrip sent to user after validation */
                        /* 76 max real length - Rest for color */
    unsigned char SL;            /* SL to set on validation */
    unsigned char DSL;           /* DSL to set on validation */
    unsigned int Credit;        /* Credit in cents to set on validation */
    unsigned int Points;        /* File points to set on validation */
    unsigned int TimeBank;      /* Time bank minutes to set on validation */
    ArFlagset Ar;       /* AR flags to set on validation */
    FlagSet Flags;      /* Special flags to set on validation */
    unsigned int UnusedWord;    /* Reserved */
}
ValidationRec;

/*---------------------------------------------------------------------------*/
    
/* eventtype flag1 */
#define ETF_UnknownEvent        0x01
#define ETF_EventIsExternal     0x02
#define ETF_EventIsActive       0x04
#define ETF_EventIsShell        0x08
#define ETF_EventIsMonthly      0x10
#define ETF_EventIsPermission   0x20
#define ETF_EventIsChat         0x40
#define ETF_EventIsSoft         0x80

/* eventtype flag2 */
#define ETF_BaudIsActive        0x01
#define ETF_SLisActive          0x02
#define ETF_DSLisActive         0x04
#define ETF_ARisActive          0x08
#define ETF_InRatioIsActive     0x10
#define ETF_TimeIsActive        0x20
#define ETF_SetARisActive       0x40
#define ETF_ClearARisActive     0x80

typedef struct      
{
    /* Event flags */
    /* 5 bytes used for 40 flags */
    unsigned char flag1;
    unsigned char flag2;
    unsigned char flag3;
    unsigned char flag4;
    unsigned char flag5;
} EventType;  

typedef unsigned char EventDaysType;     /* Set of event days     */
                                /* (bits 0-6 = Sun..Sat) */

/*****************************************/
/* The Record Structure of the EventFile */
/*****************************************/

typedef struct      /* Events - EVENTS.DAT */
{
    EventType EventFlags;       /* Kinds of Events Supported */
    unsigned char EventDayOfMonth;       /* If monthly, the Day of Month */
    EventDaysType EventDays;    /* If Daily, the Days Active */
    unsigned int EventStartTime;        /* Start Time in Min from Mid. */
    unsigned int EventFinishTime;       /* Finish Time */
    unsigned char EventDesc[33];         /* Description of the Event */
    unsigned char EventQualMsg[65];      /* Msg/Path if he qualifies */
    unsigned char EventNotQualMsg[65];   /* Msg/Path if he doesn't */
    unsigned char EventPreTime;          /* Min. B4 event to rest. Call */
    unsigned char EventOffHook;       /* Take phone Offhook ? */
    unsigned char EventLastDate[9];      /* Last Date Executed */
    unsigned char EventErrorLevel;       /* For Ext Event ErrorLevel */
    unsigned char EventShellPath[9];     /* File for Ext Event Shell */
    unsigned int LoBaud;                /* Low baud rate limit */
    unsigned int HiBaud;                /* High baud rate limit */
    unsigned char LoSL;                  /* Low SL limit */
    unsigned char HiSL;                  /* High SL limit */
    unsigned char LoDSL;                 /* Low DSL limit */
    unsigned char HiDSL;                 /* High DSL limit */
    unsigned char ARflagRequired;        /* AR flag required */
    unsigned int MaxTimeAllowed;        /* Max Time per user this event */
    unsigned char SetARflag;             /* AR Flag to Set */
    unsigned char ClearARflag;           /* AR Flag to Clear */
    unsigned char EventUnused[128];      /* Reserved */
}
EventRecordType;

/*---------------------------------------------------------------------------*/

#define MAXMODEMRESULTCODES 45  /* Maximum number of modem result codes */

typedef unsigned char modemresulttype;   /* Modem result type */

#define RESULTERROR             0       /* Command error */
#define RESULTOK                1       /* Command accepted */
#define RESULTRING              2       /* Phone ringing */
#define RESULTNOCARRIER         3       /* Connect attempt failed */
#define RESULTCONNECT           4       /* Connect succcessful */
#define RESULTWAITSCREEN        5       /* Go to wait screen */
#define RESULTLOCALLOGON        6       /* Logcal logon */
#define RESULTSHELLBATCH        7       /* Shell to batch file */
#define RESULTEXITERRORLEVEL    8       /* Exit system with error level */
#define RESULTEXITSYSTEM        9       /* Exit system with error level 255 */
#define RESULTNODIALTONE        10      /* Reserved */
#define RESULTRINGING           11      /* Reserved */
#define RESULTBUSY              12      /* Reserved */
#define RESULTNOANSWER          13      /* Reserved */
#define RESULTVOICE             14      /* Reserved */

typedef struct
{
    modemresulttype typeofresult;   /* Type of result */
    unsigned char result[51];                /* Test of result */
    long connectrate;            /* Connect rate modem to modem */
    long realrate;               /* Real rate computer to modem */
    long controlcode;            /* Error level or startup code */
    unsigned char fullduplex;             /* Full duplex operation? */
    unsigned char errorcorrecting;        /* Error correcting modem? */
    unsigned char Unused[8];                 /* Reserved */
}
resultrec;

/**********************************************************/
/* Modem string mapping codes:                            */
/*                                                        */
/* Char   Name             Action                         */
/* -----  ---------------  ------------------------------ */
/*  ^     Carat            Control code of next character */
/*  |     Pipe, Split Bar  Carriage return sent           */
/*  `     Accent Mark      1/20th second delay            */
/*  ~     Tilde            1/2 second delay               */
/*  ^-    Carat & Minus    Lower DTR line                 */
/*  ^+    Carat & Plus     Raise DTR line                 */
/**********************************************************/

typedef struct      /* Modem record - MODEM.DAT */
{
    unsigned char uuunused;           /* Unused */
    unsigned char modemdescription[65];  /* Description on modem */
    unsigned char characterdelay;        /* Miliseconds */
    unsigned char ctsrts;             /* Hardware flow control active */
    unsigned char samering;           /* Reserved */
    unsigned char nocollide;          /* Reserved */
    unsigned char numberresults;         /* Number of modem result codes defined */
    resultrec result[MAXMODEMRESULTCODES]; /* Array of results */
    unsigned char preinitialization[65]; /* Pre-initialization string */
    unsigned char initialization[65];    /* Initialization string */
    unsigned char answer[65];            /* Answer string */
    unsigned char busy[65];              /* Busy string */
    unsigned char hangupprimary[65];     /* Hangup primary string */
    unsigned char hangupsecondary[65];   /* Hangup secondard string */
    unsigned char afterhangup[65];       /* After hangup string */
    unsigned char exitsystem[65];        /* Exit system string */
    unsigned char predial[65];           /* Reserved */
    unsigned char dialprefix[65];        /* Reserved */
    unsigned char dialsuffix[65];        /* Reserved */
    long waitbaud;           /* Init modem speed */
    unsigned char lockedbaud;         /* Is baud rate locked - Not used by T.A.G. */
    unsigned char ecefficiency;          /* Error correcting efficiency */
    unsigned char ncefficiency;          /* Normal connect efficiency */
    unsigned char Unused[249];           /* Reserved */
}
modemrec;

/*---------------------------------------------------------------------------*/

#define MAXSUBOPS   10      /* Maximum number of message section SubOps */

typedef unsigned char NoYesForcedType;   /* Message section type */

#define NO          0       /* Anonymous messages not allowed */
#define YES         1       /* Anonymous messages allowed */
#define FORCED      2       /* Messages forced anonymous */
#define ATUNUSED    3       /* Reserved */

/************************************/
/* Standard Attributes for Messages */
/************************************/

/* messageattrflagset - flag1 */
#define MAFS_Private                    0x01
#define MAFS_Crash                      0x02
#define MAFS_Received                   0x04
#define MAFS_Sent                       0x08
#define MAFS_FileAttached               0x10
#define MAFS_KillSent                   0x20
#define MAFS_Local                      0x40
#define MAFS_ReturnReceiptRequest       0x80

/* messageattrflagset - flag2 */
#define MAFS_IsReturnReceipt            0x01
#define MAFS_AuditRequest               0x02
#define MAFS_InTransit                  0x04
#define MAFS_Orphan                     0x08
#define MAFS_HoldForPickup              0x10
#define MAFS_Fido_UnusedBit10           0x20
#define MAFS_FileRequest                0x40
#define MAFS_Fido_FileUpdateRequest     0x80

/* messageattrflagset - flag3 */
#define MAFS_Deleted                    0x01
#define MAFS_Ra_NetmailPendingExport    0x02
#define MAFS_NetMailMessage             0x04
#define MAFS_Ra_EchomailPendingExport   0x08
#define MAFS_Ra_UnusedMsgBit7           0x10
#define MAFS_Ra_UnusedNetBit7           0x20
#define MAFS_Jam_ArchiveSent            0x40
#define MAFS_Jam_Immediate              0x80

/* messageattrflagset - flag4 */
#define MAFS_Jam_Direct                 0x01
#define MAFS_Jam_Gate                   0x02
#define MAFS_Jam_ConfirmRequest         0x04
#define MAFS_Jam_ForcePickUp            0x08
#define MAFS_Jam_TypeLocal              0x10
#define MAFS_Jam_TypeEcho               0x20
#define MAFS_Jam_NoDisplay              0x40
#define MAFS_Jam_Locked                 0x80

typedef struct
{
    /* 4 bytes used for 32 flags */
    unsigned char   flag1;
    unsigned char   flag2;
    unsigned char   flag3;
    unsigned char   flag4;
} MessageAttrFlagSet;     

typedef unsigned char MBstyle;   /* Message section style flags */

#define UUMBBSTYLE      0   /* Was For Private Mail Board */
#define LOCALSTYLE      1   /* Local */
#define ECHOSTYLE       2   /* Echomail */
#define NETMAILSTYLE    3   /* Netmail */
#define GROUPSTYLE      4   /* Groupmail */

typedef unsigned char MBtype;    /* Message section type flags */

#define UUMBTYPE        0   /* Was For Netmail Board */
#define FIDOFORMAT      1   /* Fido 1.Msg Format */
#define RAFORMAT        2   /* Remote Access Format */
#define JAMFORMAT       3   /* Jam Format */

typedef struct      /* Message boards - MBOARDS.DAT */
{
    unsigned char Name[65];                  /* Name of the Board */
    MBstyle Mstyle;                 /* Local/Echo/Netmail */
    MBtype Mtype;                   /* Message Board Type */
    unsigned char RaBoard;                   /* Board Number if RA/QBBS type */
    unsigned char Path[65];                  /* Directory PathName */
    unsigned char OriginLine[66];            /* Origin Line */
    ArFlagType AccessAR;            /* AR flag Required to Access */
    ArFlagType PostAR;              /* AR flag required to Post */
    unsigned char AccessSL;                  /* Security Level Required to Access */
    unsigned char PostSL;                    /* Security Level Required to Post */
    unsigned int MsgCount;                  /* Count of Msgs on the Board */
    unsigned int MaxMsgs;                   /* Max Number of Messages */
    unsigned int uuMaxOld;                  /* Max Days for Messages */
    unsigned char Password[17];              /* Password Required */
    NoYesForcedType Anon;           /* Anonymous Type */
    unsigned char AllowAnsi;              /* Should we allow ANSI */
    NoYesForcedType AllowHandle;    /* Should we allow handles */

    /*********************************************************/
    /* Message Board SubOpts List  - Up to 10 - User Numbers */
    /*********************************************************/

    int SubOps[MAXSUBOPS+1];    /* SubOps - Item 0 = How many */

    unsigned char EchoTag[33];                /* Echo Tag for Writing ECHOMAIL.BBS */
    unsigned char UseOtherAddress;         /* Use something other than system */
    unsigned char JamBoard[9];                /* JAM 8 character file name */
    unsigned char AskPrivate;              /* Ask if in area private message (echos) */
    unsigned char Reserved[13];               /* Unused */
    unsigned char MenuNumber;                 /* Default read message number */
                                     /*  (if 0, use system default) */
    unsigned char PrePostFile[9];             /* Prepost file name */
    unsigned char MinMsgs;                    /* Minimum number of messages */
    unsigned char QuoteStart[71];             /* Override starting quote */
    unsigned char QuoteEnd[71];               /* Override ending quote */
    unsigned int QwkConf;                    /* QWK Conference Number */
    unsigned char GroupNumber;                /* What group the board belongs */
    AddressType OtherAddress;        /* The Address to use! */
    NoYesForcedType RestrictPrivate; /* Private mail status */
    MessageAttrFlagSet DefaultAttr;  /* Default message flags */
    unsigned char QwkName[11];                /* QWK Conference Name */
    unsigned char Filter7Bit;              /* Only allow 7 bit characters */
}
MboardType;

/*---------------------------------------------------------------------------*/

typedef unsigned char LastOnType[8][161];    /* Last Few Callers - LASTON.DAT */

/*---------------------------------------------------------------------------*/

#define MAXBITS     1024    /* Means a 128 byte bit set, bits 0 to 1023 */

typedef unsigned char bitSetType[MAXBITS / 8];   /* Board Flags - ?ZSCAN.DAT */

/*---------------------------------------------------------------------------*/

typedef struct      /* Who's online - $WHO.DAT */
{
    unsigned char Active;
    unsigned char Node;              /* Node number for this rec     */
    unsigned char Available;      /* Is he available for anything */
    unsigned char Uname[37];         /* Users Name                   */
    unsigned char CityState[31];     /* City and State               */
    long Baud;           /* Baud Rate                    */
    unsigned char Paging;            /* Paging Node Number           */
    unsigned char InPrivateChat;     /* Node in private chat with    */
    unsigned char InGroupChat;    /* Is he in Group Chat          */
    unsigned char Desc[65];          /* Long Description             */
}
WhoRecType;

/*---------------------------------------------------------------------------*/

typedef struct      /* USERON.BBS file version 1.00 */
{
    unsigned char Name[36];          /* User name      */
    unsigned char Line;              /* Node number    */
    unsigned int Baud;              /* Connect rate   */
    unsigned char City[26];          /* City/State     */
    unsigned char DoNotDisturb;   /* Do not disturb */
    unsigned char Status;            /* Status         */
}
UserOnType100;

/*---------------------------------------------------------------------------*/

typedef struct      /* USERON.BBS file version 1.1x */
{
    unsigned char Name[36];          /* Real name      */
    unsigned char Handle[36];        /* User name      */
    unsigned char Line;              /* Node number    */
    unsigned int Baud;              /* Connect rate   */
    unsigned char City[26];          /* City/State     */
    unsigned char DoNotDisturb;   /* Do not disturb */
    unsigned char Status;            /* Status         */
    unsigned char Attribute;         /* Attribute      */
}
UserOnType11x;

/*---------------------------------------------------------------------------*/

#endif
