/*

	MTask (multi-tasking) routines for PCOOPE2

	non pre-emptive, multiple level priority

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94

*/


#include "pcoope2.h"
#include "MTask.h"

extern object DLList;
extern object Thread;

unsigned _stklen=STACK_SIZE;	/* sets stack size for dos */

object taskSys[LOW_PRIORITY+1]={NULL,NULL,NULL,NULL};


int    MTaskIni(void);
object Schedule(object curTask);
object GetTask(void (*tm)());
int    InstTask(void (*tm)(),int priority);


static TRtnType Thrdmain[MAX_THREADS];
static object   stackLst[MAX_THREADS];
static int      lastSrch=0;
static int      xndx=0;

static void StackIni(void);

INCLUDEPOLY(pAcc);
INCLUDEPOLY(pIsBlk);
INCLUDEPOLY(pAdd);
INCLUDEPOLY(pLook);
INCLUDEPOLY(pRmv);
INCLUDEPOLY(pReady);
INCLUDEPOLY(pInUse);
INCLUDEPOLY(pUsed);
INCLUDEPOLY(pSetP);
INCLUDEPOLY(pGetP);
INCLUDEPOLY(pGetEl);

#define pAcc 	I_POLY(pAcc)
#define pIsBlk 	I_POLY(pIsBlk)
#define pAdd 	I_POLY(pAdd)
#define pLook 	I_POLY(pLook)
#define pRmv 	I_POLY(pRmv)
#define pReady 	I_POLY(pReady)
#define pInUse 	I_POLY(pInUse)
#define pUsed  	I_POLY(pUsed)
#define pSetP   I_POLY(pSetP)
#define pGetP   I_POLY(pGetP)
#define pGetEl  I_POLY(pGetEl)


int MTaskIni(void)
{
char d[INIT_STACK_ADD];
int x;

if(taskSys[0]!=NULL) return 0;
for(x=0;x<=LOW_PRIORITY;x++)
    {
    taskSys[x]=pNew(DLList,d);
    }
StackIni();
return 1;
}


static void StackIni(void)
{
char 	b[STACK_ADD];
auto int	x;
object		a;

stackLst[xndx]=pNew(Thread,x=xndx,b);
a=pAcc(stackLst[xndx]);
x=setjmp(a);
if(!x)
    {
    if(++xndx<MAX_THREADS) StackIni();
    return;
    }
Thrdmain[x]();
}


int InstTask(void (*tm)(),int priority)
{
int x;

for(x=0;x<MAX_THREADS;x++)
    {
    if ((int)pInUse(stackLst[lastSrch]))
	{
	lastSrch=(lastSrch<MAX_THREADS-1)?lastSrch+1:0;
	}
    else break;
    }
if(x>=MAX_THREADS) return 0;

Thrdmain[lastSrch]=tm;
priority=(priority>LOW_PRIORITY)?LOW_PRIORITY:(priority<0)?0:priority;
pSetP(stackLst[lastSrch],priority);
pAdd(taskSys[priority],stackLst[lastSrch]);
pUsed(stackLst[lastSrch]);
return 1;
}


object GetTask(void (*tm)())
{
int x;

for(x=1;x<MAX_THREADS;x++)
    {
    if(Thrdmain[x]==tm) return stackLst[x];
    }
return NULL;
}


object Schedule(object curTask)
{
int x,y;
object next;
unsigned flags;


for(x=0;x<=LOW_PRIORITY;x++)
    {
    if((next=pRmv(taskSys[x]))!=NULL) break;
    }
if(next==NULL)
    {
    if((int) pIsBlk(curTask))
	{
	pErrNum=pErrFATALDATA;
	pErr(curTask);
	}
    else
	{
	next=curTask;
	}
    }
else if(curTask !=NULL && !((int) pIsBlk(curTask)))
    {
    pReady(curTask);
    pAdd(taskSys[(int) pGetP(curTask)],curTask);
    pReady(next);
    }
y=(int) pGetEl(next);
next=pAcc(next);
if(curTask==NULL)
    {
    longjmp(next,y);
    }
else
    {
    curTask=pAcc(curTask);
    x=setjmp(curTask);
    if(!x)
	{
	longjmp(next,y);
	}
    }
return NULL;
}

