// *************************************************************** //
// Filename:    ChildB.cpp                                         //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //
#include "MDIMenu.h"

// --------------------------------------------------------------- //
// MDIMenuChild constructor                                        //
// --------------------------------------------------------------- //
TMDIChildB::TMDIChildB(TMDIClient &parent, 
  const char far *title, TWindow *clientWnd, 
  BOOL shrinkToClient, TModule *module) :
  TMDIChild(parent, title, clientWnd, shrinkToClient, module)
{
  TMenuDescr menuDescr("BMenu", 0, 0, 0, 1, 0, 0);
  SetMenuDescr(menuDescr);
  Gadget = new TButtonGadget("B", CMB_ACTION);
  Inserted = FALSE;
}

// --------------------------------------------------------------- //
// MDIMenuChild destructor                                         //
// --------------------------------------------------------------- //
TMDIChildB::~TMDIChildB()
{
  if (!Inserted)
  {
    delete Gadget;
  }
}

// --------------------------------------------------------------- //
// GetClassName                                                    //
// --------------------------------------------------------------- //
char *TMDIChildB::GetClassName()
{
  return "MDIChildB";
}

// --------------------------------------------------------------- //
// GetWindowClass                                                  //
// --------------------------------------------------------------- //
void TMDIChildB::GetWindowClass(WNDCLASS &wc)
{
  TMDIChild::GetWindowClass(wc);
  wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
}

// --------------------------------------------------------------- //
// SetupWindow                                                     //
// --------------------------------------------------------------- //
void TMDIChildB::SetupWindow()
{
  TMDIChild::SetupWindow();
  // put new stuff here
}

// --------------------------------------------------------------- //
// CleanupWindow                                                   //
// --------------------------------------------------------------- //
void TMDIChildB::CleanupWindow()
{
  // put new stuff here
  TMDIChild::CleanupWindow();
}

// --------------------------------------------------------------- //
// Response table for MDIMenuChild                                 //
// --------------------------------------------------------------- //
DEFINE_RESPONSE_TABLE1(TMDIChildB, TMDIChild)
  EV_COMMAND(CMB_ACTION, CmAction),
  EV_WM_MDIACTIVATE,
END_RESPONSE_TABLE;


// --------------------------------------------------------------- //
// TryMe                                                           //
// --------------------------------------------------------------- //
void TMDIChildB::CmAction()
{
  MessageBox("Thank you for selecting me", "B", MB_OK);
}


void TMDIChildB::EvMDIActivate(HWND hWndActivated, HWND hWndDeactivated)
{
  TMDIMenuApp *app = TYPESAFE_DOWNCAST(GetApplication(), TMDIMenuApp);
  if (*this == hWndActivated)
  {
    // add button gadgets
    if (app)
    {
      app->ControlBar->Insert(*Gadget);
      app->ControlBar->LayoutSession();
      app->ControlBar->Invalidate();
      Inserted = TRUE;
    }
  }
  else if (*this == hWndDeactivated)
  {
    // remove button gadgets
    if (app && app->ControlBar->Remove(*Gadget))
    {
      app->ControlBar->LayoutSession();
      app->ControlBar->Invalidate();
      Inserted = FALSE;
    }
  }
  // continue with default processing, merge menus
  TMDIChild::EvMDIActivate(hWndActivated, hWndDeactivated);
}



