//*************************************************************
//  File name: MULTICON.CPP
//
//  Description:
//     Implementation for the CMulticonApp class.
//
//  History:    Date       Author     Comment
//              3/8/94     FJB        Created
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1994 Microsoft Corporation. All rights reserved.
//*************************************************************

#include "stdafx.h"
#include "multicon.h"
#include "micondoc.h"
#include "mainfrm.h" 
#include "modview.h"
#include "ellpsevw.h"
#include "rectview.h" 
#include "iconwnd.h" 

//*************************************************************
//  Class:
//      CMulticonApp 
//
//  Description:
//      AppWizard generated CWinApp derived class.
//
//  Derived from:
//      CWinApp
//
//  Data Members: 
//
//  Member Functions:
//      CMulticonApp      : Constructor
//     ~CMulticonApp      : Destructor
//  
//    Implementation:
//      InitInstance      : AppWizard generated.
//      OnIdle            : Enumerates all open views and calls 
//                          InvalidateRect on each.  If the view's frame
//                          is iconic, calls InvalidateRect on the frame.
//
//    Message Handlers:
//      OnAppAbout        : Displays the 'Help About' dialog.
//
//      
//
//  History:    Date       Author     Comment
//              3/8/94     FJB        Created
//
//*************************************************************  


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMulticonApp

BEGIN_MESSAGE_MAP(CMulticonApp, CWinApp)
   //{{AFX_MSG_MAP(CMulticonApp)
   ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
      // NOTE - the ClassWizard will add and remove mapping macros here.
      //    DO NOT EDIT what you see in these blocks of generated code!
   //}}AFX_MSG_MAP
   // Standard file based document commands
   ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
   ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMulticonApp construction

CMulticonApp::CMulticonApp()
{
   // TODO: add construction code here,
   // Place all significant initialization in InitInstance
}  

//*************************************************************
//
//  Class
//      CMulticonApp
//
//  Member Function:
//      OnIdle
//
//  Purpose:
//      Drives the updating of all open views and icons.
//
//  Parameters: 
//      LONG lCount - The number of times this function has been
//                    consecutively called.
//  Return: 
//      BOOL:
//         TRUE  - more OnIdle time needed (at least one view open.)
//         FALSE - OnIdle processing complete (no open views)
//
//  Comments:   
//      This function has the following specific behaviors:
//
//      1. Causes each open view to redraw.
//      2. If a view is minimized, causes it's frame to redraw
//      3. If the application is minimized, causes the main frame
//         to redraw using the active view's output
//
//
//  History:    Date       Author     Comment
//              3/8/94     FJB        Created
//
//*************************************************************


BOOL CMulticonApp::OnIdle(LONG lCount)
{  
   // Do the base class thing and remember the return value.  Use this 
   // return value if no views are open.
   BOOL fMore = CWinApp::OnIdle(lCount);
   
   // Store the size of an icon
   CRect rc(0,0,GetSystemMetrics(SM_CXICON)-1,
                GetSystemMetrics(SM_CYICON)-1);
                
   CWnd* pWnd = AfxGetMainWnd();
   
   
   if (pWnd->IsIconic())
   {  
      // The application is minimized, we need to draw an icon.   
      // See if there is a MDI child.
      if (((CMDIFrameWnd*) pWnd)->MDIGetActive())
      { 
         // At least one view is open.  Update it.     
         pWnd->InvalidateRect(&rc,TRUE);
         pWnd->UpdateWindow();
         return TRUE;
      }
      
      // There were no open views, so the main frame is displaying a 
      // standard icon.  Since this won't change there's no point in
      // forcing a refresh.
   }
   
   // Now we walk the list of all open views.  For an explanation of the
   // algorithm, see article Q106455 in the Microsoft Knowledge Base:
   // - (GO MSKB)

   // First, walk the list of document templates
   POSITION pos = m_templateList.GetHeadPosition();
   while (pos)
   {
      CDocTemplate* pTemplate =
                     (CDocTemplate*)m_templateList.GetNext(pos);
      
      POSITION pos2 = pTemplate->GetFirstDocPosition();
  
      // Next, walk the list of documents for each template
      while (pos2)
      {
         CDocument * pDocument;
         if ((pDocument=pTemplate->GetNextDoc(pos2)) != NULL)
         {  
            // At this point we know there is at least one open view,
            // so make sure we continue to get OnIdle calls
            fMore = TRUE;                                 
            
            POSITION pos3 = pDocument->GetFirstViewPosition();
            
            // Finally, walk the list of each views for each doc.
            while (pos3)
            {
               CView* pView;
               if ((pView=pDocument->GetNextView(pos3)) != NULL)
               {  
                  // If the views parent (the CMDIChildWnd) is iconic, then
                  // we need to refresh an icon sized region on the parent
                  if (pView->GetParent()->IsIconic())
                  { 
                     // We have to specify a CRect because the available
                     // area is actually somewhat larger than an icon.
                     // Specify bErase = FALSE so we don't erase everything
                     // already drawn (the view's don't remember their 
                     // contents.)
                     pView->GetParent()->InvalidateRect(&rc,FALSE);
                     
                     // We have to call UpdateWindow here to prevent a 
                     // WM_PAINT from going through the apps message queue.
                     // Normally, this would be fine but we want OnIdle
                     // to be called during OnEnterIdle, when a menu or
                     // dialog is displayed.  Try commenting this call
                     // out to see what happens...                    
                     pView->GetParent()->UpdateWindow();
                  }
                  else
                  {  
                     // It's business as usual, cause the view to repaint
                     pView->InvalidateRect(NULL, FALSE);                 
                     
                     // See above comment for the purpose of this call.
                     pView->UpdateWindow();
                  }
               }
            } // while (pos3)       
            
         } // if ((pDocument=pTemplate->GetNextDoc(pos))...
      } // while (pos2)
   } // while (pos) 

   return fMore;    
}


/////////////////////////////////////////////////////////////////////////////
// The one and only CMulticonApp object

CMulticonApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CMulticonApp initialization

BOOL CMulticonApp::InitInstance()
{
   // Standard initialization
   // If you are not using these features and wish to reduce the size
   //  of your final executable, you should remove from the following
   //  the specific initialization routines you do not need.

   SetDialogBkColor();        // Set dialog background color to gray
   LoadStdProfileSettings();  // Load standard INI file options 
                              //      (including MRU)

   // Register the application's document templates.  Document templates
   //  serve as the connection between documents, frame windows and views.

   CMultiDocTemplate* pDocTemplate;

   pDocTemplate = new CMultiDocTemplate(
      IDR_RECTTYPE,
      RUNTIME_CLASS(CMulticonDoc),
      RUNTIME_CLASS(CIconWnd),        // standard MDI child frame
      RUNTIME_CLASS(CRectView));
   AddDocTemplate(pDocTemplate);  

   pDocTemplate = new CMultiDocTemplate(
      IDR_ELLIPSETYPE,
      RUNTIME_CLASS(CMulticonDoc),
      RUNTIME_CLASS(CIconWnd),        // standard MDI child frame
      RUNTIME_CLASS(CEllipseView));
   AddDocTemplate(pDocTemplate);



   // create main MDI Frame window
   CMainFrame* pMainFrame = new CMainFrame;
   if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
      return FALSE;
   m_pMainWnd = pMainFrame;

   if (m_lpCmdLine[0] != '\0')
   {
      // TODO: add command line processing here
   }

   // The main window has been initialized, so show and update it.
   pMainFrame->ShowWindow(m_nCmdShow);
   pMainFrame->UpdateWindow();
   
      // create a new document
   OnFileNew();
   
   return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
   CAboutDlg();

// Dialog Data
   //{{AFX_DATA(CAboutDlg)
   enum { IDD = IDD_ABOUTBOX };
   //}}AFX_DATA

// Implementation
protected:
   virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
   //{{AFX_MSG(CAboutDlg)
      // No message handlers
   //}}AFX_MSG
   DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
   //{{AFX_DATA_INIT(CAboutDlg)
   //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CAboutDlg)
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
   //{{AFX_MSG_MAP(CAboutDlg)
      // No message handlers
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CMulticonApp::OnAppAbout()
{
   CAboutDlg aboutDlg;
   aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CMulticonApp commands
