//*************************************************************
//  File name: ICONWND.H
//
//  Description:
//     Declares the interface for the CIconWnd class
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1994 Microsoft Corporation. All rights reserved.
//*************************************************************

//*************************************************************
//  Class:
//      CIconWnd 
//
//  Description:
//      AppWizard generated CMDIChildWnd class that dynamically displays the
//      output from it's view as an icon.
//
//  Derived from:
//      CMDIChildWnd
//
//  Data Members: 
//      CDC       m_dcXOR;        // a memory CDC for icon's XOR bitmap
//      CDC       m_dcAND;        // a memory CDC for icon's AND plane
//      HBRUSH    m_hbrNull;      // NULL brush for drawing bounding rect      
//
//  Member Functions:
//      CIconWnd          : Constructor
//     ~CIconWnd          : Destructor
//  
//    Implementation:
//      PreCreateWindow   : Registers a NULL icon
//
//    Message Handlers:
//      OnPaint           : Scales the view's output down to icon size.
//      OnQueryDragIcon   : Converts current output to an icon
//      OnCreate          : Does some initialization
//      OnDestroy         : Does some cleanup
//
//  Comments
//      This class requires a CView derived class that exposes a public
//      OnDraw override.
//      
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
//*************************************************************  

class CIconWnd : public CMDIChildWnd
{
   DECLARE_DYNCREATE(CIconWnd)
protected:
   CIconWnd();       // protected constructor used by dynamic creation

// Attributes
public:

// Operations
public:

// Implementation
protected:
   virtual BOOL PreCreateWindow (CREATESTRUCT &cs);
   virtual ~CIconWnd();    
   
   CDC       m_dcXOR;        // a memory CDC for icon's XOR bitmap
   CDC       m_dcAND;        // a memory CDC for icon's AND plane
   HBRUSH    m_hbrNull;      // NULL brush for drawing bounding rect

   // Generated message map functions
   //{{AFX_MSG(CIconWnd)
   afx_msg void OnPaint();
   afx_msg HCURSOR OnQueryDragIcon();
   afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
   afx_msg void OnDestroy();
   //}}AFX_MSG
   DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
