//*************************************************************
//  File name: MAINFRM.CPP
//
//  Description:
//     Declares the implementation for the CMainFrame class
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1994 Microsoft Corporation. All rights reserved.
//*************************************************************

//*************************************************************
//  Class:
//      CMainFrame 
//
//  Description:
//      AppWizard generated CMDIFrameWnd class that dynamically displays the
//      output from it's view as it's icon.
//
//  Derived from:
//      CMDIFrameWnd
//
//  Data Members: 
//      CDC       m_dcXOR;        // a memory CDC for icon's XOR bitmap
//      CDC       m_dcAND;        // a memory CDC for icon's AND plane
//      HBRUSH    m_hbrNull;      // NULL brush for drawing bounding rect      
//
//  Member Functions:
//      CMainFrame        : Constructor
//     ~CMainFrame        : Destructor
//  
//    Implementation:
//      PreCreateWindow   : Registers a NULL icon
//
//    Message Handlers:
//      OnPaint           : Scales the output from the active view to icon
//                          size.
//      OnQueryDragIcon   : Converts current output to an icon
//      OnCreate          : Does some initialization
//      OnDestroy         : Does some cleanup
//      OnEraseBkgnd      : Prevents some unfortunate painting behavior
//
//  Comments
//      This class assumes a CView derived class that exposes a public
//      OnDraw override.
//      
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
//************************************************************* 

#include "stdafx.h"
#include "multicon.h"
#include "modview.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
   //{{AFX_MSG_MAP(CMainFrame)
   ON_WM_PAINT()
   ON_WM_QUERYDRAGICON()
   ON_WM_CREATE()
   ON_WM_DESTROY()
   ON_WM_ERASEBKGND()
   ON_WM_ENTERIDLE()
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
   // TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

//*************************************************************
//
//  Class
//      CMainFrame
//
//  Member Function:
//      PreCreateWindow
//
//  Purpose:
//     Registers a window class with a NULL icon.
//
//  Parameters:
//      cs - a CREATESTRUCT reference
//
//  Return: BOOL
//     TRUE  - creation should contine
//     FALSE - stop creation
//   
//
//  Comments:
//     In order to provide an animated icon for a minimized window, it is 
//     necessary to use a window class that specifies a NULL icon.  This will 
//     allow the window to receive WM_PAINT messages while it is minimized so
//     it can render it's iconic appearance.  See article Q74539 in the 
//     Knowledge Base for details on this.
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
//*************************************************************

BOOL CMainFrame::PreCreateWindow (CREATESTRUCT &cs)
{  
   if (CMDIFrameWnd::PreCreateWindow(cs))
   {
      cs.lpszClass = AfxRegisterWndClass ( 
                           CS_DBLCLKS | CS_HREDRAW |
                           CS_VREDRAW,
                           AfxGetApp()->LoadStandardCursor(IDC_ARROW),
                                           (HBRUSH) (COLOR_WINDOW + 1),
                                            0); 
      return TRUE;
    }    
    else 
      return NULL;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
   CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
   CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

//*************************************************************
//
//  Class
//      CMainFrame
//
//  Member Function:
//      OnPaint
//
//  Purpose:
//     Renders icon by scaling the view's output.
//
//  Comments:
//     When the app is minimized, it's frame window is responsible
//     for rendering it's iconic appearance.  In other words, the
//     CMDIFrameWnd's OnPaint handler will be called when the app is
//     minimized.  Instead of duplicating the view's output code, we
//     call the active view's OnDraw function to perform the output.
//     Note that MM_ANISOTROPIC mode is used to scale the view's output
//     to fit. 
//
//     CView::OnDraw is protected, meaning it can only be called from a CView
//     member function.  To get around this, CModView is derived from CView,
//     and OnDraw is made public. 
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
//************************************************************* 

void CMainFrame::OnPaint()
{
   CPaintDC dc(this); // device context for painting
   CRect rc; 
   // get the view
   CMDIChildWnd* pWnd =  ((CMDIFrameWnd*) AfxGetMainWnd())->MDIGetActive();
   if (!pWnd)
   {  
      // there aren't any views, so just draw a standard icon
      dc.DrawIcon(0,0,AfxGetApp()->LoadIcon(IDR_MAINFRAME));
      return;
   }
   // get the view
   CModView* pView = (CModView*) pWnd->GetActiveView();
   ASSERT(pView); 
   // get the view's dimensions
   pView->GetWindowRect(&rc);  
   // set MM_ANISOTROPIC so we can scale the view's output
   dc.SetMapMode(MM_ANISOTROPIC);  
   
   int cxIcon = GetSystemMetrics(SM_CXICON);
   int cyIcon = GetSystemMetrics(SM_CYICON);
    
   dc.SetViewportExt(cxIcon, cyIcon);
   dc.SetWindowExt(rc.Width(),rc.Height());  
  
   // have the view do it's thing  
   pView->OnDraw(&dc);
   // select in the NULL brush and draw the bounding rect
   CBrush* pbrOld = dc.SelectObject(CBrush::FromHandle(m_hbrNull));
   dc.Rectangle(0,0,rc.Width()-1,rc.Height()-1);
   dc.SelectObject(pbrOld);

}

//*************************************************************
//
//  Class
//      CMainFrame
//
//  Member Function:
//      OnQueryDragIcon
//
//  Purpose:
//      Converts current window contents into an icon.
//
//  Comments:
//      When the user clicks the animated icon, the frame window will 
//      receive an WM_QUERYDRAGICON message.  The frame window must convert
//      it's output to an icon using the CreateIcon API.  See the GDIRCRS
//      sample for details on converting to and from icons.    
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
//*************************************************************

HCURSOR CMainFrame::OnQueryDragIcon()
{   
   // this code is cloned from CIconWnd::QueryDragIcon

   // find out how big an icon is
   int cxIcon = GetSystemMetrics(SM_CXICON);
   int cyIcon = GetSystemMetrics(SM_CYICON); 
   
   
   // This case is occurs when the application is not minimized, and the user
   // Alt-Tab's through the task list.
   if (!IsIconic())
      return  AfxGetApp()->LoadIcon(IDR_MAINFRAME);   
      
   // get the CDC* for the frame window  
   CDC* pdcSrc = GetDC();
    
   // create and select the XOR bitmap 
   CBitmap bmpXOR;
   bmpXOR.CreateCompatibleBitmap(pdcSrc, cxIcon, cyIcon);
   CBitmap* pbmpOld1 = m_dcXOR.SelectObject(&bmpXOR);
   
   // copy the current window contents to the XOR bitmap
   m_dcXOR.BitBlt(0, 0, cxIcon, cyIcon, pdcSrc,
                  0, 0, SRCCOPY); 
   
   // create and select the AND bitmap (1 bit plane)
   CBitmap bmpAND;
   bmpAND.CreateBitmap(cxIcon, cyIcon, 1, 1, NULL);
   CBitmap* pbmpOld2 = m_dcAND.SelectObject(&bmpAND); 
   
   m_dcAND.BitBlt(0,0,cxIcon, cyIcon, &m_dcXOR, 0, 0, SRCCOPY);

   m_dcXOR.SelectObject(pbmpOld1);
   m_dcAND.SelectObject(pbmpOld2);
   
   // get the bitmap data for ::CreateIcon
   BITMAP bm;
   bmpAND.GetObject(sizeof(BITMAP), &bm);
   int cb = bm.bmWidthBytes * bm.bmHeight * bm.bmPlanes;
   LPBYTE lpbAND = new __far BYTE[cb];  
   bmpAND.GetBitmapBits(cb, lpbAND);
   
   bmpXOR.GetObject(sizeof(BITMAP), &bm);   
   cb = bm.bmWidthBytes * bm.bmHeight * bm.bmPlanes;
   LPBYTE lpbXOR = new __far BYTE[cb];
   bmpXOR.GetBitmapBits(cb, lpbXOR);   
   
   // make the icon
   HICON hIcon = CreateIcon( AfxGetInstanceHandle(),
                       cxIcon,
                       cyIcon,
                       bm.bmPlanes,
                       bm.bmBitsPixel, 
                       lpbAND,
                       lpbXOR);
   
   // cleanup and return the icon
   delete (BYTE __far *)lpbAND;
   delete (BYTE __far *)lpbXOR;
   ReleaseDC(pdcSrc);

   return hIcon;
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
   if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
      return -1;
   
   CWindowDC dc(this);
   m_dcXOR.CreateCompatibleDC(&dc);
   m_dcAND.CreateCompatibleDC(&dc); 
   m_hbrNull = (HBRUSH) ::GetStockObject(NULL_BRUSH);
   
   return 0;
}

void CMainFrame::OnDestroy()
{
   CMDIFrameWnd::OnDestroy();
   
   m_dcXOR.DeleteDC();
   m_dcAND.DeleteDC();
   
}
 
 
//*************************************************************
//
//  Class
//      CMainFrame
//
//  Member Function:
//      OnEraseBkgnd
//
//  Purpose:
//      Called when the CWnd object needs to be erased.
//
//  Comments:
//      The area available to a minimized window with a NULL class icon is
//      somewhat larger than an icon.  This handler disables background
//      erasure to prevent an undesirable visual effect. Try removing this
//      handler to see what happens.
//
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
//*************************************************************


BOOL CMainFrame::OnEraseBkgnd(CDC* pDC)
{
   // TODO: Add your message handler code here and/or call default
   
   return TRUE;
}

//*************************************************************
//
//  Class
//      CIconWnd
//
//  Member Function:
//      OnEnterIdle
//
//  Purpose:
//      Called when a menu or dialog box enters a modal state.
//
//  Comments:
//      OnIdle processing normally ceases when a menu or modal dialog is 
//      displayed.  This handler resume OnIdle processing under these
//      conditions.
//
//  History:    Date       Author     Comment
//              3/7/94     FJB        Created
//
//*************************************************************


void CMainFrame::OnEnterIdle(UINT nWhy, CWnd* pWho)
{
   CMDIFrameWnd::OnEnterIdle(nWhy, pWho);
   
   LONG lIdleCount = 0; 
   MSG msg;
   // check to see if we can do idle work;
   
   while (!::PeekMessage(&msg, NULL, NULL, NULL, PM_NOREMOVE))
      AfxGetApp()->OnIdle(lIdleCount++);
}
