


makedepend(1)            USER COMMANDS              makedepend(1)



NAME
     makedepend - create dependencies in makefiles

SYNOPSIS
     makedepend [ -Dname=def ] [ -Dname  ]  [  -Iincludedir  ]  [
     -fmakefile  ] [ -oobjsuffix ] [ -sstring ] [ -wwidth ] [ - -
     otheroptions - - ] sourcefile ...

DESCRIPTION
     Makedepend reads each _s_o_u_r_c_e_f_i_l_e in sequence and  parses  it
     like  a  C-preprocessor,  processing  all #_i_n_c_l_u_d_e, #_d_e_f_i_n_e,
     #_u_n_d_e_f, #_i_f_d_e_f, #_i_f_n_d_e_f, #_e_n_d_i_f, #_i_f and #_e_l_s_e directives so
     that  it can correctly tell which #_i_n_c_l_u_d_e, directives would
     be used in a  compilation.   Any  #_i_n_c_l_u_d_e,  directives  can
     reference  files having other #_i_n_c_l_u_d_e directives, and pars-
     ing will occur in these files as well.

     Every  file  that  a  _s_o_u_r_c_e_f_i_l_e   includes,   directly   or
     indirectly,  is what makedepend calls a "dependency".  These
     dependencies are then written to a _m_a_k_e_f_i_l_e in  such  a  way
     that make(1) will know which object files must be recompiled
     when a dependency has changed.

     By default, makedepend places its output in the  file  named
     _m_a_k_e_f_i_l_e  if  it  exists,  otherwise  _M_a_k_e_f_i_l_e. An alternate
     makefile may be specified with  the  -_f  option.   It  first
     searches the makefile for the line

         # DO NOT DELETE THIS LINE -- make depend depends on it.

     or one provided with the -_s option, as a delimiter  for  the
     dependency  output.   If  it finds it, it will delete every-
     thing following this to the end of the makefile and put  the
     output  after this line.  If it doesn't find it, the program
     will append the string to the end of the makefile and  place
     the output following that.  For each _s_o_u_r_c_e_f_i_l_e appearing on
     the command line, makedepend puts lines in the  makefile  of
     the form

          sourcefile.o: dfile ...

     Where "sourcefile.o" is the name from the command line  with
     its  suffix  replaced with ".o", and "dfile" is a dependency
     discovered in a #_i_n_c_l_u_d_e directive while parsing  _s_o_u_r_c_e_f_i_l_e
     or one of the files it included.

EXAMPLE
     Normally, makedepend will be used in a  makefile  target  so
     that  typing "make depend" will bring the dependencies up to
     date for the makefile.  For example,
         SRCS = file1.c file2.c ...
         CFLAGS = -O -DHACK -I../foobar -xyz



X Version 11      Last change: 8 November 1990                  1






makedepend(1)            USER COMMANDS              makedepend(1)



         depend:
                 makedepend -- $(CFLAGS) -- $(SRCS)

OPTIONS
     Makedepend will ignore any option that it  does  not  under-
     stand  so that you may use the same arguments that you would
     for cc(1).

     -Dname=def or -Dname
          Define.   This  places  a  definition   for   _n_a_m_e   in
          makedepend's  symbol  table.   Without  =_d_e_f the symbol
          becomes defined as "1".

     -Iincludedir
          Include directory.  This  option  tells  makedepend  to
          prepend _i_n_c_l_u_d_e_d_i_r to its list of directories to search
          when it encounters a #_i_n_c_l_u_d_e directive.   By  default,
          makedepend only searches /usr/include.

     -fmakefile
          Filename.  This allows  you  to  specify  an  alternate
          makefile in which makedepend can place its output.

     -oobjsuffix
          Object file suffix.  Some systems may have object files
          whose suffix is something other than ".o".  This option
          allows you to specify another suffix, such as ".b" with
          -_o._b or ":obj" with -_o:_o_b_j and so forth.

     -sstring
          Starting string delimiter.  This option permits you  to
          specify  a  different string for makedepend to look for
          in the makefile.

     -wwidth
          Line width.   Normally,  makedepend  will  ensure  that
          every  output line that it writes will be no wider than
          78 characters for the sake of readability.  This option
          enables you to change this width.

     - - options - -
          If makedepend encounters a double hyphen (- -)  in  the
          argument list, then any unrecognized argument following
          it will be silently ignored;  a  second  double  hyphen
          terminates  this  special treatment.  In this way, mak-
          edepend can be made to safely ignore esoteric  compiler
          arguments that might normally be found in a CFLAGS make
          macro (see the EXAMPLE  section  above).   All  options
          that  makedepend recognizes and appear between the pair
          of double hyphens are processed normally.





X Version 11      Last change: 8 November 1990                  2






makedepend(1)            USER COMMANDS              makedepend(1)



ALGORITHM
     The approach used in this program enables it to run an order
     of  magnitude faster than any other "dependency generator" I
     have ever seen.  Central to this performance are two assump-
     tions:  that all files compiled by a single makefile will be
     compiled with roughly the same -_I and -_D options;  and  that
     most  files  in  a single directory will include largely the
     same files.

     Given these assumptions, makedepend  expects  to  be  called
     once for each makefile, with all source files that are main-
     tained by the makefile appearing on the  command  line.   It
     parses  each source and include file exactly once, maintain-
     ing an internal symbol table for each.  Thus, the first file
     on the command line will take an amount of time proportional
     to the amount of time that a normal  C  preprocessor  takes.
     But  on  subsequent files, if it encounter's an include file
     that it has already parsed, it does not parse it again.

     For example, imagine you are compiling  two  files,  _f_i_l_e_1._c
     and _f_i_l_e_2._c, they each include the header file _h_e_a_d_e_r._h, and
     the file _h_e_a_d_e_r._h in turn  includes  the  files  _d_e_f_1._h  and
     _d_e_f_2._h. When you run the command

         makedepend file1.c file2.c

     makedepend will parse _f_i_l_e_1._c and consequently, _h_e_a_d_e_r._h and
     then  _d_e_f_1._h  and _d_e_f_2._h. It then decides that the dependen-
     cies for this file are

         file1.o: header.h def1.h def2.h

     But when the program parses _f_i_l_e_2._c and discovers  that  it,
     too, includes _h_e_a_d_e_r._h, it does not parse the file, but sim-
     ply adds _h_e_a_d_e_r._h, _d_e_f_1._h and _d_e_f_2._h to the list  of  depen-
     dencies for _f_i_l_e_2._o.

SEE ALSO
     cc(1), make(1)

BUGS
     If you do not have  the  source  for  cpp,  the  Berkeley  C
     preprocessor, then makedepend will be compiled in such a way
     that all #_i_f directives will evaluate to  "true"  regardless
     of  their  actual  value.  This may cause the wrong #_i_n_c_l_u_d_e
     directives to be evaluated.  Makedepend should  simply  have
     its own parser written for #_i_f expressions.

     Imagine you are parsing two files, say _f_i_l_e_1._c and  _f_i_l_e_2._c,
     each  includes  the file _d_e_f._h. The list of files that _d_e_f._h
     includes might truly be different when _d_e_f._h is included  by
     _f_i_l_e_1._c  than  when  it  is  included  by  _f_i_l_e_2._c. But once



X Version 11      Last change: 8 November 1990                  3






makedepend(1)            USER COMMANDS              makedepend(1)



     makedepend arrives at a list of dependencies for a file,  it
     is cast in concrete.

AUTHOR
     Todd Brunhoff, Tektronix, Inc. and MIT Project Athena


















































X Version 11      Last change: 8 November 1990                  4



