//REGEN_FILEHEADING
//REGEN_FILEHEADING

     /********************************************************************
      *                                                                  *
      *   Source File: METER.c                                           *
      *   Description: Source for METER application                      *
      *   Date:        Wed Mar 23 19:28:35 1994                          *
      *                                                                  *
      ********************************************************************/

#include <windows.h>
#include "METER.h"

//REGEN_VARIABLES

#include <string.h>
#include <stdio.h>
#include <ddeml.h>
#include <dde.h>

const int MaxStringLength=128;
const int MaxPathLength=260;

void SaveTotal(HWND hWnd, DWORD dwTime);
int ShowMessage(HWND hWnd, UINT uiID, UINT uiStyle);
HDDEDATA CALLBACK DDECallback ( WORD wType, WORD wFmt, HCONV hConvX, HSZ hsz1,
                                HSZ hsz2, HDDEDATA hData, DWORD dwData1,
                                DWORD dwData2 );
void LoadWindowPos(HWND hWndMain);
void SaveWindowPos(HWND hWndMain);
void UpdateTitle(HWND hWnd, DWORD dwTicks);
void FormatTicks(DWORD dwTicks, char szBuffer[]);


static DWORD    idInst = 0L;            /*  Instance of app for DDEML       */
static HCONV    hConv = NULL;           /*Handle of established conversation*/
static char szAppName[] = "Meter";

HINSTANCE hInst;

//REGEN_VARIABLES

LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);
HACCEL   hAccel;

int PASCAL WinMain(HINSTANCE hInstance,      // Application Instance Handle
                   HINSTANCE hPrevInstance,  // Previous Instance Handle
                   LPSTR  lpszCmdLine,       // Pointer to Command Line
                   int    nCmdShow)          // Show Window Option
{
   //REGEN_BEGINFUNCTION
   HMENU hMenu;
   //REGEN_BEGINFUNCTION

   MSG      msg;
   HWND     hWndMain;

   WNDCLASS wndclass;
   hInst = hInstance;

   hAccel = LoadAccelerators(hInstance, szAppName);

   if(!hPrevInstance)
   {
      wndclass.style           = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc     = MainWndProc;
      wndclass.cbClsExtra      = 0;
      wndclass.cbWndExtra      = 0;
      wndclass.hInstance       = hInstance;
      wndclass.hCursor         = LoadCursor(NULL, IDC_ARROW);
      wndclass.hIcon           = LoadIcon(hInstance, szAppName);
      wndclass.hbrBackground   = CreateSolidBrush(GetSysColor(COLOR_WINDOW));
      wndclass.lpszMenuName    = szAppName;
      wndclass.lpszClassName   = szAppName;

      if(!RegisterClass(&wndclass))
         return FALSE;
   }

   //REGEN_INITVIEW
	if (hPrevInstance){
		HWND hWndPrev=FindWindow(szAppName, NULL);
		if (hWndPrev){
      	ShowWindow(hWndPrev, nCmdShow);
			return FALSE;
      }
   }
	//REGEN_INITVIEW

   if(!(hWndMain = CreateWindow(szAppName,
							  szAppName,
                       WS_OVERLAPPEDWINDOW,
                       CW_USEDEFAULT, 0,
                       CW_USEDEFAULT, 0,
                       NULL, (HMENU)NULL, hInstance, NULL)))
        return FALSE;

   //REGEN_MAINWND
   if (!(hMenu= LoadMenu(hInst, MAKEINTRESOURCE(1)))){
		return FALSE;
   }
   SetMenu(hWndMain, hMenu);
   {
	LONG lStyle;  // remove maximaze button
   lStyle = GetWindowLong(hWndMain, GWL_STYLE);
   SetWindowLong(hWndMain, GWL_STYLE, lStyle &~WS_MAXIMIZEBOX);
	}
   UpdateTitle(hWndMain, 0);
	LoadWindowPos(hWndMain);
   //REGEN_MAINWND

   ShowWindow(hWndMain, nCmdShow);
   UpdateWindow(hWndMain);

   while(GetMessage(&msg, NULL, 0, 0))
         if(!TranslateAccelerator(hWndMain, hAccel, &msg))
          {
             TranslateMessage(&msg);
             DispatchMessage(&msg);
          }

   //REGEN_APPTERM
   DestroyMenu(hMenu);
   lpszCmdLine=lpszCmdLine;
   //REGEN_APPTERM
   return msg.wParam;
}

LRESULT CALLBACK MainWndProc(HWND hWnd, UINT wMessage, WPARAM wParam, LPARAM lParam)
{

   //REGEN_WINDOWPROCVARIABLES
	static UINT uiTimer=1;
	static DWORD dwTimeFrom;
   static DWORD dwTotalOn;
	static FARPROC lpDdeProc;      /*  DDE callback function           */
   //REGEN_WINDOWPROCVARIABLES

   switch(wMessage)
   {
       //REGEN_WNDPROC
		 case WM_CREATE:
				{
				if (!SetTimer(hWnd, uiTimer, 7500, NULL)){
					ShowMessage(hWnd, 5, MB_ICONSTOP);
					return -1;
            }
				lpDdeProc = MakeProcInstance ( (FARPROC) DDECallback, hInst );
				if (DdeInitialize ( (LPDWORD)&idInst, (PFNCALLBACK)lpDdeProc,
										APPCMD_CLIENTONLY, 0L ) ){
					ShowMessage(hWnd, 7, MB_ICONSTOP);
               return -1;
				}
				dwTimeFrom = GetTickCount();
				char szIniFile[MaxStringLength];
				char szTotal[MaxStringLength];
				char szEntry[MaxStringLength];
				char szTime[MaxStringLength];
            lstrcpy(szIniFile, szAppName);
				lstrcat(szIniFile,".INI");
				LoadString(hInst, 2, (LPSTR)szTotal, MaxStringLength);
				LoadString(hInst, 11, (LPSTR)szEntry, MaxStringLength);
				if (!GetPrivateProfileString(szTotal, szEntry,"0",
						szTime, MaxStringLength, szIniFile)){
			   	ShowMessage(hWnd, 4, MB_ICONSTOP);
				}
				sscanf(szTime, "%lu", &dwTotalOn);
				}
				break;

		 case WM_CLOSE:
			 	DWORD dwTimeNow = GetTickCount();
			 	SaveTotal(hWnd, dwTotalOn+dwTimeNow-dwTimeFrom);
				SaveWindowPos(hWnd);
				DestroyWindow(hWnd);
       		break;

		 case WM_TIMER:
				{
            // If our timer, update window
				if (wParam==uiTimer){
					DWORD dwTimeNow=GetTickCount();
            	UpdateTitle(hWnd, dwTimeNow-dwTimeFrom);
					if (!IsIconic(hWnd)){
						InvalidateRect(hWnd, NULL, TRUE);
      			}
				}
				}
            break;
		 case WM_QUERYENDSESSION:
	         {
            // If we return TRUE we are saying it's ok with us to end the
            // windows session.
				DWORD dwTimeNow = GetTickCount();
				SaveTotal(hWnd, dwTotalOn+dwTimeNow-dwTimeFrom);
				return((LRESULT) TRUE);  // we agree to end session.
				}

		 case WM_PAINT:
				{
				char szText[MaxStringLength];
				PAINTSTRUCT ps;
            RECT rect;
				BeginPaint(hWnd, &ps);
				GetClientRect(hWnd, &rect);
				RECT rectUpper=rect;
				rectUpper.bottom=rect.top+(rectUpper.bottom-rect.top)/2;
				DWORD dwTimeNow = GetTickCount();
				char szBuffer[MaxStringLength];
				LoadString(hInst, 6, (LPSTR)szText, MaxStringLength);
				lstrcat(szText, ": ");
				FormatTicks(dwTimeNow-dwTimeFrom, szBuffer);
            lstrcat(szText, szBuffer);
				DrawText(ps.hdc, szText, lstrlen(szText), &rectUpper,
						DT_CENTER | DT_VCENTER | DT_SINGLELINE);
            RECT rectLower;
				SubtractRect(&rectLower, &rect, &rectUpper);
				LoadString(hInst, 2, (LPSTR)szText, MaxStringLength);
				lstrcat(szText, ": ");
				FormatTicks(dwTotalOn+dwTimeNow-dwTimeFrom, szBuffer);
            lstrcat(szText, szBuffer);
				DrawText(ps.hdc, szText, lstrlen(szText), &rectLower,
					DT_CENTER | DT_VCENTER | DT_SINGLELINE);
				EndPaint(hWnd, &ps);
				}
            break;
       //REGEN_WNDPROC

       case WM_INITDIALOG :

         //REGEN_WM_INITDIALOG
         //REGEN_WM_INITDIALOG

         break;

       case WM_COMMAND :
          if(!LOWORD(lParam))
          {                             // Process Menu Commands
             switch(wParam)             // Determine which Menu ID
             {
             case IDM_INSTALL :
                {
                //REGEN_INSTALL
					 HSZ  hszService;
					 HSZ  hszTopic;
					 hszService = DdeCreateStringHandle ( idInst, "PROGMAN", CP_WINANSI );
         		 hszTopic = DdeCreateStringHandle ( idInst, "PROGMAN", CP_WINANSI );
					 if (!hConv){
					 	hConv = DdeConnect (idInst, hszService, hszTopic,
                                       (PCONVCONTEXT)NULL );
					 }
					 HDDEDATA       hData;
					 char  szDDEString[MaxStringLength+2*MaxPathLength];
					 LoadString(hInst, 8, (LPSTR)szDDEString, MaxStringLength);
					 hData = DdeCreateDataHandle ( idInst, &szDDEString,
              	            lstrlen(szDDEString)+1, 0L, NULL, CF_TEXT, 0 );
                if ( hData ){
  	         		  hData = DdeClientTransaction ( (LPBYTE)hData, -1, hConv,
										 NULL, CF_TEXT, XTYP_EXECUTE, 2000, NULL);
					 }
					 char szFileName[MaxPathLength];
					 if(GetModuleFileName(hInst, szFileName, MaxPathLength)){
						 char szFormat[MaxStringLength];
						 LoadString(hInst, 9, (LPSTR)szFormat, MaxStringLength);
						 sprintf(szDDEString, szFormat, szFileName, szFileName);
						 hData = DdeCreateDataHandle ( idInst, &szDDEString,
     		                     lstrlen(szDDEString)+1, 0L, NULL, CF_TEXT, 0 );
        		       if ( hData ){
           				  hData = DdeClientTransaction ( (LPBYTE)hData, -1, hConv,
											 NULL, CF_TEXT, XTYP_EXECUTE, 2000, NULL);
						 }
  	             }
					 DdeDisconnect(hConv);
        	       hConv = NULL;
					 DdeFreeStringHandle ( idInst, hszTopic );
					 DdeFreeStringHandle ( idInst, hszService );
                //REGEN_INSTALL
                }
                break;
             case IDM_UNINSTALL :
                {
                //REGEN_UNINSTALL
					 if(IDYES==ShowMessage(hWnd, 3, MB_ICONSTOP | MB_YESNOCANCEL)){
						HSZ  hszService;
						HSZ  hszTopic;
						hszService = DdeCreateStringHandle ( idInst, "PROGMAN", CP_WINANSI );
         			hszTopic = DdeCreateStringHandle ( idInst, "PROGMAN", CP_WINANSI );
 					   if (!hConv){
							hConv = DdeConnect (idInst, hszService, hszTopic,
	                	                     (PCONVCONTEXT)NULL );
						}
						HDDEDATA       hData;
						char  szDDEString[MaxStringLength];
						LoadString(hInst, 8, (LPSTR)szDDEString, MaxStringLength);
						hData = DdeCreateDataHandle ( idInst, &szDDEString,
               	           lstrlen(szDDEString)+1, 0L, NULL, CF_TEXT, 0 );
		            if ( hData ){
   		           hData = DdeClientTransaction ( (LPBYTE)hData, -1, hConv,
										 NULL, CF_TEXT, XTYP_EXECUTE, 2000, NULL);
         		   }
						LoadString(hInst, 10, (LPSTR)szDDEString, MaxStringLength);
						hData = DdeCreateDataHandle ( idInst, &szDDEString,
                          lstrlen(szDDEString)+1, 0L, NULL, CF_TEXT, 0 );
		            if ( hData ){
   		           hData = DdeClientTransaction ( (LPBYTE)hData, -1, hConv,
										 NULL, CF_TEXT, XTYP_EXECUTE, 2000, NULL);
         		   }
						DdeDisconnect(hConv);
   	            hConv = NULL;
						DdeFreeStringHandle ( idInst, hszTopic );
						DdeFreeStringHandle ( idInst, hszService );
						dwTimeFrom = GetTickCount();
                  dwTotalOn=0;
						SaveTotal(hWnd, 0);
						if (!IsIconic(hWnd)){
							InvalidateRect(hWnd, NULL, TRUE);
						}
					 };
                //REGEN_UNINSTALL
                }
                break;
             case IDM_EXIT :
                {
                //REGEN_EXIT
					 PostMessage(hWnd, WM_CLOSE, 0, 0L);
                //REGEN_EXIT
                }
                break;
             case IDM_COPY :
                {
                //REGEN_COPY
					 char szText[MaxStringLength];
 					 DWORD dwTimeNow = GetTickCount();
 	 				 char szBuffer[MaxStringLength];
 					 LoadString(hInst, 6, (LPSTR)szText, MaxStringLength);
					 lstrcat(szText, ": ");
					 FormatTicks(dwTimeNow-dwTimeFrom, szBuffer);
					 lstrcat(szText, szBuffer);
					 lstrcat(szText, "\n");
					 LoadString(hInst, 2, (LPSTR)szBuffer, MaxStringLength);
					 lstrcat(szText, szBuffer);
					 lstrcat(szText, ": ");
					 FormatTicks(dwTotalOn+dwTimeNow-dwTimeFrom, szBuffer);
	             lstrcat(szText, szBuffer);
					 lstrcat(szText, "\n");
					 if(OpenClipboard(hWnd)){
                	HANDLE hText;
						EmptyClipboard();
                  hText=GlobalAlloc(GHND, lstrlen(szText)+1);
						LPSTR lpText;
						lpText = (LPSTR) GlobalLock(hText);
                  lstrcpy(lpText, (LPSTR)szText);
						GlobalUnlock(hText);
						SetClipboardData(CF_TEXT, hText);
                  CloseClipboard();
                }
                //REGEN_COPY
                }
                break;
             case IDM_INDEX :
                {
                //REGEN_INDEX
					 char szHelpFile[MaxStringLength];
					 lstrcpy(szHelpFile, szAppName);
                lstrcat(szHelpFile, ".HLP");
                WinHelp(hWnd, szHelpFile, HELP_INDEX, 0);
                //REGEN_INDEX
                }
                break;
             case IDM_TOPICSEARCH :
                {
                //REGEN_TOPICSEARCH
                //REGEN_TOPICSEARCH
                }
                break;
             case IDM_USINGHELP :
                {
                //REGEN_USINGHELP
					 char szHelpFile[MaxStringLength];
					 lstrcpy(szHelpFile, szAppName);
                lstrcat(szHelpFile, ".HLP");
                WinHelp(hWnd, szHelpFile, HELP_HELPONHELP, 0);
                //REGEN_USINGHELP
                }
                break;
             case IDM_ABOUT :
                {
                //REGEN_ABOUT
					 ShowMessage(hWnd, 12, MB_OK);
                //REGEN_ABOUT
                }
                break;

             }
          }
          else
          {
             //REGEN_CUSTOMCOMMAND
             //REGEN_CUSTOMCOMMAND

             switch(wParam)
             {
             }
          }
           
          break;

       case WM_DESTROY :

          //REGEN_DESTROY
          KillTimer(hWnd, uiTimer);
			 DdeUninitialize ( idInst );
			 FreeProcInstance(lpDdeProc);
			 char szHelpFile[MaxStringLength];
			 lstrcpy(szHelpFile, szAppName);
          lstrcat(szHelpFile, ".HLP");
			 WinHelp(hWnd, szHelpFile, HELP_QUIT, 0);
          //REGEN_DESTROY

          PostQuitMessage(0);
          break;

       default :
          return DefWindowProc(hWnd, wMessage, wParam, lParam);
   }
   return 0L;
}

//REGEN_CUSTOMCODE

#pragma argsused
HDDEDATA CALLBACK DDECallback ( WORD wType, WORD wFmt, HCONV hConvX, HSZ hsz1,
                                HSZ hsz2, HDDEDATA hData, DWORD dwData1,
                                DWORD dwData2 )
{
	HDDEDATA rc=(HDDEDATA)NULL;

   switch ( wType )
   {
		case XTYP_DISCONNECT:
			hConv = NULL;
			break;
      case XTYP_ERROR:
			hConv = NULL;
			break;
   }
	return rc;
}



void SaveTotal(HWND hWnd, DWORD dwTime)
{
	char szIniFile[MaxStringLength];
	char szTotal[MaxStringLength];
	char szEntry[MaxStringLength];
	char szTime[MaxStringLength];
	lstrcpy(szIniFile, szAppName);
	lstrcat(szIniFile, ".INI");
	LoadString(hInst, 2, (LPSTR)szTotal, MaxStringLength);
	LoadString(hInst, 11, (LPSTR)szEntry, MaxStringLength);
	sprintf(szTime, "%lu", dwTime);
	if (!WritePrivateProfileString(szTotal, szEntry,
			dwTime?szTime:NULL, szIniFile)){
   	ShowMessage(hWnd, 4, MB_ICONSTOP);
	}
}


int
ShowMessage(HWND hWnd, UINT uiID, UINT uiStyle)
{
	char szMessage[MaxStringLength];
	char szTitle[MaxStringLength];
	LoadString(hInst, uiID, (LPSTR)szMessage, MaxStringLength);
	GetWindowText(hWnd, szTitle, MaxStringLength);
	return(MessageBox(hWnd, szMessage, szTitle, uiStyle));
}

void
LoadWindowPos(HWND hWndMain)
{
	int x,y,cx,cy;
	char szIniFile[MaxStringLength];
	char szPosition[MaxStringLength];
	char szEntry[MaxStringLength];
	lstrcpy(szIniFile, szAppName);
	lstrcat(szIniFile, ".INI");
	LoadString(hInst, 13, (LPSTR)szPosition, MaxStringLength);
	LoadString(hInst, 14, (LPSTR)szEntry, MaxStringLength);
	x=GetPrivateProfileInt(szPosition, szEntry, 0, szIniFile);
	LoadString(hInst, 15, (LPSTR)szEntry, MaxStringLength);
	y=GetPrivateProfileInt(szPosition, szEntry, 0, szIniFile);
	LoadString(hInst, 16, (LPSTR)szEntry, MaxStringLength);
	cx=GetPrivateProfileInt(szPosition, szEntry, 0, szIniFile);
	LoadString(hInst, 17, (LPSTR)szEntry, MaxStringLength);
	cy=GetPrivateProfileInt(szPosition, szEntry, 0, szIniFile);
	if(x*y*cx*cy){
		SetWindowPos(hWndMain, NULL, x, y, cx, cy,
				SWP_NOZORDER | SWP_NOREDRAW | SWP_NOACTIVATE);
   }
}

void
SaveWindowPos(HWND hWnd)
{
	if (!IsIconic(hWnd)){
		char szIniFile[MaxStringLength];
		char szPosition[MaxStringLength];
		char szEntry[MaxStringLength];
		char szString[MaxStringLength];
		RECT rect;
		GetWindowRect(hWnd, &rect);
		lstrcpy(szIniFile, szAppName);
		lstrcat(szIniFile, ".INI");
		LoadString(hInst, 13, (LPSTR)szPosition, MaxStringLength);
		LoadString(hInst, 14, (LPSTR)szEntry, MaxStringLength);
	   sprintf(szString,"%d", rect.left);
		WritePrivateProfileString(szPosition, szEntry, szString, szIniFile);
		LoadString(hInst, 15, (LPSTR)szEntry, MaxStringLength);
		sprintf(szString,"%d", rect.top);
		WritePrivateProfileString(szPosition, szEntry, szString, szIniFile);
		LoadString(hInst, 16, (LPSTR)szEntry, MaxStringLength);
		sprintf(szString,"%d", rect.right-rect.left);
		WritePrivateProfileString(szPosition, szEntry, szString, szIniFile);
		LoadString(hInst, 17, (LPSTR)szEntry, MaxStringLength);
		sprintf(szString,"%d", rect.bottom-rect.top);
		WritePrivateProfileString(szPosition, szEntry, szString, szIniFile);
   }
}

void
UpdateTitle(HWND hWnd, DWORD dwTicks)
{
	char szTitle[MaxStringLength];
	GetWindowText(hWnd, szTitle, MaxStringLength);
	lstrcpy(szTitle, szAppName);
	lstrcat(szTitle," ");
	char szTime[MaxStringLength];
	FormatTicks(dwTicks, szTime);
	lstrcat(szTitle, szTime);
  	SetWindowText(hWnd, szTitle);
}

void
FormatTicks(DWORD dwTicks, char szBuffer[])
{
	sprintf(szBuffer, "%lu:%02lu", dwTicks/3600000L, dwTicks/60000L%60L);
}

//REGEN_CUSTOMCODE
