#include <windows.h>
#include <bivbx.h>

#define KNIFE_DATA
#include "knifevbx.h"
#include "knife1.rh"

HINSTANCE hInst;
#define VBXGetDlgItem( w, i )           VBXGetHctl( GetDlgItem(w, i) )

BOOL CALLBACK _export DialogProc( HWND hWnd, WORD wMsg, WORD wParam,
                                  LONG lParam )
{
  HCTL  hKnife;
  ERR   vbErr;
  long  temp;
  float ZoomFactor;

  switch( wMsg ) {
    case WM_COMMAND:
      switch( wParam ) {
        case IDOK:
          EndDialog( hWnd, 0 );
          break;
        case IDC_ZOOM:
          hKnife = VBXGetDlgItem( hWnd, IDC_KNIFE1 );
          vbErr  = VBXGetPropByName( hKnife, "ZoomFactor", &temp );
          ZoomFactor = * (float *) &temp;

          ZoomFactor += 0.1;
          temp = * (long *) &ZoomFactor;
          vbErr = VBXSetPropByName( hKnife, "ZoomFactor", temp );

          vbErr = VBXGetPropByName( hKnife, "ZoomFactor", &temp );
          ZoomFactor = * (float *) &temp;
          break;
        case IDC_SHRINK:
          hKnife = VBXGetDlgItem( hWnd, IDC_KNIFE1 );
          vbErr  = VBXGetPropByName( hKnife, "ZoomFactor", &temp );
          ZoomFactor = * (float *) &temp;

          ZoomFactor -= 0.1;
          if( ZoomFactor >= 0.1 ) {
            temp = * (long *) &ZoomFactor;
            vbErr = VBXSetPropByName( hKnife, "ZoomFactor", temp );
          }
          break;
        default: 
          break;
      }
      return FALSE;
    case WM_INITDIALOG:
      VBXInitDialog( hWnd, hInst, "KNIFE1_DIALOG" );
      hKnife = VBXGetDlgItem( hWnd, IDC_KNIFE1 );
      short image = imkLoad( "cuckoo8.bmp", 3, 0 );
      VBXSetPropByName( hKnife, "FullPicture", (LONG) image );
      return FALSE;
  }
  return FALSE;
}

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow )
{
  hInst = hInstance;

  if( !VBXInit( hInstance, "THUNDER" ) ) {
    MessageBox( NULL, "Can't init VBX library", NULL, MB_OK );
    return 0;
  }
  if( !imkBegin() ) {
    MessageBox( NULL, "Can't init IMK library", NULL, MB_OK );
    return 0;
  }

  FARPROC fproc = (FARPROC) MakeProcInstance( (FARPROC) DialogProc, hInstance );

  if( DialogBox( hInstance, "KNIFE1_DIALOG", NULL, (DLGPROC) fproc ) == -1 ) {
    MessageBox( NULL, "Can't load dialog box", NULL, MB_OK );
  }
  imkEnd();
  VBXTerm();
  return 0;
}


