#ifndef AHELLOWINDOW_HPP
#define AHELLOWINDOW_HPP
/******************************************************************************/
/* HELLO WORLD SAMPLE PROGRAM - Version 4: Class Header (AHELLOW4.HPP)        */
/*                                                                            */
/* COPYRIGHT: Copyright (C) International Business Machines Corp., 1992,1993. */
/*                                                                            */
/* DISCLAIMER OF WARRANTIES:                                                  */
/*   The following [enclosed] code is sample code created by IBM              */
/*   Corporation.  This sample code is not part of any standard IBM product   */
/*   and is provided to you solely for the purpose of assisting you in the    */
/*   development of your applications.  The code is provided "AS IS",         */
/*   without warranty of any kind.  IBM shall not be liable for any damages   */
/*   arising out of your use of the sample code, even if they have been       */
/*   advised of the possibility of such damages.                              */
/******************************************************************************/
// NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE

#include <iframe.hpp>           //Include IFrameWindow Class Header
#include <icmdhdr.hpp>          //Include ICommandEvent & ICommandHandler     v3

// following for sizing graphic button borders
#include "igpbrdr.hpp"

class ATextDialog;              //Define the ATextDialog Class                v4

//**************************************************************************
// Class:   AHelloWindow                                                   *
//                                                                         *
// Purpose: Main Window for C++ Hello World sample application             *
//          It is a subclass of IFrameWindow & ICommandHandler             *  v3
//                                                                         *
//**************************************************************************
class AHelloWindow : public IFrameWindow,
                     public ICommandHandler                                 //v3
{
  public:                               //Define the Public Information
    AHelloWindow(unsigned long windowId); //Constructor for this class

  protected:                            //Define Protected Member             v3
    Boolean command(ICommandEvent& cmdEvent);                               //v3
    virtual Boolean setupButtons();     //Setup Buttons                       v4

  private:                              //Define Private Information
    IStaticText   * hello;              //Hello contains "Hello, World" text
    IInfoArea     * infoArea;           //Define an Information Area          v2
                                        //  Control to create an information   .
                                        //  area beneath the client area      v2
    IStaticText   * statusLine;         //Status Line at top of client window v3
    IMenuBar      * menuBar;            //Define Menu Bar                     v3
    ATextDialog   * textDialog;         //Define Text Dialog                  v4
    IPushButton   * leftButton;           //Define Left Button                 .
    IPushButton   * centerButton;         //Define Center Button               .
    IPushButton   * rightButton;          //Define Right Button               v4
    IGPBorderSizer  gpBorderSizer;
};
#endif
