/******************************************************************************/
/* HELLO WORLD SAMPLE PROGRAM - Version 4: ATextDialog Class  (ADIALOG4.CPP)  */
/*                                                                            */
/* COPYRIGHT: Copyright (C) International Business Machines Corp., 1992,1993. */
/*                                                                            */
/* DISCLAIMER OF WARRANTIES:                                                  */
/*   The following [enclosed] code is sample code created by IBM              */
/*   Corporation.  This sample code is not part of any standard IBM product   */
/*   and is provided to you solely for the purpose of assisting you in the    */
/*   development of your applications.  The code is provided "AS IS",         */
/*   without warranty of any kind.  IBM shall not be liable for any damages   */
/*   arising out of your use of the sample code, even if they have been       */
/*   advised of the possibility of such damages.                              */
/******************************************************************************/

//**************************************************************************
// The entire file was created at version 4                                *
//**************************************************************************

#include <ientryfd.hpp>                 //IEntryField Class
#include <icmdevt.hpp>                  //ICommandEvent
#include <istring.hpp>                  //IString Class
#include <ireslib.hpp>                  //IResourceLibrary/IResourceId Class

#include "ahellow4.h"                   //Include our Symbolic definitions
#include "adialog4.hpp"                 //ATextDialog Class

//**************************************************************************
// ATextDialog :: ATextDialog - Constructor for text dialog window         *
//**************************************************************************
ATextDialog :: ATextDialog(IString & textString, IWindow * ownerWnd)
             : IFrameWindow(4321, 0, ownerWnd, 
                             IRectangle(IPoint(0,0), ISize(300,300)),
                             IFrameWindow::defaultStyle(),
                            "Dialog in Notebook"),
               notebook(1234, this, this),
               dlgFrame(IResourceId(WND_TEXTDIALOG), &notebook, &notebook),
               textValue(textString)
{
  this->setClient(&notebook);
  INotebook::PageSettings Settings("Tab", "Status", 
                                   INotebook::PageSettings::autoPageSize |
                                   INotebook::PageSettings::majorTab);
  notebook.addLastPage(Settings, &dlgFrame);
  ICommandHandler::handleEventsFor(this);//Set self as command event handler

  textValue=textString ;                //Save textValue for exit of dialog
  textField=new IEntryField(DID_ENTRY,  //Create entry field object using dialog
    &dlgFrame);                              //  entry field
  textField->setText(textString);       //Set top current "Hello, World" text
  textField->setFocus();                //Set focus to entry field

} /* end ATextDialog :: ATextDialog(...) */

//**************************************************************************
// ATextDialog :: ~ATextDialog - Destructor                                *
//**************************************************************************
ATextDialog :: ~ATextDialog()
{
} /* end ATextDialog :: ~TextDialog(...) */

//**************************************************************************
// ATextDialog :: command - Process Commands                               *
//**************************************************************************
Boolean ATextDialog :: command(ICommandEvent& cmdevt)
{
  switch(cmdevt.commandId()) {
    case DID_OK: // DID_OK              //Process OK Button
      textValue = textField->text() ;   //Get Text from Dialog Entry Field
      dismiss(DID_OK);             //Dismiss Dialog - Allow focus to main
      return(true);                     //Return Processing Completed
      break;

    case DID_CANCEL: // DID_CANCEL      //Process CANCEL Button
      dismiss(DID_CANCEL);         //Dismiss Dialog - Allow focus to main
      return(true);                     //Return Processing Completed
      break;
  }/* end switch */

  return(false);                       //Allow Default Processing to occur
} /* end ATextDialog :: command(...) */
