#include <isizehdr.hpp>
#include <igraphbt.hpp>
#include <iiconctl.hpp>

/***********************************************************************/
/* Here is the windowResize function for implementing a IGPBorderSizer */
/* that inherits from IResizeHander.  Attach this to your graphic      */
/* push buttons.                                                       */
/* To use this all you need to is include this file in any .cpp that   */
/* uses IGraphicPushButton, instatiate an IGPBorderSizer object, then  */
/* have it handleEventsFor() the IGraphicPushButtons that you wish to  */
/* change border size for.                                             */
/* The default border size used is 3, you can change this by passing   */
/* a value on the constructor                                          */
/* This handler only affect buttons that DO NOT have the sizeToGraphic */
/* style.                                                              */
/***********************************************************************/
class IGPBorderSizer : public IResizeHandler {

public:
  IGPBorderSizer(long size = 3) :
     IResizeHandler(),
     borderSize(size)
  {}

protected:
  Boolean IGPBorderSizer :: windowResize( IResizeEvent& evt )
  {
    IGraphicPushButton* button = (IGraphicPushButton*)evt.window();
    if (evt.oldSize() != evt.newSize() && !(button->isSizeToGraphic()))
    {
       long inith  = borderSize, 
            initw  = borderSize,
            width  = -initw,
            height = -inith;
       if ((width += evt.newSize().width() ) < 0)
          width = 0;
       if ((height+= evt.newSize().height()) < 0)
          height = 0;
       button->graphicWindow().moveSizeTo(IRectangle(initw,inith,width,height));
    }                               // End size change occurred
    return true;
  }

private:
  long borderSize;

};
