#ifndef ATEXTDIALOG_HPP
#define ATEXTDIALOG_HPP
/******************************************************************************/
/* HELLO WORLD SAMPLE PROGRAM - Version 4: ATextDialog Class  (ADIALOG4.HPP)  */
/*                                                                            */
/* COPYRIGHT: Copyright (C) International Business Machines Corp., 1992,1993. */
/*                                                                            */
/* DISCLAIMER OF WARRANTIES:                                                  */
/*   The following [enclosed] code is sample code created by IBM              */
/*   Corporation.  This sample code is not part of any standard IBM product   */
/*   and is provided to you solely for the purpose of assisting you in the    */
/*   development of your applications.  The code is provided "AS IS",         */
/*   without warranty of any kind.  IBM shall not be liable for any damages   */
/*   arising out of your use of the sample code, even if they have been       */
/*   advised of the possibility of such damages.                              */
/******************************************************************************/

//**************************************************************************
// The entire file was created at version 4                                *
//**************************************************************************

#include <iframe.hpp>                   //IFrameWindow Class (Parent)
#include <inotebk.hpp>
#include <icmdhdr.hpp>                  //ICommandHandler (Parent)

class IEntryField;

//**************************************************************************
// Class:   ATextDialog                                                    *
//                                                                         *
// Purpose: Dialog window for the C++ Hello World sample application.      *
//          It is a subclass of IFrameWindow, ICommandHandler              *
//                                                                         *
//**************************************************************************
class ATextDialog : public IFrameWindow, public ICommandHandler
{
public:
  ATextDialog (IString & textString, IWindow * ownerWnd) ;
  ~ATextDialog();

protected:
  virtual Boolean
    command(ICommandEvent& cmdevt);     //Process the dialog command events

private:
  IEntryField * textField ;             //Entry Field to Edit Hello Text
  IString & textValue ;                 //String Value for in/out of dialog
  INotebook notebook;
  IFrameWindow dlgFrame;

}; // TextDialog

#endif
