/******************************************************************************/
/* HELLO WORLD SAMPLE PROGRAM - Version 4: Class Implementation (AHELLOW4.CPP)*/
/*                                                                            */
/* COPYRIGHT: Copyright (C) International Business Machines Corp., 1992,1993. */
/*                                                                            */
/* DISCLAIMER OF WARRANTIES:                                                  */
/*   The following [enclosed] code is sample code created by IBM              */
/*   Corporation.  This sample code is not part of any standard IBM product   */
/*   and is provided to you solely for the purpose of assisting you in the    */
/*   development of your applications.  The code is provided "AS IS",         */
/*   without warranty of any kind.  IBM shall not be liable for any damages   */
/*   arising out of your use of the sample code, even if they have been       */
/*   advised of the possibility of such damages.                              */
/******************************************************************************/
// NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE
//**************************************************************************
// C++ Hello World History and Key Functions:                              *
//   Version 1:                                                            *
//      - Creates and runs a simple application                            *
//      - Creates the main window (IFrameWindow)                           *
//      - Creates a static text control set to "Hello, World!" as the      *
//         client window                                                   *
//                                                                         *
//   Version 2: (lines with v2 in column 79-80)                            *  v2
//      - Create Main Window (AHellowWindow) as subclass of IFrameWindow   *   .
//      - Gets the "Hello, World!!" text string and other items from a     *   .
//         resource file                                                   *   .
//      - Sets the window title from a resource file                       *   .
//      - Creates and sets the information area at the bottom of the       *   .
//         client area                                                     *  v2
//                                                                         *
//   Version 3: (lines with v3 in column 79-80)                            *  v3
//      - Add Alignment (Left, Center, Right) Menu Bar                     *   .
//      - Add Command Processing to set the "Hello, World" alignment       *   .
//      - Place check in front of the Left, Center or Right Menu Item      *   .
//      - Create and maintain Status Line with current alignment status    *  v3
//                                                                         *
//   Version 4: (lines with v4 in column 79-80)                            *  v4
//      - Add Accelerator Keys for Left (F7), Center(F8), Right(F9)        *   .
//      - Modify Left, Center and Right Menu Items to show function key    *   .
//      - Modify Menu Bar to create Edit Menu and "text..." Menu Item      *   .
//      - Add ADialogText to allow user to change "Hello, World" text      *   .
//      - Add Push Buttons & Set Canvas to change alignment                *  v4
//**************************************************************************
                                        //Include IBM UI class headers:
#include <iapp.hpp>                     //IApplication Class
#include <istattxt.hpp>                 //IStaticText Class
#include <iinfoa.hpp>                   //IInfoArea Class                     v2
#include <imenubar.hpp>                 //IMenuBar Class                      v3
#include <ifont.hpp>                    //IFont                               v3
#include <istring.hpp>                  //IString Class                       v4
#include <isetcv.hpp>                   //ISetCanvas Class                    v4
#include <ipushbut.hpp>                 //IPushButton Class                   v4
#include <igraphbt.hpp>

#include "ahellow4.hpp"                 //Include AHelloWindow Class headers  v2
#include "ahellow4.h"                   //Include our Symbolic definitions    v2
#include "adialog4.hpp"                 //ATextDialog Class                   v4

//*************************************************************************
// main  - Application entry point                                        *
//*************************************************************************
void main()                             //Main Procedure with no parameters
{
  AHelloWindow mainWindow (WND_MAIN);   //Create our main window on the
                                        // desktop
  IApplication::current().run();        //Get the current application and
                                        // run it
} /* end main */

//**************************************************************************
// AHelloWindow :: AHelloWindow - Constructor for our main window          *
//**************************************************************************
AHelloWindow :: AHelloWindow(unsigned long windowId)
  : IFrameWindow (                      //Call IFrameWindow constructor       v2
    IFrameWindow::defaultStyle()        //  Use default plus                  v2
    | IFrameWindow::minimizedIcon       //  Get Minimized Icon from  RC file  v2
    | IFrameWindow::accelerator,        //  Get Accelerator Table from RC filev4
    windowId),                          //  Main Window ID
    gpBorderSizer()                     //  size the graphic button borders
{
  hello = new IStaticText(WND_HELLO,    //Create Static Text Control
    this, this);                        //  Pass in myself as owner & parent
  hello->setText(STR_HELLO);            //Set text in Static Text Control     v2
  hello->setAlignment(                  //Set Alignment to Center in both
    IStaticText::centerCenter);         //    directions
  setClient(hello);                     //Set hello control as Client Window

  infoArea=new IInfoArea(this);         //Create the information area         v2
  infoArea->setInactiveText(STR_INFO);  //Set information area text from RC   v2

  statusLine=new IStaticText            //Create Status Area using Static Textv3
    (WND_STATUS, this, this);           //  Window ID, Parent, Owner Parameters.
  statusLine->setText(STR_CENTER);      //Set Status Text to "Center" from Res .
  addExtension(statusLine,              //Add Status Line above the client     .
    IFrameWindow::aboveClient,          //  and specify the height             .
    IFont(statusLine).maxCharHeight()); //  and specify height                v3

  handleEventsFor(this);                //Set self as event handler (commands)v3
  menuBar=new IMenuBar(WND_MAIN, this); //Create Menu Bar for main window      .
  menuBar->checkItem(MI_CENTER);        //Place Check on Center Menu Item     v3

  setupButtons();                       //Setup Buttons                       v4

  sizeTo(ISize(400,300));               //Set the size of main window         v2
  setFocus();                           //Set focus to main window
  show();                               //Set to show main window

} /* end AHelloWindow :: AHelloWindow(...) */

//**************************************************************************  v4
// AHelloWindow :: setupButtons                                            *   .
//   Setup IGraphicPushButtons                                             *   .
//**************************************************************************   .
Boolean AHelloWindow :: setupButtons()  //Setup Buttons                        .
{                                       //                                     .
  ISetCanvas    * buttons;              //Define canvas of buttons             .
                                        //                                     .
  buttons=new ISetCanvas(WND_BUTTONS,   //Create a Set Canvas for Buttons      .
    this, this) ;                       //  Parent and Owner=me                .
  buttons->setMargin(ISize());          //Set Canvas Margins to zero           .
  buttons->setPad(ISize());             //Set Button Canvas Pad to zero        .

  leftButton=new IGraphicPushButton(MI_LEFT, buttons, buttons, WND_MAIN);

  centerButton=new IGraphicPushButton(MI_CENTER, buttons, buttons, WND_MAIN);

  rightButton=new IGraphicPushButton(MI_RIGHT, buttons, buttons, WND_MAIN);

  // Add a handler that set the border size of the graphic buttons
  gpBorderSizer.handleEventsFor(leftButton);
  gpBorderSizer.handleEventsFor(centerButton);
  gpBorderSizer.handleEventsFor(rightButton);

  addExtension(buttons,                 //Add Buttons Canvas                   .
    IFrameWindow::belowClient,          //  below client                        .
    (unsigned long)buttons->minimumSize().height());           
  return true;                          //Return                               .
} /* end AHelloWindow :: setupButtons() */                                  //v4

//**************************************************************************  v3
// AHelloWindow :: command                                                 *   .
//   Handle menu commands                                                  *   .
//**************************************************************************   .
Boolean AHelloWindow :: command(ICommandEvent & cmdEvent)                   // .
{                                                                           //v3
  IString temp;                         //String to pass in/out from dialog   v4
  unsigned short value;                 //Return value from dialog            v4
  switch (cmdEvent.commandId()) {       //Get command id                      v3

    case MI_CENTER:                     //Code to Process Center Command Item v3
      hello->setAlignment(              //Set alignment of hello text to       .
        IStaticText::centerCenter);     //  center-vertical, center-horizontal .
      statusLine->setText(STR_CENTER);  //Set Status Text to "Center" from Res .
      menuBar->checkItem(MI_CENTER);    //Place Check on Center Menu Item      .
      menuBar->uncheckItem(MI_LEFT);    //Uncheck Left Menu Item               .
      menuBar->uncheckItem(MI_RIGHT);   //Uncheck Right Menu Item              .
      return(true);                     //Return command processed             .
      break;                            //                                    v3

    case MI_LEFT:                       //Code to Process Left Command Item   v3
      hello->setAlignment(              //Set alignment of hello text to       .
        IStaticText::centerLeft);       //  center-vertical, left-horizontal   .
      statusLine->setText(STR_LEFT);    //Set Status Text to "Left" from Res   .
      menuBar->uncheckItem(MI_CENTER);  //Uncheck Center Menu Item             .
      menuBar->checkItem(MI_LEFT);      //Place Check on Left Menu Item        .
      menuBar->uncheckItem(MI_RIGHT);   //Uncheck Right Menu Item              .
      return(true);                     //Return command processed             .
      break;                            //                                    v3

    case MI_RIGHT:                      //Code to Process Right Command Item  v3
      hello->setAlignment(              //Set alignment of hello text to       .
        IStaticText::centerRight);      //  center-vertical, right-horizontal  .
      statusLine->setText(STR_RIGHT);   //Set Status Text to "Right" from Res  .
      menuBar->uncheckItem(MI_CENTER);  //Uncheck Center Menu Item             .
      menuBar->uncheckItem(MI_LEFT);    //Uncheck Left Menu Item               .
      menuBar->checkItem(MI_RIGHT);     //Place Check on Right Menu Item       .
      return(true);                     //Return command processed             .
      break;                            //                                    v3

    case MI_TEXT:                       //Code to Process Text Command        v4
      {
      temp=hello->text();               //Get current Hello text               .
      infoArea->setInactiveText(        //Set Info Area to Dialog Active       .
        STR_INFODLG);                   //  Text from Resource File            .
      ATextDialog * textDialog=new      //Create a Text Dialog                 .
        ATextDialog(temp, this);        //                                     .
      textDialog->showModally();        //Show this Text Dialog as Modal       .
      value=textDialog->result();       //Get result (eg OK or Cancel)         .
      if (value != DID_CANCEL)          //Set new string if not canceled       .
        hello->setText(temp);           //Set Hello to Text from Dialog        .
      infoArea->setInactiveText(STR_INFO);//Set information area text from RC  .
      delete textDialog;                //Delete textDialog                    .
      return(true);                     //Return Command Processed             .
      break;                            //                                    v4
      }

  } /* end switch */                    //                                    v3

  return(false);                        //Return command not processed        v3
} /* end HelloWindow :: command(...) */                                     //v3
