
#ifndef __SUBVBCTL_H__
#define __SUBVBCTL_H__

// subvbctl.h : interface of the CVBClone class and CMyCircleMyCircleclass
//
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// CVBClone
//                

//*************************************************************
//  Class:
//      CVBClone
//
//  Description:       
//      This class is used to create a derived class of CVBControl that can take
//      over control of a VBX that has been loaded into a dialog--or in any other
//      way created as a CVBControl
//
//  Derived from:
//      CVBControl
//
//
//
//  Member Functions:
//
//      SubclassVBControl - Subclasses an existing VB control
//
//  Comments
//
//  History:    Date       Author           Comment
//              05/13/93   Brian Scott      Created
//                         with help from John Seghers
//
//*************************************************************  

class CVBClone : public CVBControl
{
protected:
	CVBClone() {}		// protect the constructor to only allow derived
						// classes to be created
	
public:
	void SubclassVBControl(CWnd* pWnd, UINT idChild, BOOL bEmbedded);
};


/////////////////////////////////////////////////////////////////////////////
// CMyGrid
//       
// This class subclasses the grid control and requests that the arrow keys
// get passed to the control.
//
   
class CMyGrid : public CVBClone
{    
      // Construction
public:
	CMyGrid();

// Attributes
public:
	BOOL m_ShiftDown;
// Operations
public:

// Implementation
public:
	virtual ~CMyGrid();
	virtual BOOL ScrollingDown(long);
	virtual BOOL ScrollingRight(long);
	void ResetSelectedRegion(void);
	
   // Generated message map functions
protected:
	//{{AFX_MSG(CMyGrid)
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};   

#endif

 
 