/////////////////////////////////////////////////////////////////////////////
// subvbctl.cpp : implementation of the CVBClone class and CMyGrid class
//                                                                                              
 
#include "stdafx.h"
#include "subvbctl.h"  

/////////////////////////////////////////////////////////////////////////////
// CVBClone
typedef CVBControl* __based((__segment)_self)* FAR* CVBHandle;  

//***********************************************************
//
//  CVBClone :: SubclassVBControl()
//
//  Purpose:  Copies data from an existing CVBControl class
//            into this class.  It also detaches the old
//            class and attaches this one.
//                                                         
//  Parameters:  CWnd* pParent     parent window of the control
//               UINT  idChild     child window ID of control
//               BOOL  bEmbedded   Inicates if contol is embedded
//                                 in an object that will be 
//                                 cleaned up or if this object
//                                 should be deleted when the 
//                                 control is deleted 
//
//  Return: None
//
//  Comments:
//
//  History:    Date       Author              Comment
//              5/13/93    Brian Scott         Created
//                         with help from John Seghers
//
//*************************************************************

void CVBClone::SubclassVBControl(CWnd* pParent, UINT idChild, BOOL bEmbedded)
{
	ASSERT(pParent != NULL);
	ASSERT(idChild != 0 && idChild != -1);
	
	//
	// Get the existing CVBControl.  Cast it to this class type
	// so that we will have access to the protected data
	//
	CVBClone* pControl = (CVBClone*)pParent->GetDlgItem(idChild);
	ASSERT(pControl->IsKindOf(RUNTIME_CLASS(CVBControl)));
	
	// Copy over all of the appropriate data
	m_pModel = pControl->m_pModel;

	m_bRecreating = pControl->m_bRecreating;
	m_bInPostNcDestroy = pControl->m_bInPostNcDestroy;
	m_bLoading = pControl->m_bLoading;
	m_nCursorID = pControl->m_nCursorID;
	
	m_nInitialStack = pControl->m_nInitialStack;
	m_nRecursionLevel = pControl->m_nRecursionLevel;
	m_bStackFault = pControl->m_bStackFault;
	m_nFaultRecurse = pControl->m_nFaultRecurse;

	m_hbrBkgnd = pControl->m_hbrBkgnd;
	m_hFontCreated = pControl->m_hFontCreated;
	m_hcurMouse = pControl->m_hcurMouse;
	m_hCtl = pControl->m_hCtl;
	m_clrBkgnd = pControl->m_clrBkgnd;
	m_clrFore = pControl->m_clrFore;
	m_rectCreate = pControl->m_rectCreate;
	m_strTag = pControl->m_strTag;

	m_bAutoDelete = !bEmbedded;

	// Clear data in the old CVBControl that would cause problems   
	pControl->m_hFontCreated = NULL;
	pControl->m_hbrBkgnd = NULL;
	pControl->m_hcurMouse = NULL;
	pControl->m_pModel = NULL;
	pControl->m_hCtl   = NULL;
	CVBHandle hpControl = (CVBHandle) m_hCtl;
	**hpControl = this;
	
	pControl->m_hFontCreated=NULL;
	pControl->m_hbrBkgnd=NULL;
	pControl->m_hcurMouse=NULL;

	// Transfer hWnd
	Attach(pControl->Detach());
	
	// Delete old object if necessary
	if (pControl->m_bAutoDelete)
		delete pControl;        
}



/////////////////////////////////////////////////////////////////////////////
// CMyGrid

BEGIN_MESSAGE_MAP(CMyGrid, CVBClone)
	//{{AFX_MSG_MAP(CMyGrid)
	ON_WM_GETDLGCODE()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()  

/////////////////////////////////////////////////////////////////////////////
// CMyCircle construction/destruction      

CMyGrid::CMyGrid() 
{
	m_ShiftDown = FALSE;
} 

CMyGrid::~CMyGrid() 
{
	// TODO: add destruction code here
}


UINT CMyGrid::OnGetDlgCode()
{       
	return (CVBClone::OnGetDlgCode() | DLGC_WANTARROWS);
}

void CMyGrid::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	long nRows = GetNumProperty("Rows");
	switch (nSBCode)
	{
		case SB_LINEDOWN:
			if (GetNumProperty("TopRow") < nRows)
				SetNumProperty("TopRow",GetNumProperty("TopRow") + 1);
			break;
		case SB_LINEUP:
			if (GetNumProperty("TopRow") > 0)
				SetNumProperty("TopRow",GetNumProperty("TopRow") - 1);
			break;
		default:
			CVBClone::OnVScroll(nSBCode, nPos, pScrollBar);
	}
}

void CMyGrid::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	long nCols = GetNumProperty("Cols");
	switch (nSBCode)
	{
		case SB_LINEUP:
			if (GetNumProperty("LeftCol") > 0)
				SetNumProperty("LeftCol",GetNumProperty("LeftCol") - 1);
			break;
		case SB_LINEDOWN:
			if (GetNumProperty("LeftCol") < nCols)
				SetNumProperty("LeftCol",GetNumProperty("LeftCol") + 1);
			break;
		default:
			CVBClone::OnHScroll(nSBCode, nPos, pScrollBar);
			break;
	}
}


void CMyGrid::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	long offset;

	switch (nChar)
	{   
		case VK_SHIFT:
			m_ShiftDown = TRUE;
			break;
		case VK_UP:
			if (GetNumProperty("Row") == GetNumProperty("TopRow"))
				if (!m_ShiftDown)  
				{
					if (GetNumProperty("Row") == GetNumProperty("TopRow"))
						SendMessage(WM_VSCROLL, SB_LINEUP);
				SetNumProperty("Row",GetNumProperty("Row") - 1);
					ResetSelectedRegion();
					return;                 
				}
			break;
		case VK_LEFT:
			if (GetNumProperty("Col") == GetNumProperty("LeftCol")) 
				if (!m_ShiftDown)
				{
					if (GetNumProperty("Col") == GetNumProperty("LeftCol"))
						SendMessage(WM_HSCROLL, SB_LINEUP);
					SetNumProperty("Col",GetNumProperty("Col") - 1);
					ResetSelectedRegion();
					return;
				}
			break;
		case VK_DOWN:
			if (ScrollingDown(GetNumProperty("Row")))
				if (!m_ShiftDown)
				{
					if (ScrollingDown(GetNumProperty("Row")))
						SendMessage(WM_VSCROLL, SB_LINEDOWN);
					SetNumProperty("Row",GetNumProperty("Row") + 1);
					ResetSelectedRegion();
					return;
				}       
			break;
		case VK_RIGHT:
			if (ScrollingRight(GetNumProperty("Col")))
				if (!m_ShiftDown)
				{
					if (ScrollingRight(GetNumProperty("Col")))
						SendMessage(WM_HSCROLL, SB_LINEDOWN);
					SetNumProperty("Col",GetNumProperty("Col") + 1);
					ResetSelectedRegion();
					return;
				}
			break;
		case VK_PRIOR:
			if (!m_ShiftDown)
			{
				offset = GetNumProperty("Row") - GetNumProperty("TopRow");                              
				SendMessage(WM_VSCROLL, SB_PAGEUP);
				SetNumProperty("Row",GetNumProperty("TopRow") + offset);
				ResetSelectedRegion();
				return;
			}
			break;
		case VK_NEXT:           
			if (!m_ShiftDown)
			{
				offset = GetNumProperty("Row") - GetNumProperty("TopRow");                              
				SendMessage(WM_VSCROLL, SB_PAGEDOWN);
				SetNumProperty("Row",GetNumProperty("TopRow") + offset);
				ResetSelectedRegion();
				return;
			}
			break;
	
	}          
	CVBClone::OnKeyDown(nChar, nRepCnt, nFlags);
}


void CMyGrid::ResetSelectedRegion(void)
{
	SetNumProperty("SelEndRow",GetNumProperty("Row"));
	SetNumProperty("SelStartRow",GetNumProperty("Row"));
	SetNumProperty("SelEndCol",GetNumProperty("Col"));
	SetNumProperty("SelStartCol",GetNumProperty("Col"));
}


BOOL CMyGrid::ScrollingDown(long row)
{ 

	long nHeight = GetNumProperty("Height");  //height of control in pixels
	
	// How many pixels per logical inch in vertical dimension?
	CDC *pDC = GetDC();
	int PixelHeight = pDC->GetDeviceCaps(LOGPIXELSY);
	ReleaseDC(pDC);
	
	long nFixed = 0;
    for (int i=0 ; i<GetNumProperty("FixedRows");i++)
	nFixed += GetNumProperty("RowHeight",i);

    long nExposed = 0;
    for (long j=GetNumProperty("TopRow") ; j<=row+1 ; j++)
	nExposed += GetNumProperty("RowHeight",(int)j);
    
	long Total = (long)((nFixed + nExposed) / 1440.0 * PixelHeight);

	long nScrollbars = GetNumProperty("ScrollBars") ;       
	if (nScrollbars == 2 || nScrollbars == 3)  // it *could* have scrollbars
	{
		long nRowHeights = 0;
		for (int i = 0 ; i<GetNumProperty("Rows"); i++)
			nRowHeights += GetNumProperty("RowHeight",i);
		if (nRowHeights > nHeight)                              
			Total += ::GetSystemMetrics(SM_CYHSCROLL);
	}
    
    // Now that we have the height of the rows, we have to add 1 pixel per displayed row
    // for the grid lines, and also 2 pixels for the outer border of the control.

	Total += GetNumProperty("FixedRows") + j;
	Total += 2;
			
    if (Total >= nHeight)
	return TRUE;
	
	return FALSE;
}

BOOL CMyGrid::ScrollingRight(long col)
{             
	long nWidth = GetNumProperty("Width");  //height of control in pixels

	// How many pixels per logical inch in horizontal dimension?
	CDC *pDC = GetDC();
	int PixelWidth = pDC->GetDeviceCaps(LOGPIXELSX);
	ReleaseDC(pDC);
	
	long nFixed = 0;
    for (int i=0 ; i<GetNumProperty("FixedCols");i++)
	nFixed += GetNumProperty("ColWidth",i);

    long nExposed = 0;
    for (long j=GetNumProperty("LeftCol") ; j<=col+1 ; j++)
	nExposed += GetNumProperty("ColWidth",(int)j);
    
	long Total = (long)((nFixed + nExposed) / 1440.0 * PixelWidth);

	long nScrollbars = GetNumProperty("ScrollBars") ;       
	if (nScrollbars == 1 || nScrollbars == 3)  // it *could* have scrollbars
	{
		long nColWidths = 0;
		for (int i = 0 ; i<GetNumProperty("Cols"); i++)
			nColWidths += GetNumProperty("ColWidth",i);
		if (nColWidths > nWidth)                                
			Total += ::GetSystemMetrics(SM_CXVSCROLL);
	}
    
    // Now that we have the width of the columns, we have to add 1 pixel per displayed column
    // for the grid lines, and also 2 pixels for the outer border of the control.

	Total += GetNumProperty("FixedCols") + j;
	Total += 2;
			
    if (Total >= nWidth)
	return TRUE;
	
	return FALSE;
}

void CMyGrid::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	switch (nChar)
	{
		case VK_SHIFT:
			m_ShiftDown = FALSE;
			break;
		default:
			break;
	}
	
	CVBClone::OnKeyUp(nChar, nRepCnt, nFlags);
}

