// VIEW.CPP 								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"
#include <time.h>

#define PROGRAM "VIEW"  // Name of module

/*********************************************************************/

typedef struct
{
	int  disp_dirs;
	char list_order[50];
	char file_length;
} VIEW_INFO;

/**/
static void print_version(AU *au, int version, int len, BYTE left)
{
	BYTE color;

	if (archive_is_old(version))
		color = 11; 				  /* old versions in cyan */
	else
	{
		switch (version)
		{
			case 0: case 47: case 48: case 65: case 66: case 60:
				color = 14; break;	  /* Unknown in yellow */
			default:
				color = 10; break;	  /* new in green */
		}
	}
	if (left)
		au_printf_c(au, color, "%-*.*s", len, len, versions[version]);
	else
		au_printf_c(au, color, "%*.*s", len, len, versions[version]);
}
/**/
static void print_method(AU *au, int method)
{
	BYTE color;

	if (file_is_not_optimal(method))
		color = 11; 		/* Unoptimal versions in cyan */
	else if (file_is_stored(method))
		color = 15; 		/* Stored in white */
	else
	{
		switch (method)
		{
			case 0:
				color = 14; break;	  /* Unknown in yellow */
			default:
				color = 10; break;	  /* Optimal in green */
		}
	}
	au_printf_c(au, color, "%-8s ",methods[method]);
}
/**/
static void view_one(AU *au, char *file_name, ARC_FILE *arcFile)
{
	ARC_RECORD record;
	int ret_code;
	long packed_sum = 0, unpacked_sum = 0, no_files = 0;
	long actual_size;
	int i, len;
	BYTE crc;
	VIEW_INFO *in = (VIEW_INFO *)au->info;

	crc = au->package[arcFile->type].crc;

	au->number_processed++;

	len = strlen(in->list_order);
	if (!au->no_extra)
	{
		au_printf(au, "@?6View@?H of Archive: @?1%s@?H", file_name);
		if (arcFile->is_self)
			au_printf(au, " (Self Extracting)");
		au_printf(au, "\n\n");
		for (i=0; i < len; i++)
		{
			switch (in->list_order[i])
			{
			case 'N':
				au_printf(au, "%-*s", in->file_length+1, "Name");   break;
			case 'O':
				au_printf(au, "Original "); break;
			case 'P':
				au_printf(au, "  Packed "); break;
			case 'S':
				au_printf(au, "Sp "); break;
			case '%':
				au_printf(au, "% Save  "); break;
			case 'D':
				au_printf(au, "Date     "); break;
			case 'T':
				au_printf(au, "Time     "); break;
			case 'C':
				if (crc != 0)
					au_printf(au, "CRC");
				if (crc == 32)
					au_printf(au, "%*c", 6, ' ');
				else if (crc == 16)
					au_printf(au, "%*c", 2, ' ');
				break;
			case 'M':
				au_printf(au, "Method   ");  break;
			case '_':
				au_printf(au, " "); break;
			}
		}
		au_printf(au, "\n");
		au_printf(au, "-------------------------------------------------------------------------------\n");
	}

	for (;;)
	{
		ret_code = get_record(au, arcFile, &record);
		if (ret_code == EOF)
			break;
		else if (ret_code == -2)
		{
			add_to_bad_list(au, au->source_directory, file_name);
			return;
		}
		else if (ret_code == -3)
			return;

		for (i=0; i < len; i++)
		{
			switch (in->list_order[i])
			{
			case 'N':
				if (in->disp_dirs == ON)
				{
					char temp[FLENGTH];
					build_fname(temp, record.path, record.name);
					au_printf(au, "%-*s", in->file_length+1, temp);
					if (strlen(temp) >= in->file_length)
						au_printf(au, "\n%*s", in->file_length+1, "");
				}
				else
				{
				   au_printf(au, "%-*s", in->file_length+1, record.name);
				   if (strlen(record.name) >= in->file_length)
						au_printf(au, "\n%*s", in->file_length+1, "");
				}
				break;
			case 'O':
				au_printf(au, "%8ld ", record.unpacked_size); break;
			case 'P':
				au_printf(au, "%8ld ", record.packed_size); break;
			case 'S':
				if (record.encrypted)
					au_printf(au, "@?5P@?H  ");
				else
					au_printf(au, "   ");
				break;
			case '%':
				au_printf(au, "%s  ",percent_string(record.unpacked_size, record.packed_size));
				break;
			case 'D':
				au_printf(au, "%s ",date_to_string(&record.date));
				break;
			case 'T':
				au_printf(au, "%s ", hms_to_string(record.hour, record.min, record.sec));
				break;
			case 'C':
				if (crc == 32)
					au_printf(au, "%8lx ",record.crc);
				else if (crc == 16)
					au_printf(au, "%4lx ",record.crc);
				break;
			case 'M':
				print_method(au, record.method); break;
			case '_':
				au_printf(au, " "); break;
			}
		}
		au_printf(au, "\n");

		no_files++;
		packed_sum += record.packed_size;
		unpacked_sum += record.unpacked_size;
	}
	if (!au->no_extra)
	{
		struct ftime ftime;
		getftime(arcFile->file, &ftime);
		au_printf(au, "-------------------------------------------------------------------------------\n");
		for (i=0; i < len; i++)
		{
			switch (in->list_order[i])
			{
			case 'N':
				au_printf(au, "%4d ", no_files);
				au_printf(au, "%s%*s", no_files == 1 ? "File " : "Files", in->file_length-9, "");
				break;
			case 'O':
				au_printf(au, "%8ld ", unpacked_sum);
				break;
			case 'P':
				au_printf(au, "%8ld ", packed_sum);
				break;
			case '%':
				au_printf(au, "%s  ", percent_string(unpacked_sum, packed_sum));
				break;
			case 'D':
			{
				DATE date;
				date.year  = ftime.ft_year+80;
				date.month = ftime.ft_month;
				date.day   = ftime.ft_day;
				printf("%s ", date_to_string(&date));
				break;
			}
			case 'S':
				if (in->list_order[i+1] != '\0')
					au_printf(au, "   "); break;
			case 'T':
				au_printf(au, "%s ", hms_to_string(ftime.ft_hour, ftime.ft_min, ftime.ft_tsec*2));
				break;
			case 'M':
				if (i > 0 && in->list_order[i-1] == 'C' || in->list_order[i+1] == '\0')
					print_version(au, arcFile->version, 19, crc == 0);
				else
					print_version(au, arcFile->version, 9, TRUE);
				break;
			case '_':
				au_printf(au, " "); break;
			}
		}
		au_printf(au, "\n");
		/* Not sure what else to do at this point */
		if (strncmp(in->list_order, "NOP%", 4) == 0 && in->file_length == FILE_SIZE)
		{
			actual_size = lseek(arcFile->file, 0, SEEK_END);
			au_printf(au, "%22s %8ld ", "Overhead +", actual_size - packed_sum);
			au_printf(au, "%s%% Overhead",percent_string(actual_size, packed_sum));
			au_printf(au, "\n");
			au_printf(au, "%22s %8ld ", "File Size =", actual_size);
			au_printf(au, "%s%% True Savings", percent_string(unpacked_sum, actual_size));
			au_printf(au, "\n\n");
		}
	}
	return;
}
/**/
static int view(AU *au, char *file_name)
{
	ARC_FILE arcFile;

	check_for_key();

	arc_file_init(au, &arcFile, file_name);

	if (arcFile.type > 0)
		view_one(au, file_name, &arcFile);
	arc_file_deinit(au, &arcFile);

	return 0;
}
/**/
static void ReadCFGInfo(AU *au, HANDLE file, char *cfg_file, int *cfg_line)
{
	char string[200],
		 string2[200],
		 string3[200];
	VIEW_INFO *in = (VIEW_INFO *)au->info;

	for(EVER)
	{
		if (get_file_line(au, file, string)==EOF)
			break;

		split_string(string, string2);
		split_string(string, string3);

		if (string2[0] == '\0')
			continue;

		strcpy(au->curOpt,string2);
		au->curVal = string3;
		switch (toupper(string2[1]) << 8 | toupper(string2[0]))
		{
			case 'BE':                                          // Begin
				return;
			case 'SE':                                          // Self_Extracts
				au->self_extracts = get_value(au, OFF | ON);
				break;
			case 'PA':                                          // Paths
				au->unarc_paths = get_value(au, OFF | ON);
				break;
			case 'NA':                                          // Name_Length
				in->file_length = atoi(string3);
				if (in->file_length < FILE_SIZE)
					in->file_length = FILE_SIZE;
				break;
			case 'LI':                                          // List_Order
				strcpy(in->list_order, string3);
				break;
			default:
				au_invalid_cfg_option(au, string2, cfg_file, *cfg_line);
		}
	}
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	VIEW_INFO *in = (VIEW_INFO *)au->info;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case 'X':
			au->self_extracts = get_value(au, OFF | ON);
			break;
		case 'P':
			if (toupper(*cur_argv) == 'A')
			{
				strcpy(au->curOpt, "-PA");
				au->curVal = cur_argv+1;
				in->disp_dirs = get_value(au, OFF | ON);
			}
			break;
		case 'N':
			in->file_length = atoi(cur_argv);
			if (in->file_length < FILE_SIZE)
				in->file_length = FILE_SIZE;
			break;
		case 'L':
			strcpy(in->list_order, cur_argv);
			strupr(in->list_order);
			break;
		case '?':
			au_standard_opt_header(au, "View",
			   "@?3-X@?Hon|off         self e@?3X@?Htracts\n"
			   "@?3-PA@?Hon|off        display archived file @?3PA@?Hths\n"
			   "@?3-N@?Hn              file@?3N@?Hame length (default and minimum 13)\n"
			   "@?3-L@?Dx@?H              @?3L@?Hist order, where @?Dx@?H = string of:\n"
			   "  @?DC@?H - @?DC@?HRC\n"
			   "  @?DD@?H - @?DD@?Hate\n"
			   "  @?DM@?H - @?DM@?Hethod\n"
			   "  @?DN@?H - file @?DN@?Hame\n"
			   "  @?DO@?H - @?DO@?Hriginal size\n"
			   "  @?DP@?H - @?DP@?Hacked size\n"
			   "  @?DS@?H - @?DS@?Hpecial attributes\n"
			   "  @?DT@?H - @?DT@?Hime\n"
			   "  @?D%@?H - @?DP@?Hercent savings\n"
			   "  @?D_@?H - Extra space\n");
			exit (0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int main_view(AU *au, int argc, char *argv[])
{
	char string[120];
	HANDLE file;
	int i;
	VIEW_INFO *in;

	in = (VIEW_INFO *)au_malloc(au, sizeof(VIEW_INFO));
	memset(in, '\0', sizeof(VIEW_INFO));
	au->info = in;
	in->disp_dirs = ON;
	in->file_length = FILE_SIZE;
	strcpy(in->list_order, "NOP%DTCMS");

	au->allow_rename = FALSE;	  // no sense since unarcers not called

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, ReadCFGInfo);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);
	process_files(au, view);

	if (!au->no_extra)
		au_printf_c(au, 15, "\nFiles Processed = %d", au->number_processed);

	return 0;
}

