#include "..\au.hpp"
#include <errno.h>

/**************************************************************************/
/* open the configuration file, look through path if necessary */

HANDLE opencfg(AU *au, char *filename)
{
	HANDLE file;
	int pathpos=0,dirpos;
	char *path,aupath[200],directory[80];
	char temp[FILE_SIZE];

	file = au_open(au, filename, O_TEXT);
	if (file != -1)
		return file;

	if (strstr(filename,"\\"))
		goto file_not_found;

/* Lets try ripping it from argv[0] */

	split_file(au->argv0, directory, temp);
	build_fname(directory, directory, filename);
	file = au_open(au, directory, O_TEXT);
	if (file != -1)
		return file;

/* lets try for AUPATH envirnonment variable */

	if (getenv("AUPATH")!=NULL)
	{
		strcpy(aupath, getenv("AUPATH"));
		append_backslash(aupath);
		strcat(aupath, filename);
		file = au_open(au, aupath);
		if (file != -1)
			return file;
	 }

/* Lets try the path */

	path = getenv("PATH");
	if (path == NULL)
		goto file_not_found;

	while (TRUE)
	{
		if (path[pathpos]=='\0')  /* we have looked through the whole PATH without success */
		{
file_not_found:
			au_printf_error(au, "Can't find %s", filename);
			exit(1);
		}
		dirpos=0;
		while (path[pathpos]!=';' && path[pathpos]!='\0')
			directory[dirpos++] = path[pathpos++];

		if (path[pathpos] == ';')
			pathpos++;	   /* get us over the ; */

		directory[dirpos] = '\0';
		append_backslash(directory);
		strcat(directory, filename);
		file = au_open(au, directory);
		if (file != -1)
			break;
	}

	return file;
}

