#include "..\au.hpp"
/*************************************************************************/
void get_ns(AU *au, ARC_FILE *arcFile, LISTPTR *arc_paths,
			LISTPTR *arc_files, LISTPTR *paths, LISTPTR *too_long,
			LISTPTR *dangerous)
{
	ARC_RECORD record;
	int  ret_code;
	LIST *el;

	for (;;)
	{
		ret_code = get_record(au, arcFile, &record);
		if (ret_code == EOF)
			break;
#if 0
		else if (ret_code == -2)
			return -2;
		else if (ret_code == -3)
			return 0;
#endif
		if (record.path[0] != '\0')
		{
			for (el = paths->head; el != NULL; el=el->next)
			{
				if (stricmp(record.path, el->data)==0)
					break;
			}
			if (el == NULL)
				add_to_list(au, paths, ltrim(record.path));

			for (el = dangerous->head; el != NULL; el=el->next)
			{
				if (stricmp(record.path, el->data)==0)
					break;
			}
			if (el == NULL)
			{
				/* Path is not relative */
				if (strstr(record.path, "..") != NULL || record.path[0] == '\\')
					add_to_list(au, dangerous, ltrim(record.path));
			}
		}
		if (!is_dos_name(record.name))
			add_to_list(au, too_long, record.name);

		add_to_list(au, arc_paths, ltrim(record.path));
		add_to_list(au, arc_files, record.name);
	}
	return;
}
