// BBSWEEP.CPP								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"

#define PROGRAM "BBSWEEP"   // Name of module
/************************************************************************/
/* need to malloc some of this */

typedef struct
{
	char command[127];
	char greater_than;
	char less_than;
	char pipe;
	BYTE into_command;
} SWEEP_INFO;

/**/
static int sweep(AU *au, char *file_name)
{
	SWEEP_INFO *in = (SWEEP_INFO *)au->info;

	if (!au->simulate)
		au_printf(au, "\n");

//	  au_printf(au, "@?6Processing @?1%s@?H\n", au->source_directory);

	check_for_key();
	press_any_key(au);
	if (!au->simulate)
		system(in->command);

	Unused(file_name);
	return 0;
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	char hold_dir[FLENGTH];
	SWEEP_INFO *in = (SWEEP_INFO *)au->info;
	int i;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case 'B':
			au->pause = get_value(au, OFF | ON);
			break;
		case 'G':
			in->greater_than=cur_argv[0];
			break;
		case 'L':
			in->less_than=cur_argv[0];
			break;
		case 'P':
			in->pipe=cur_argv[0];
			break;
		case '?':
			au_syntax_message(au, "SWeep");
			au_printf(au,
			   "@?H[@?3options@?H] [@?1paths(s)@?H] command [command parameters]\n\n");
			au_param_heading(au);
			au_printf(au,
			   "@?3-B@?Hon|off  Break at each directory\n"
			   "@?3-G@?H<char>  Greater than character, default = }\n"
			   "@?3-L@?H<char>  Less than character, default = { \n"
			   "@?3-P@?H<char>  Pipe character, default = ~\n\n"
			   "Where <char> is a single character\n");
			exit (0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	case PARSE_FILESPEC:
		if (!in->into_command)
		{
			getcwd(hold_dir, FLENGTH);
			if (chdir(cur_argv) == 0)
			{
				add_to_list(au, &au->process_list, cur_argv);
				chdir(hold_dir);
			}
			else
				in->into_command = TRUE;
		}
		if (in->into_command)
		{
			strcat(in->command, " ");
			strcat(in->command, cur_argv);
		}
		return TRUE;
	case PARSE_POST_CHECK:
		if (in->command[0] == '\0')
		{
			au_printf_error(au, "Execution command is missing");
			exit (1);
		}
		/* get back the > < and | from the command to execute */
		for (i = strlen(in->command)-1; i >= 0; i--)
		{
			if (in->command[i] == in->greater_than)
				in->command[i] = '>';
			else if (in->command[i] == in->less_than)
				in->command[i] = '<';
			else if (in->command[i] == in->pipe)
				in->command[i] = '|';
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int main_sweep(AU *au, int argc, char *argv[])
{
	SWEEP_INFO *in;

	in = (SWEEP_INFO *)au_malloc(au, sizeof(SWEEP_INFO));
	memset(in, '\0', sizeof(SWEEP_INFO));
	au->info = in;
	in->greater_than = '}';
	in->less_than = '{';
	in->pipe = '~';

	au->dirs_only = TRUE;

	generic_parse_comm_line(au, argc, argv, parse_comm_line);
	process_files(au, sweep);
	return 0;
}

