// HEADER.CPP								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
// Header and Strip options
////////////////////////////////////////////////////////////////////////

#include "au.hpp"

/*********************************************************************/
/* Define Statements */
/*********************/

#define PROGRAM_HEADER "HEADER" // Name of modules
#define PROGRAM_STRIP  "STRIP"

/*********************************************************************/

typedef struct
{
	char number_headers;  // number of header files
	LISTPTR header_list;

	char e_file[80];	  // Empty file
	long change;
	long total_bytes;	  // Total Bytes processed
	int  header_num;	  // Header number to use
} HEADER_INFO;

/**/
static void print_info(AU *au)
{
	HEADER_INFO *in = (HEADER_INFO *)au->info;

	if (!au->no_extra)
	{
		au_printf_c(au, 15, "\nFiles Processed = %d\n", au->number_processed);
		au_printf_c(au, 15, "Total Bytes Processed = %ld\n", in->total_bytes);

		if (in->change <= 0)
		{
			au_printf_c(au, 15, "Total Bytes   Saved   = %ld\n", -in->change);
			au_printf_c(au, 15, "Total Percent Saved   = %s\n",
			   ltrim(percent_string(in->total_bytes, in->total_bytes+in->change)));
		}
		else
		{
			au_printf_c(au, 15, "Total Bytes   Lost   = %ld\n", in->change);
			au_printf_c(au, 15, "Total Percent Lost   = %s\n",
			   ltrim(percent_string(in->total_bytes+in->change, in->total_bytes)));
		}
	}
}
/**/
static void end_program(void)
{
	HEADER_INFO *in = (HEADER_INFO *)glob_au->info;

	if (in->e_file[0] != '\0')
		unlink(in->e_file);
	return;
}
/**/
static void header_one(AU *au, char *file_name, PACKAGE *package)
{
	LIST *element;
	char picked;
	char string[FLENGTH];
	char string2[FLENGTH];		/* build the dos commands in the string */
	struct ffblk ffblk;
	long   fsize_before;
	int  did_rename;
	HEADER_INFO *in = (HEADER_INFO *)au->info;

	if (package->header[0] == '\0')
		return;

	au_printf(au, "@?6Modifying Header of @?1%s@?H\n", file_name);

	did_rename = rename_strict(au, package, au->source_directory, file_name);
	au->number_processed++;

	findfirst(file_name, &ffblk, 0);
	fsize_before = ffblk.ff_fsize;
	in->total_bytes += fsize_before;

	if (in->header_num != 0)
		picked = in->header_num;
	else
		picked = rand() % in->number_headers;
	element = in->header_list.head;
	for (int i=0; i<picked; i++)	 /* skip to the right file */
		element = element->next;

	substitute_macros(string, package->header, NULL, NULL, file_name);

	if (package->header_method == HEADER_AT)
		sprintf(string2, "ECHO @%s | %s", element->data, string);
	else if (package->header_method == HEADER_RED)
		sprintf(string2, "%s <%s", string, element->data);
	else
		sprintf(string2, "%s %s", string, element->data);

	if (!au->simulate)
	{
		system(string2);
		//execute(string2, output, NULL);
		if (did_rename)
			rename_strict_back(au->source_directory, file_name);
		fix_flist(au, file_name, file_name);

		findfirst(file_name, &ffblk, 0);
		in->change += ffblk.ff_fsize - fsize_before;
	}

}
/**/
static int header(AU *au, char *file_name)
{
	HANDLE file;
	ARC_FILE arcFile;
	struct ftime ftime_hold;

	check_for_key();

	arc_file_init(au, &arcFile, file_name);
	getftime(file, &ftime_hold);
	arc_file_deinit(au, &arcFile);
	if (arcFile.type > 0)
	{
		header_one(au, file_name, &au->package[arcFile.type]);

		if (!au->simulate)
		{
			file = au_open(au, file_name);
			setftime(file, &ftime_hold);
			close(file);
		}
	}
	return 0;
}
/**/
static void add_header(AU *au, char *string)
{
	struct ffblk ffblk;
	HEADER_INFO *in = (HEADER_INFO *)au->info;

	if (findfirst(string,&ffblk,0))
	{
		au_printf_error(au, "Header_file '%s' Not found", string);
		exit(1);
	}
	add_to_list(au, &in->header_list, string);
	in->number_headers++;
}
/**/
static void ReadCFGInfo(AU *au, HANDLE file, char *cfg_file, int *cfg_line)
{
	char string[200],
		 string2[200],
		 string3[200];

	for(EVER)
	{
		if (get_file_line(au, file, string)==EOF)
			break;

		split_string(string, string2);
		split_string(string, string3);

		if (string2[0] == '\0')
			continue;

		strcpy(au->curOpt, string2);
		au->curVal = string3;
		switch (toupper(string2[1]) << 8 | toupper(string2[0]))
		{
			case 'BE':                                          // Begin
				return;
			case 'HE':
				add_header(au, string3);
				break;
			default:
				au_invalid_cfg_option(au, string2, cfg_file, *cfg_line);
		}
	}
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	HEADER_INFO *in = (HEADER_INFO *)au->info;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case 'A':
			add_header(au, cur_argv);
			break;
		case 'H':
			/* add clean up code right here*/
			in->header_list.head = in->header_list.tail = NULL;
			in->number_headers = 0;
			add_header(au, cur_argv);
			break;
		case 'N':
			in->header_num = atoi(cur_argv);
			break;
		case '?':
			au_standard_opt_header(au, "Header",
			   "@?3-N@?H#              Used header file #\n"
			   "@?3-A@?H<File>         Add header file\n"
			   "@?3-H@?H<File>         use this Header file only\n");
			exit (0);
		default:
			au_invalid_option(au, PROGRAM_HEADER, option);
		}
		return TRUE;
	case PARSE_POST_CHECK:
		if (in->header_num > in->number_headers)
		{
			au_printf_error(au, "\nOnly %d headers", in->number_headers);
			exit(1);
		}
		if (in->number_headers==0)
		{
			au_printf_error(au, "No header_file specified");
			exit(1);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
static BYTE parse_comm_line2(AU *au, char option, char *cur_argv,
							 PARSE_TYPE type)
{
	Unused(cur_argv);

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case '?':
			au_standard_opt_header(au, "STrip", NULL);
			exit (0);
		default:
			au_invalid_option(au, PROGRAM_STRIP, option);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int main_header(AU *au, int argc, char *argv[])
{
	HEADER_INFO *in;

	in = (HEADER_INFO *)au_malloc(au, sizeof(HEADER_INFO));
	memset(in, '\0', sizeof(HEADER_INFO));
	au->info = in;

	srand(time(NULL) % 37);

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM_HEADER, ReadCFGInfo);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);

	process_files(au, header);
	print_info(au);

	return 0;
}
/**/
int main_strip(AU *au, int argc, char *argv[])
{
	HEADER_INFO *in;

	in = (HEADER_INFO *)au_malloc(au, sizeof(HEADER_INFO));
	memset(in, '\0', sizeof(HEADER_INFO));
	au->info = in;

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM_STRIP, ReadCFGInfo);
	generic_parse_comm_line(au, argc, argv, parse_comm_line2);

	atexit(end_program);

	build_fname(in->e_file, au->cur_directory, "e__file.$$$");
	close(_creat(in->e_file,0));   /* Create an Empty file */

	add_header(au, in->e_file);
	in->number_headers = 1;

	process_files(au, header);
	print_info(au);

	return 0;
}

