// ADD.CPP									 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"

/*********************************************************************/
/* Define Statements */
/*********************/

#define PROGRAM "ADD"    // Name of module

/*********************************************************************/

typedef struct
{
	char process_one;
	char default_type;
	char default_ext[5];
} ADD_INFO;

/**/
static void add_one(AU *au, char *file_name, PACKAGE *package)
{
	char string[FLENGTH];	 /* build the dos commands in the string */
	int  did_rename;

	au_printf(au, "@?6Adding @?B%s @?6to @?1%s@?H\n", au->partial, file_name);

	if (package->arc[0] == '\0')
	{
		au_printf_error(au, "No archiving method specified for %s", file_name);
		press_any_key(au);
		return;
	}

	did_rename = rename_strict(au, package, au->source_directory, file_name);

	au->number_processed++;
	substitute_macros(string, package->arc,
		 au->unarc_paths == ON ? package->arc_path : package->arc_no_path,
		 NULL, file_name);

	strcat(string," ");
	strcat(string, au->partial);

	if (!au->simulate)
	{
		execute(au, string, au->output, NULL, package->memoryNeeded);

		if (did_rename)
			rename_strict_back(au->source_directory, file_name);

		fix_flist(au, file_name, file_name);
	}
	return;
}
/**/
static int add_func(AU *au, char *file_name)
{
	ARC_FILE arcFile;
	struct ftime ftime_hold;

	check_for_key();

	arc_file_init(au, &arcFile, file_name);
	getftime(arcFile.file, &ftime_hold);
	arc_file_deinit(au, &arcFile);
	if (arcFile.type > 0)
	{
		add_one(au, file_name, &au->package[arcFile.type]);
		if (au->date_retain == ON)
			set_file_time(au, file_name, &ftime_hold);
	}
	return 0;
}
/**/
static void ReadCFGInfo(AU *au, HANDLE file, char *cfg_file, int *cfg_line)
{
	char string[200],
		 string2[200],
		 string3[200];
	ADD_INFO *in = (ADD_INFO *)au->info;

	for(EVER)
	{
		if (get_file_line(au, file, string)==EOF)
			break;

		split_string(string, string2);
		split_string(string, string3);

		if (string2[0] == '\0')
			continue;

		strcpy(au->curOpt, string2);
		au->curVal = string3;
		switch (toupper(string2[1]) << 8 | toupper(string2[0]))
		{
			case 'BE':                                          // Begin
				return;
			case 'DE':                                          // Default type
				if (isdigit(string[0]))
					in->default_type = atoi(string);
				else
					safe_string_copy(in->default_ext, string3, 5, FALSE);
				break;
			case 'PA':                                          // Paths
				au->unarc_paths = get_value(au, OFF | ON);
				break;
			default:
				au_invalid_cfg_option(au, string2, cfg_file, *cfg_line);
		}
	}
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	ADD_INFO *in = (ADD_INFO *)au->info;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case 'P':
			if (toupper(*cur_argv) == 'A')
			{
				strcpy(au->curOpt, "-PA");
				au->curVal = cur_argv+1;
				au->unarc_paths = get_value(au, OFF | ON);
			}
			break;
		case 'D':
			au->date_retain = get_value(au, OFF | ON);
			break;
		case '?':
			au_syntax_message(au, "Add");
			au_printf(au,
				"[@?3options@?H] @?1Archive(s) @?Badd_filespec(s)@?H\n\n");
			au_param_heading(au);
			au_printf(au,
				"@?3-PA@?Hon|off        include file PAths when adding files\n"
				"@?3-D@?Hon|off         Date retain\n");
			exit(0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	case PARSE_FILESPEC:
		if (au->process_list.head == NULL)
		{
			add_to_list(au, &au->process_list, cur_argv);
			if (strchr(cur_argv, '*') == NULL &&
				strchr(cur_argv, '?') == NULL)
			{
				in->process_one = TRUE;
			}
		}
		else
		{
			strcat(au->partial, cur_argv);
			strcat(au->partial, " ");
		}
		return TRUE;
	case PARSE_POST_CHECK:
		if (au->process_list.head == NULL)
		{
			au_printf_error(au, "No Archive file specified");
			exit(0);
		}
		if (au->partial[0] == '\0')
			strcpy(au->partial, "*.*");

		/* Must delay search until whole .cfg is parsed */
		if (in->default_ext[0] != '\0')
			in->default_type = find_ext(au, in->default_ext);
		return TRUE;
	}
	return FALSE;
}
/**/
int main_add(AU *au, int argc, char *argv[])
{
	char string[FLENGTH];
	ADD_INFO *in;

	in = (ADD_INFO *)au_malloc(au, sizeof(ADD_INFO));
	memset(in, '\0', sizeof(ADD_INFO));
	au->info = in;
	in->default_type = -1;

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, ReadCFGInfo);

	generic_parse_comm_line(au, argc, argv, parse_comm_line);


	if (!in->process_one)
		process_files(au, add_func);
	else
	{
		char *ptr;
		char type;

		ptr = strchr(au->process_list.head->data, '.');

		build_fname(string, au->source_directory, au->process_list.head->data);

		if (access(string, 0x00) == 0)
		{
			process_files(au, add_func);
			if (au->number_processed == 0)
			{
				au_printf_error(au, "\nCan not add to a non archive");
				exit(1);
			}
		}
		else if (ptr == NULL)
		{
			if (in->default_type == -1)
			{
				au_printf_error(au, "\nNo Recognizable Default Type specified");
				exit(1);
			}
			add_one(au, au->process_list.head->data, &au->package[in->default_type]);
		}
		else
		{
			if ((type = find_ext(au, ptr+1)) == -1)
			{
				if (in->default_type != -1)
					type = in->default_type;
			}

			if (type == -1)
			{
				au_printf_error(au, "\nNo Recognizable Default Type specified");
				exit(1);
			}
			add_one(au, au->process_list.head->data, &au->package[type]);
		}

	}
	if (!au->no_extra)
		au_printf_c(au, 15, "\n\nFiles Processed = %d\n", au->number_processed);

	return (0);
}

