#include "..\au.hpp"
/************************************************************************/
char *left_pad(char *string, int n)  // add spaces to left until n length
{
    static char string2[30];

    int len = strlen(string);

    for (int i=0 ; i < n - len ; i++)
        string2[i]=' ';
    string2[i] = '\0';
    strcat(string2,string);

    return string2;
}
/************************************************************************/
char *ltrim(char *string)		   /* chop of leading spaces from string */
{
	while (string[0]<=' ' && string[0]>0)
		strcpy(string,string+1);
	return string;
}
/************************************************************************/
char *right_pad(char *string, int n)  // add spaces to right until n length
{
	static char string2[30];

	int len = strlen(string);

	strcpy(string2,string);

	for (int i=len ; i < n ; i++)
		string2[i]=' ';
	string2[i] = '\0';

	return string2;
}
/************************************************************************/
char *rtrim(char *string)          /* chop of trailing spaces from string */
{
	int pos = strlen(string)-1;
	char c;

	while (pos >= 0)
	{
		c = string[pos];
		if (c != ' ' && c != '\t')
			break;
		pos--;
	}
	string[pos+1] = '\0';
	return string;
}
/***********************************************************************/
void split_string(char *string1, char *string2)
{
	int i=0;

	while (TRUE)
	{
		if (string1[i]<=' ')             /* should get space,tab and NULL */
		{
			ltrim(string1);
			string2[i]=NULL;
			return;
		}
		string2[i]=string1[i];
		string1[i]=' ';
		i++;
	}
}
/************************************************************************/
char *safe_string_copy(char *target, char *source, int n, BYTE trim)
{
	strncpy(target, source, n-1);
	source[n-1] = '\0';
	if (trim)
	{
		ltrim(target);
		rtrim(target);
	}
    return target;
}
/**************************************************************************/
void string_replace(char *string, char *oldStr, char *newStr)
{
	char *ptr;
	int lenOld, lenNew;

	lenOld = strlen(oldStr);
	lenNew = strlen(newStr);

	while ((ptr = strstr(string, oldStr)) != NULL)
	{
		if (lenNew > lenOld)
			memmove(ptr + lenNew - lenOld, ptr, strlen(ptr)+1);
		else
			memmove(ptr, ptr + lenOld - lenNew, strlen(ptr + lenOld - lenNew)+1);
		strncpy(ptr, newStr, lenNew);
	}
	return;
}
