#include "..\au.hpp"

/**/
char ok_to_process(AU *au, char *filename)
{
	LIST *el;

	for (el=au->dont_touch.head; el != NULL; el = el->next)
	{
		if (wildcard_compare(au, filename, el->data))
			return FALSE;
	}
	return TRUE;
}
/*************************************************************************/
static void get_range(AU *au, char *range, char *wildcard, int *range_size)
{
	int invert = FALSE;

	memset(range, FALSE, 256);
	if (*wildcard == '[')
	{
		wildcard++;
		*range_size = 1;
		if (*wildcard == '^')
		{
			invert = TRUE;
			wildcard++;
			(*range_size)++;
		}
		while (*wildcard != ']')
		{
			if (*wildcard == '\0')
			{
				au_printf_error(au, "\n] missing in file specification");
				exit(1);
			}

			if (*(wildcard + 1) == '-')
			{
				unsigned char first, last;
				first = *wildcard;
				last = *(wildcard+2);
				if (first > last)
				{
					unsigned char temp;
					temp = first;
					first = last;
					last = temp;
				}
				memset(range+first, TRUE, last-first+1);
				wildcard+=3;
				(*range_size)+=3;
			}
			else
			{
				range[*wildcard] = TRUE;
				wildcard++;
				(*range_size)++;
			}
		}
		(*range_size)++;

		if (invert)
		{
			for (int i=0; i<256; i++)
			{
				if (range[i])
					range[i] = FALSE;
				else
					range[i] = TRUE;
			}
		}
	}
	else
	{
		range[*wildcard] = TRUE;
		*range_size = 1;
	}
	return;
}
/*************************************************************************/
char wildcard_compare(AU *au, char *filename, char *wildcard)
{
	unsigned char Wchar, Fchar, Nchar;
	int  Wpos = 0, Fpos =0;
	int  range_size;		/* ie [a-b] is 5 */
	int  try_again_Wpos=-1;
	int  try_again_Fpos=-1;
	char range[256];

	if (strcmp(wildcard, "$.*") == 0)
	{
		return
		   (wildcard_compare(au, filename, "*.SU[0-9]") ||
			wildcard_compare(au, filename, "*.MO[0-9]") ||
			wildcard_compare(au, filename, "*.TU[0-9]") ||
			wildcard_compare(au, filename, "*.WE[0-9]") ||
			wildcard_compare(au, filename, "*.TH[0-9]") ||
			wildcard_compare(au, filename, "*.FR[0-9]") ||
			wildcard_compare(au, filename, "*.SA[0-9]"));
	}

	strupr(wildcard);
	strupr(filename);

	for(EVER)
	{
		Wchar = wildcard[Wpos];
		Fchar = filename[Fpos];
		if (Fchar == '\0' && Wchar == '\0')
			return TRUE;

		switch (Wchar)
		{
		case '*':
			/* Take care of ** and *? combinations */
			for(EVER)
			{
				Nchar = wildcard[Wpos+1];
				if (Nchar != '*' && Nchar != '?')
					break;
				Wpos++;
			}
			get_range(au, range, wildcard+Wpos+1, &range_size);

			for(EVER)
			{
				Fchar = filename[Fpos];
				if (range[Fchar])
				{
					try_again_Fpos = Fpos+1;
					try_again_Wpos = Wpos;
					Wpos++;
					break;
				}
				if (Fchar == '\0')
					return FALSE;
				Fpos++;
			}
			break;
		case '?':
			if (Fchar == '\0')
				return FALSE;
			Wpos++;
			Fpos++;
			break;
		default:
			get_range(au, range, wildcard+Wpos, &range_size);
			if (!range[Fchar])
			{
				if (try_again_Fpos != -1)
				{
					Fpos = try_again_Fpos;
					Wpos = try_again_Wpos;
					continue;
				}
				return FALSE;
			}
			Wpos += range_size;
			Fpos++;
		}
	}
}
#if 0
/*************************************************************************/
BYTE wildcard_compare_multi(LISTPTR *listPtr, char *wildcard)
{
	LIST *el;

	for (el = listPtr->head; el != NULL; el = el->next)
	{
		if (wildcard_compare(el->data, wildcard))
			return TRUE;
	}
	return FALSE;
}
#endif
