#include "..\au.hpp"
#include <errno.h>

/*************************************************************************/
void cd(AU *au, char *string, char *old_dir) /* supplements the lacking turboc Cs */
{
	char temp_dir[FLENGTH];
	char string2[FLENGTH];
	int  temp;

	if (old_dir != NULL)
		getcwd(old_dir, FLENGTH);

	if (string[0]=='\0')   /* Don't remove this, 10 lines down will cause you grief */
		return;
	strcpy(string2,string);

	/* strip the trialing \ if it exists */
	temp = strlen(string2);
	if (temp > 1 && string2[temp-1] == '\\' && string2[temp-2] != ':')
		string2[temp-1] = '\0';
	temp=0;

	getcwd(temp_dir,FLENGTH);	  /* don't do anything if already there */
	if (stricmp(string2, temp_dir)==0)
		return;

	if (string2[1]==':')
	{
		temp=2;
		setdisk(toupper(string2[0]) - 'A');
	}

	if (string2[temp] != '\0')
	{
		if (chdir(string2+temp) == -1)
		{
			au_printf_error(au, "Invalid Directory '%s'", string2);
			exit(1);
		}
	}
}

