#include "..\au.hpp"

/**************************************************************************/
void *au_calloc(AU *au, int size, int number)
{
	void *ptr;

	ptr = calloc(size, number);
	if (ptr == NULL)
	{
		au_printf_error(au, "\nOut of Memory");
		exit(1);
	}
	return ptr;
}
/**************************************************************************/
void *au_malloc(AU *au, int size)
{
	void *ptr;

	ptr = malloc(size);
	if (ptr == NULL)
	{
		au_printf_error(au, "\nOut of Memory");
		exit(1);
	}
	return ptr;
}

/*************************************************************************/
char *string_save(AU *au, char *string)
{
	char *ptr;

	ptr = (char *)au_malloc(au, strlen(string)+1);
	strcpy(ptr, string);
	return ptr;
}
