// MAIN.CPP 								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"
#include <process.h>

AU *glob_au;

/**/
static void clean_up(void)
{
	fix_flist(glob_au, NULL, NULL);    /* Flush Remainder */

	if (glob_au->flist_log_file != -1)
		close(glob_au->flist_log_file);

	if (glob_au->problem_file != -1)
		close(glob_au->problem_file);

	if (glob_au->action_file != -1)
		close(glob_au->action_file);

	cd(glob_au, glob_au->old_dest_dir);
	cd(glob_au, glob_au->old_source_dir);
	cd(glob_au, glob_au->cur_directory);

	if (glob_au->info != NULL)
		free(glob_au->info);
	free(glob_au);
}
/**/
void ReadGlobalCFGInfo(AU *au, char *cfg_file, char *option, void (*func)(AU *, HANDLE, char *, int *))
{
	char string[200],
		 string2[200];
	HANDLE file;
	int type = 0;
	int done_global = FALSE;
	int cfg_line = 0;

	/* Make all 0's so we can test existence later */
	memset(au->package, '\0', sizeof(PACKAGE)*MAX_TYPES);

	file = opencfg(au, cfg_file);

	for(EVER)
	{
		if (get_file_line(au, file, string)==EOF)
			break;
		cfg_line++;

		split_string(string, string2);
		if (string2[0] == '\0')
			continue;

		ltrim(string);
		rtrim(string);

		strcpy(au->curOpt, string2);
		au->curVal = string;
		switch (toupper(string2[1]) << 8 | toupper(string2[0]))
		{
			case 'AC':                                          // Action_log
				get_full_file_name(au, au->action_log, string);
				break;
			case 'AR':
				if (stricmp(string2,"arc_path")==0)
					au->package[type].arc_path = string_save(au, string);
				else if (stricmp(string2,"arc_no_path")==0)
					au->package[type].arc_no_path = string_save(au, string);
				else
					au->package[type].arc = string_save(au, string);
				break;
			case 'BE':                                          // Begin
				if (stricmp(string, "GLOBAL")==0)
					done_global = TRUE;
				else if (stricmp(string, option)!=0)
				{
					for(EVER)
					{
						if (get_file_line(au, file, string)==EOF)
							goto Done;
						cfg_line++;
						split_string(string, string2);
						if (stricmp(string2,"begin")==0)
						{
							if (stricmp(string, option)==0)
							{
								/* Just in case somebody throws in an illegal section */
								if (func != NULL)
									func(au, file, cfg_file, &cfg_line);

								if (done_global)
									goto Done;
								else
									break;
							}
							else if (stricmp(string, "GLOBAL")==0)
							{
								done_global = TRUE;
								break;
							}
						}
					}
				}
				else
				{
					func(au, file, cfg_file, &cfg_line);
					goto Done;
				}
				break;
			case 'BR':
				au->package[type].break_err = atoi(string);
				break;
			case 'CR':
				au->package[type].crc = atoi(string);
				break;
			case 'DE':                                          // Description
				if (stricmp(string2, "description") == 0)
					safe_string_copy(au->description, string, DESC_SIZE, TRUE);
				else if (stricmp(string2, "desc_file") == 0)
					safe_string_copy(au->desc_file, string, FILE_SIZE, TRUE);
				else if (stricmp(string2, "default_file_spec") == 0)
					au->def_file_spec = string_save(au, string);
				else
					au->package[type].del = string_save(au, string);
				break;
			case 'EX':
				strcpy(au->package[type].extension, string);
				break;
			case 'FI':                                          // File_list
				if (stricmp(string2, "FILE_LIST_LOG")==0)
					get_full_file_name(au, au->flist_log, string);
				else
				{
					split_string(string, string2);
					if (stricmp(string2, "+append")==0)
					{
						split_string(string, string2);
						add_to_flist(au, string2, TRUE);
					}
					else
						add_to_flist(au, string2, FALSE);
				}
				break;
			case 'FO':
				if (stricmp(string,"OPUS")==0)
					au->force_mode = OPUS;
				else if (stricmp(string,"RBBS")==0)
					au->force_mode = RBBS;
				else if (stricmp(string,"GT")==0)
					au->force_mode = GT;
				else
				{
					au_printf_error(au, "Unknown File Type '%s'\n", string);
					exit(1);
				}
				break;
			case 'HE':
				split_string(string, string2);
				if (strcmp(string, "<")==0)
					au->package[type].header_method = HEADER_RED;
				else if (strcmp(string, "@") == 0)
					au->package[type].header_method = HEADER_AT;
				else
					au->package[type].header_method = HEADER_FILE;
				au->package[type].header = string_save(au, string);
				break;
			case 'ME':
				au->package[type].memoryNeeded = atoi(string);
				break;
			case 'OU':
				if (!strstr(string,":") && !strstr(string,"\\"))
				{
					strcpy(au->output, au->cur_directory);
					append_backslash(au->output);
				}
				strcat(au->output, string);
				break;
			case 'PR':                                          // Problem_Log
				get_full_file_name(au, au->problem_log, string);
				break;
			case 'RE':                                          // Retest
				au->retest = get_value(au, OFF | ON);
				break;
			case 'SC':                                          // Scanner
				if (stricmp(string2, "SC_NOVIRUS_ERRORLEVEL") == 0)
					au->SC_NoVirus_EL = atoi(string);
				else if (stricmp(string2, "SC_VIRUS_ERRORLEVEL") == 0)
					au->SC_Virus_EL = atoi(string);
				else if (stricmp(string2, "SC_MEMORY_NEEDED") == 0)
					au->scannerMemNeeded = atoi(string);
				else
					strcpy(au->scanner, string);
				break;
			case 'SM':
				au_printf_error(au, "Version 1.13 or below Config file!");
				exit(1);
			case 'ST':
				au->package[type].strict_ext = get_value(au, OFF | ON);
				break;
			case 'TY':                                          // Type
				type = atoi(string);
				break;
			case 'TE':                                          // Test
				au->package[type].test = string_save(au, string);
				break;
			case 'UN':
				if (stricmp(string2,"unarc_path")==0)
					au->package[type].unarc_path = string_save(au, string);
				else if (stricmp(string2,"unarc_no_path")==0)
					au->package[type].unarc_no_path = string_save(au, string);
				else if (stricmp(string2, "unarc_partial") == 0)
					au->package[type].unarc_partials = get_value(au, OFF | ON);
				else
					au->package[type].unarc = string_save(au, string);
				break;
			case 'YE':
				au->package[type].yes_queries = string_save(au, string);
				break;
			case '#I':
				ReadGlobalCFGInfo(au, string, option, func);
				break;
			default:
				au_invalid_cfg_option(au, string2, cfg_file, cfg_line);
		}
	}
Done:
	close(file);
}
/**/
/* Parse the command line parameters */

static void parse_comm_line(AU *au, int argc, char *argv[])
{
	char *cur_argv;
	char string[128];

	for (int i=0; i<argc; i++)
	{
		strcpy(string, argv[i]);
		subst_environ(au, string);
		cur_argv=string;
		if (cur_argv[0]=='-' || cur_argv[0]=='/')   /* dash option */
		{
			char option = toupper(cur_argv[1]);

			if (option == '-' || option == '/')
				break;

			if (option == 'S')
			{
				argv[i][0] = '\0';
				if (toupper(cur_argv[2]) == 'D')
				{
					if (cur_argv[3] == '\0')
						au->sub_dirs = 50;
					else
						au->sub_dirs = atoi(cur_argv+3);
				}
				else if (toupper(cur_argv[2]) == 'E')
					au->show_execute = TRUE;
				else
					au->simulate = TRUE;
			}
			else if (option == 'Z')
			{
				argv[i][0] = '\0';
				au->debug = TRUE;
			}
			else if (option == 'N' && toupper(cur_argv[2])=='E')
			{
				argv[i][0] = '\0';
				au->no_extra = TRUE;
			}
			else if (option == 'N' && toupper(cur_argv[2]) == 'C')
			{
				argv[i][0] = '\0';
				au->colorized = FALSE;
			}
			else if (option == 'O' || option == 'C')
			{
				argv[i][0] = '\0';
				if (cur_argv[2]=='\0')    /* parameter continues on next */
				{
					strcpy(string, argv[++i]);
					subst_environ(au, string);
					cur_argv=string;
				}
				else
					cur_argv+=2;		   /* advance it 2 characters */
				switch (option)
				{
					case 'C':
						strcpy(au->cfg_file, cur_argv);
						break;
					case 'O':
						if (!strstr(cur_argv,":") && !strstr(cur_argv,"\\"))
						{
							strcpy(au->output, au->cur_directory);
							append_backslash(au->output);
						}
						strcat(au->output, cur_argv);
						break;
				}
				argv[i][0] = '\0';
			}
			else if (option == 'F')
			{
				au->flist_pos = 0;
				if (cur_argv[2] == '+')
					add_to_flist(au, cur_argv+3,TRUE);	// Func checks for dupes
				else
					add_to_flist(au, cur_argv+2,FALSE);
				argv[i][0] = '\0';
			}
			else if (option == 'E')
			{
				argv[i][0] = '\0';
				if (cur_argv[2]=='\0')    /* parameter continues on next */
				{
					strcpy(string, argv[++i]);
					subst_environ(au, string);
					cur_argv=string;
				}
				else
					cur_argv+=2;		   /* advance it 2 characters */
				safe_string_copy(au->env_var, cur_argv, ENV_SIZE, FALSE);
			}
			else
			   fix_path(cur_argv+1);
		}
		else
			fix_path(cur_argv);
	}
	if (au->output[0] != '\0')
		close(_creat(au->output,0));
}
/**/
static void help(AU *au)
{
	 au_printf(au, "%s",
		"@?5Syntax: @?2AU@?H @?6action @?H[@?3options@?H] [@?1File Specs@?H]\n"
		"\n"
		"@?7Actions ***********************************************************************@?H\n"
		"     @?6A@?Hdd       @?6DU@?Hpes      @?6P@?Hatch    @?6SW@?Heep  \n"
		"     @?6COM@?Hpare   @?6F@?Hind       @?6R@?Hedate   @?6T@?Hest   \n"
		"     @?6C@?Honvert   @?6FIX@?Hcr      @?6S@?Hcan     @?6U@?Hnarc  \n"
		"     @?6D@?Helete    @?6H@?Header     @?6SI@?Hze     @?6W@?Hhatis \n"
		"     @?6DI@?Hr       @?6O@?Hrphans    @?6ST@?Hrip    @?6V@?Hiew   \n"
		"@?7Global Options ****************************************************************@?H\n"
		"     @?3-NE@?H    No Extra info displayed      @?3-C@?D<file>@?H     alternate Config file\n"
		"     @?3-NC@?H    No Color                     @?3-O@?D<file|dev>@?H archiver Output\n"
		"     @?3-S@?H     Simulate Mode                @?3-?@?H           specific help on action\n"
		"     @?3-SD@?H[@?Dn@?H] process Sub Dirs (@?Dn@?H=depth)   @?3--@?H           stop scanning for options\n"
		"     @?3-SE@?H    Show Executed Commands       @?3-E@?D<var>@?H      Result to variable @?Dvar@?H\n"
		"     @?3-F@?H[@?3+@?H]@?D<file>@?H      additional file listing file(s) to update\n"
		"@?7File Specs ********************************************************************@?H\n"
		"     Standard wildcards    @?1*.*, *.zip, A*.*@?H\n"
		"     Unix-Like wildcards   @?1*.??[0-9], [abc]*.lzh  [^f-h]*.zip@?H\n"
		"     Arcmail               @?1$@?H\n"
		"     Response (List) file  @?1@file@?H\n"
		"     BBS List file         @?1-#@?H[@?1filespec@?H]\n");

	exit(0);
}
/**/
static void AU_Init(AU **auRet, char *argv[], char *env[])
{
	AU *au;
	long memStart;

	memStart = farcoreleft();

	au = (AU *)malloc(sizeof(AU));
	if (au == NULL)
	{
		au_printf_error(au, "Out of Memory\n");
		exit(1);
	}
	memset(au, '\0', sizeof(AU));
	au->memStart	   = memStart;
	au->allow_rename   = TRUE;
	au->simulate	   = FALSE;
	au->smart		   = ON;
	au->pause		   = OFF;
	au->date_retain    = ON;
	au->self_extracts  = ON;
	au->sub_dirs	   = 0;
	au->no_extra	   = FALSE;
	au->flist_log_file = -1;
	au->problem_file   = -1;
	au->action_file    = -1;
	au->SC_Virus_EL    = -1;
	au->SC_NoVirus_EL  = -1;

	au->colorized	   = is_stdout();
	au->current_color  = 7;

	au->argv0 = argv[0];
	au->env   = env;
	strcpy(au->cfg_file, "AU116.CFG");
	getcwd(au->cur_directory, FLENGTH);  /* hold onto the current directory */
	strcpy(au->last_dir, au->cur_directory);

	*auRet = au;
	glob_au = au;
	return;
}
/**/
static int AU_RunChoice(AU *au, char *choice, int argc, char *argv[])
{
	int ret_code, ret_code2;
	int len = strlen(choice);
	int (*func)(AU *, int, char *[]) = NULL;

	if (strnicmp(choice, "ADD", len)==0)
		func = main_add;
	else if (strnicmp(choice, "CONVERT", len)==0)
		func = main_convert;
	else if (strnicmp(choice, "COMPARE", len)==0)
		func = main_compare;
	else if (strnicmp(choice, "DELETE", len)==0)
		func = main_delete;
	else if (strnicmp(choice, "DIR", len)==0)
		func = main_dir;
	else if (strnicmp(choice, "DUPES", len)==0)
		func = main_dupes;
	else if (strnicmp(choice, "FIND", len)==0)
		func = main_find;
	else if (strnicmp(choice, "FIXCR", len)==0)
		func = main_fixcr;
	else if (strnicmp(choice, "HEADER", len)==0)
		func = main_header;
	else if (strnicmp(choice, "PATCH", len)==0)
		func = main_patch;
	else if (strnicmp(choice, "ORPHANS", len)==0)
		func = main_orphan;
	else if (strnicmp(choice, "REDATE", len)==0)
		func = main_redate;
	else if (strnicmp(choice, "SCAN", len)==0)
		func = main_scan;
	else if (strnicmp(choice, "SIZE", len)==0)
		func = main_size;
	else if (strnicmp(choice, "SWEEP", len)==0)
		func = main_sweep;
	else if (strnicmp(choice, "STRIP", len)==0)
		func = main_strip;
	else if (strnicmp(choice, "TEST", len)==0)
		func = main_test;
	else if (strnicmp(choice, "UNARC", len)==0 ||
			 strnicmp(choice, "EXTRACT", len)==0 ||
			 strnicmp(choice, "XTRACT", len)==0)
		func = main_unarc;
	else if (strnicmp(choice, "VIEW", len)==0 ||
			 strnicmp(choice, "LIST", len)==0)
		func = main_view;
	else if (strnicmp(choice, "WHATIS", len)==0)
		func = main_whatis;
	else if (strchr(choice,'?') != NULL)
		help(au);
	else
	{
		au_printf_error(au, "Unknown Action, AU -? for help\n");
		exit(0);
	}
	ret_code = func(au, argc, argv);

	{
		char temp[150];
		if (au->env_var[0] != '\0' && au->env_cont[0] != '\0')
		{
			sprintf(temp, "%s=%s", au->env_var, au->env_cont);
			alter_env(au, temp, au->env);
		}
	}

	ret_code2 = display_bad_arcs(au);
	if (ret_code2 != 0)
		return ret_code2;
	else if (!au->no_extra)
	{
		if (func == main_test)
			au_printf_c(au, 10, "All Archive files tested are OK\n");
		else if (func == main_scan)
			au_printf_c(au, 10, "All Archive files scanned are OK\n");
	}
	return ret_code;
}
/**/
int main(int argc, char *argv[], char *env[])
{
	AU	 *au;

	AU_Init(&au, argv, env);

	if (argc < 2)
	{
		au_printf(au, VERSION);
		help(au);
	}

	parse_comm_line(au, argc-2, argv+2);

	if (!au->no_extra)
	{
		au_printf(au, VERSION);
		if (au->simulate)
			au_printf_c(au, 15, "(Simulation Mode)\n");
	}
	atexit(clean_up);
	set_ctrl_brk();

	return AU_RunChoice(au, argv[1], argc-2, argv+2);
}
