// DELETE.CPP								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"

/*********************************************************************/
/* Define Statements */
/*********************/

#define PROGRAM "DELETE"    // Name of module

typedef struct
{
	long change;
	long total_bytes;
	LISTPTR delete_list;
} DELETE_INFO;

/**/
static BYTE fill_delete_spec(AU *au, LIST **el, LISTPTR *arc_list, char *string)
{
	LIST *a_el;
	BYTE found = FALSE;

	string[0] = '\0';
	for (;;)
	{
		for (a_el = arc_list->head; a_el != NULL; a_el = a_el->next)
		{
			if (wildcard_compare(au, a_el->data, (*el)->data))
			{
				if (string[0] != '\0')
					strcat(string, " ");
				strcat(string, (*el)->data);
				found = TRUE;
				break;
			}
		}
		*el = (*el)->next;
		if (strlen(string) > 50 || *el == NULL)
			break;
	}
	return found;
}
/**/
static BYTE delete_one(AU *au, char *file_name, LISTPTR *arc_list, PACKAGE *package)
{
	char   delete_file_spec[80];
	char   string[FLENGTH];    /* build the dos commands in the string */
	int    changed = FALSE;
	int    did_rename;
	LIST   *el;
	DELETE_INFO *in = (DELETE_INFO *)au->info;

	if (package->del[0] == '\0')
	{
		au_printf_error(au, "No deleting method specified for %s", file_name);
		press_any_key(au);
		return FALSE;
	}

	el = in->delete_list.head;
	for (;;)
	{
		if (el == NULL)
			break;
		if (fill_delete_spec(au, &el, arc_list, delete_file_spec))
		{
			changed = TRUE;
			au_printf(au, "@?6Deleting @?B%s @?6from @?1%s@?H\n", delete_file_spec,
					  file_name);

			did_rename = rename_strict(au, package, au->source_directory, file_name);

			substitute_macros(string, package->del, NULL, NULL, file_name);
			strcat(string, " ");
			strcat(string, delete_file_spec);

			if (!au->simulate)
				execute(au, string, au->output, NULL, package->memoryNeeded);
			if (did_rename)
				rename_strict_back(au->source_directory, file_name);
		}
	}
	if (changed)
		fix_flist(au, file_name, file_name);

	return changed;
}
/**/
static void get_file_list(AU *au, char *file_name, ARC_FILE *arcFile,
						  LISTPTR *arc_list)
{
	int ret_code;
	ARC_RECORD record;

	memset(arc_list, '\0', sizeof(LISTPTR));

	for (;;)
	{
		ret_code = get_record(au, arcFile, &record);
		if (ret_code == EOF)
			break;
		else if (ret_code == -2)
		{
			add_to_bad_list(au, au->source_directory, file_name);
			return;
		}
		add_to_list(au, arc_list, record.name);
	}
	return;
}
/**/
static int delete_func(AU *au, char *file_name)
{
	HANDLE file;
	ARC_FILE arcFile;
	struct ftime ftime_hold;
	struct ffblk ffblk;
	long fsize_before;
	LISTPTR arc_list;
	DELETE_INFO *in = (DELETE_INFO *)au->info;

	check_for_key();

	arc_file_init(au, &arcFile, file_name);
	getftime(file, &ftime_hold);
	if (arcFile.type > 0)
	{
		get_file_list(au, file_name, &arcFile, &arc_list);
		arc_file_deinit(au, &arcFile);

		findfirst(file_name, &ffblk, 0);
		fsize_before = ffblk.ff_fsize;
		in->total_bytes += fsize_before;

		if (delete_one(au, file_name, &arc_list, &au->package[arcFile.type]))
		{
			findfirst(file_name, &ffblk, 0);
			in->change += ffblk.ff_fsize - fsize_before;

			au->number_processed++;
			if (au->date_retain == ON)
			{
				file = au_open(au, file_name, O_RDONLY | O_BINARY);
				if (file != -1)
				{
					setftime(file, &ftime_hold);
					close(file);
				}
			}
		}
		destroy_list(&arc_list);
	}
	else
		arc_file_deinit(au, &arcFile);
	return 0;
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	DELETE_INFO *in = (DELETE_INFO *)au->info;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case 'D':
			au->date_retain = get_value(au, OFF | ON);
			break;
		case '@':
			process_at_file(au, &in->delete_list, cur_argv);
			break;
		case '?':
			au_syntax_message(au, "DElete");
			au_printf(au,
				"[@?3options@?H] @?1archive_filespec @?Bdelete_filespec(s)@?H\n\n");
			au_param_heading(au);
			au_printf(au,
				"@?3-@@?Hfile           File containing list of files to delete\n"
				"@?3-D@?Hon|off         Date retain\n");
			exit (0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	case PARSE_FILESPEC:
		if (au->process_list.head == NULL)
			add_to_list(au, &au->process_list, cur_argv);
		else
		{
			if (stricmp(cur_argv, "*.*") == 0)
			{
				int opt;
				au_printf_c(au, 15, "*.* Will strip all files from the archives, proceed?");
				opt = my_getch();
				au_printf(au, "\n");
				if (opt=='N' || opt=='n')
					exit(0);
			}
			add_to_list(au, &in->delete_list, cur_argv);
		}
		return TRUE;
	case PARSE_POST_CHECK:
		if (au->process_list.head == NULL)
		{
			au_printf_error(au, "No Archive file specified");
			exit(0);
		}
		if (in->delete_list.head == NULL)
		{
			au_printf_error(au, "No delete file_spec specified");
			exit(0);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int main_delete(AU *au, int argc, char *argv[])
{
	DELETE_INFO *in;

	in = (DELETE_INFO *)au_malloc(au, sizeof(DELETE_INFO));
	memset(in, '\0', sizeof(DELETE_INFO));
	au->info = in;

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, NULL);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);

	process_files(au, delete_func);

	if (!au->no_extra)
	{
		au_printf_c(au, 15, "\n\nFiles Processed = %d\n", au->number_processed);
		au_printf_c(au, 15, "Total Bytes   Saved   = %ld\n", -in->change);
		au_printf_c(au, 15, "Total Percent Saved   = %s\n",
		   ltrim(percent_string(in->total_bytes, in->total_bytes+in->change)));
	}
	return (0);
}

