// COMPBBS.CPP								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"
#include <time.h>

#define PROGRAM "COMPARE"   // Name of module
/*********************************************************************/

typedef struct
{
	int area;
	char filename1[FLENGTH];
	char filename2[FLENGTH];
} COMPARE_INFO;

/**/
static void print_match(AU *au, char *string)
{
	COMPARE_INFO *in = (COMPARE_INFO *)au->info;

	if (in->area != 0)
		au_printf(au, "@?1%s@?H (%d)\n", string, in->area);
	else
		au_printf(au, "@?1%s@?H\n", string);
}
/**/
static int look_for_files(AU *au, LISTPTR *listptr, HANDLE file)
{
	char string[FILE_SIZE];
	LIST *el;
	int found;
	COMPARE_INFO *in = (COMPARE_INFO *)au->info;

	reset_buffer_pos();
	lseek(file, 0L, SEEK_SET);

	while (get_next_file_name(au, file, string, &in->area) != EOF)
	{
		found = FALSE;
		for (el = listptr->head; el != NULL; el=el->next)
		{
			if (strcmp(el->data, string) == 0)
			{
				found = TRUE;
				break;
			}
		}
		if (!found)
			print_match(au, string);
	}
	return 0;
}

/**/
static int compare(AU *au, char *filename1, char *filename2)
{
	HANDLE file1, file2;
	int ret_code = 0;
	char string[FILE_SIZE];
	LISTPTR listptr;
	COMPARE_INFO *in = (COMPARE_INFO *)au->info;

	memset(&listptr, '\0', sizeof(listptr));

	file1 = au_open(au, filename1, O_RDONLY);
	if (file1 < 0)
	{
		au_printf_error(au, "Unable to open %s", filename1);
		return -1;
	}
	file2 = au_open(au, filename2, O_RDONLY);
	if (file2 < 0)
	{
		au_printf_error(au, "Unable to open %s", filename2);
		ret_code = -1;
		goto Error0;
	}


	/* See what 2 has that 1 does not */
	while (get_next_file_name(au, file1, string, &in->area) != EOF)
	{
		if (wildcard_compare(au, string, au->partial))
			add_to_list(au, &listptr, string);
	}
	au_printf(au, "@?7Files in %s not in %s --------------:@?H\n", filename2, filename1);
	look_for_files(au, &listptr, file2);
	destroy_list(&listptr);
	memset(&listptr, '\0', sizeof(listptr));

	reset_buffer_pos();
	lseek(file2, 0L, SEEK_SET);

	/* See what 1 has that 2 does not */
	while (get_next_file_name(au, file2, string, &in->area) != EOF)
	{
		if (wildcard_compare(au, string, au->partial))
			add_to_list(au, &listptr, string);
	}
	au_printf(au, "@?7Files in %s not in %s --------------:@?H\n", filename1, filename2);
	look_for_files(au, &listptr, file1);
	destroy_list(&listptr);

Error1:
	close(file2);
Error0:
	close(file1);
	return ret_code;
}
/**/
static int disp_list(AU *au, char *filename)
{
	HANDLE file;
	char string[FILE_SIZE];
	COMPARE_INFO *in = (COMPARE_INFO *)au->info;

	file = au_open(au, filename, O_RDONLY);
	if (file < 0)
	{
		au_printf_error(au, "Unable to open %s", filename);
		return -1;
	}

	/* Get list */
	while (get_next_file_name(au, file, string, &in->area) != EOF)
	{
		if (wildcard_compare(au, string, au->partial))
			print_match(au, string);
	}
	close(file);
	return 0;
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	COMPARE_INFO *in = (COMPARE_INFO *)au->info;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case '?':
			au_syntax_message(au, "COMpare");
			au_printf(au,
				"file1 [file2] [@?1filespec@?H]\n\n");
			exit(0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	case PARSE_FILESPEC:
		if (strchr(cur_argv, '?') || strchr(cur_argv, '*'))
			strcpy(au->partial, cur_argv);
		else if (in->filename1[0] == '\0')
			strcpy(in->filename1, cur_argv);
		else if (in->filename2[0] == '\0')
			strcpy(in->filename2, cur_argv);
		else
			strcpy(au->partial, cur_argv);
		return TRUE;
	case PARSE_POST_CHECK:
		if (in->filename1[0] == '\0')
		{
			au_printf_error(au, "Need at least 1 file parameter");
			exit(1);
		}
		if (au->partial[0] == '\0')
			strcpy(au->partial, "*.*");
		return TRUE;
	}
	return FALSE;
}
/**/
int main_compare(AU *au, int argc, char *argv[])
{
	COMPARE_INFO *in;

	in = (COMPARE_INFO *)au_malloc(au, sizeof(COMPARE_INFO));
	memset(in, '\0', sizeof(COMPARE_INFO));
	au->info = in;
	in->area = 0;

	generic_parse_comm_line(au, argc, argv, parse_comm_line);

	if (in->filename2[0] != '\0')
		compare(au, in->filename1, in->filename2);
	else
		disp_list(au, in->filename1);
	return 0;
}

