program TestErr;
{
                       To test the ShErrMsg unit

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

         This program source file and the associated executable
         file may be  used and distributed  only in  accordance
         with the  provisions  described  on  the title page of
                  the accompanying documentation file
                              SKYHAWK.DOC
}

uses 
  ShErrMsg;

const
  T2  : byte = 0;

var
  T1  : integer;
  R1  : real;
  C1  : char;
  S1  : string;
  F   : text;

begin
  FillChar(F, SizeOf(F), 0);
  Write('Checking on? [Y/N]  '); ReadLn(C1);
  if UpCase(C1) = 'Y' then CheckOn else CheckOff;
  WriteLn;
  WriteLn('Error options:');
  WriteLn('1.   File not found');
  WriteLn('2.   File not assigned');
  WriteLn('3.   Drive not ready');
  WriteLn('4.   Division by zero');
  WriteLn('5.   Invalid floating point operation');
  WriteLn('6.   User defined runtime error');
  WriteLn('7.   Halt');
  WriteLn('8.   User defined runtime error, no message');
  WriteLn('9.   Halt, no message');
  WriteLn;
  Write('Option number:  '); ReadLn(T2);
  case T2 of
    1 : begin
          Assign(F, 'FOO.BAZ');
          Reset(F);
          end;
    2 : begin
          Reset(F);
          end;
    3 : begin
          WriteLn('Check that the A drive is empty and the latch open.');
          Write('<CR> when ready.. '); ReadLn;
          Assign(F, 'A:\FOO.BAZ');
          Reset(F);
          end;
    4 : begin
          R1 := 0.0;
          R1 := 1.0 / R1;
          end;
    5 : begin
          R1 := 1234567.89E27;
          T1 := trunc(R1);
          end;
    6 : begin
          Write('Error code  '); ReadLn(T1);
          Write('Message  '); ReadLn(S1);
          RunErrorMsg(T1, S1);
          end;
    7 : begin
          Write('Error code  '); ReadLn(T1);
          Write('Message  '); ReadLn(S1);
          HaltMsg(T1, S1);
          end;
    8 : begin
          Write('Error code  '); ReadLn(T1);
          RunError(T1);
          end;
    9 : begin
          Write('Error code  '); ReadLn(T1);
          Halt(T1);
          end;
    end; {case}
  end.
