{$I SHDEFINE.INC}

{$I SHUNITSW.INC}

unit TestDate;
{
                        To test the ShDatPk unit

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

         This program source file and the associated executable
         file may be  used and distributed  only in  accordance
         with the  provisions  described  on  the title page of
                  the accompanying documentation file
                              SKYHAWK.DOC
}

interface

uses
  TpDos,
  TpString,
  ShDatPk;

procedure DateTest;

implementation

procedure DateTest;

var
  G               : GregType;
  T               : TimeType;
  Year,
  Month,
  Day,
  Weekday,
  JulianDate      : array[1..3] of integer;
  JulianDayNumber : array[1..2] of LongInt;
  Greg            : array[1..3] of GregType;

  O               : text;

begin
  if OpenStdDev(O, 1) then ;       {Write to StdOut}

  WriteLn(O); WriteLn(O);
  WriteLn(O, Center('SHDATPK TESTS', 72)); WriteLn(O);

  JDN2Greg(Today, G);
  WriteLn(O, 'Today is day number ',Today,', a ',DayStr[DoW(G)]);
  WriteLn(O, 'Today''s date (TodayStr) is ',TodayStr('='));
  WriteLn(O, 'Today''s date (JDN2Str) is ',JDN2Str(Today,'/'));
  WriteLn(O, '   as an ANSI string (YYYYMMDD) ', Today2ANSI);
  WriteLn(O);

  WriteLn(O, 'The time in seconds since midnight is ',Now);
  WriteLn(O, '    the a.m./p.m. time is ',NowStr(':',false));
  WriteLn(O, '    the undelimited time is ',NowStr('',false));
  WriteLn(O);
  WriteLn(O, '    the military time is ',NowStr('',true));
  WriteLn(O, '    the 24-hour time is ',NowStr(':',true));

  SSM2Time(Now, T);
  WriteLn(O, '    the 24-hour time (SSM2Time, Time2TimeStr) is ',
                                                  Time2TimeStr(T,':',true));
  Now2Time(T);
  WriteLn(O, '    the 24-hour time (Now2Time, Time2TimeStr) is ',
                                                  Time2TimeStr(T,':',true));
  WriteLn(O, '    the 24-hour time (Time2SSM, SSM2TimeStr) is ',
                                       SSM2TimeStr(Time2SSM(T), '.', true));

  Flush(O);
  if not HandleIsConsole(1) then
    exit;

  WriteLn(O);
  WriteLn(O, 'The remainder of this testing program will allow you to');
  WriteLn(O, '  experiment with dates of your own choosing, entered as');
  WriteLn(O, '  year, month, day in response to the prompts. ');
  WriteLn(O);
  WriteLn(O, ^G'  Note that the YEAR does not default to the 20th century.');
  WriteLn(O, 'Enter "0" for the year to break out of this test.');
  WriteLn(O);
  repeat

    Write(O, 'Year    '); ReadLn(Greg[1].Year);

    if Greg[1].Year = 0 then begin
      Flush(O);
      exit;
      end;

    Write(O, 'Month   '); ReadLn(Greg[1].Month);
    Write(O, 'Day     '); ReadLn(Greg[1].Day); WriteLn(O);

    WriteLn(O, 'You entered:');
    WriteLn(O, '     ',DayStr[DoW(Greg[1])],', ',MonthStr[Greg[1].Month],
                    ' ',Greg[1].Day,', ',Greg[1].Year);
    WriteLn(O);

    JulianDayNumber[1] := Greg2JDN(Greg[1]);
    JDN2Greg(JulianDayNumber[1], Greg[2]);
    JulianDate[1] := Greg2JDate(Greg[2]);
    Greg[3].Year := Greg[1].Year;
    JDate2Greg(JulianDate[1], Greg[3].Year, Greg[3]);
    Weekday[1] := DoW(Greg[3]);

    with Greg[1] do
      WriteLn(O, Month,'/',Day,'/',Year,' is day number ',
              JulianDayNumber[1]);

    with Greg[2] do
      WriteLn(O, Month,'/',Day,'/',Year,' is day ',
              JulianDate[1],' of the year.');

    with Greg[3] do
      WriteLn(O, MonthStr[Month],' ',Day,', ',Year,' is a ',DayStr[Weekday[1]]);

    WriteLn(O); WriteLn(O);

    until false;
  end; {DateTest}
end.
