{$I SHDEFINE.INC}

{$I SHUNITSW.INC}

unit TestCmpx;
{
                        To test the ShCmplx unit

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

         This program source file and the associated executable
         file may be  used and distributed  only in  accordance
         with the  provisions  described  on  the title page of
                  the accompanying documentation file
                              SKYHAWK.DOC
}

interface

uses
  TpString,
  TpDos,
  TpCrt,
  ShCmplx;

procedure CmpxTest;

implementation

procedure CmpxTest;

var
  A,
  B,
  C,
  D   : Complex;
  T1  : integer;
  LB  : string;               {Line Buffer}
  BP  : byte;                 {Buffer pointer}
  Arad: ComplexElement;

  OT  : text;

procedure AnyKey;
  begin
    if HandleIsConsole(1) then begin
      Write(OT, 'Any key to continue...');
      if ReadKey = #0 then ;
      WriteLn(OT);
      end;
    end;

procedure InitLB;
  begin {InitLB}
    FillChar(LB,SizeOf(LB),' ');
    LB[0] := char($FF);
    BP := 1;
    end; {InitLB}

begin
  if not OpenStdDev(OT, 1) then begin
    WriteLn('Can''t open console device.');
    Halt(1);
    end;
  CmplxInit;
  New(A);     New(B);       New(C);       New(D);
  A^.Re := 5.0; A^.Im := 12.0;

  WriteLn(OT);
  WriteLn(OT, Center('BASIC FUNCTION TEST',75));
  WriteLn(OT);

  WriteLn
    (OT, 'The complex conjugate of ' + Cmp2Str(A,0,2) + ' is ' +
      Cmp2Str(CConjF(A),0,2));

  WriteLn
    (OT, 'The absolute value of ' + Cmp2Str(A,0,2) + ' is ' +
      Real2Str(CAbsF(A),0,4));

  WriteLn
    (OT, Center('or, living life the hard way (see source code), is', 75));
  WriteLn
    (OT, Center(CmpP2Str(CpPwrRF(C2PF(CMulF(A, CConjF(A))), 0.5), 0, 4), 75));
  WriteLn(OT);

  B^.Re := 7.5; B^.Im := 6.25;
  WriteLn
    (OT, Cmp2Str(A,0,2) + ' + ' + Cmp2Str(B,0,2) + ' = ' +
      Cmp2Str(CAddF(A, B),0,4));

  WriteLn
    (OT, Cmp2Str(A,0,2) + ' - ' + Cmp2Str(B,0,2) + ' = ' +
      Cmp2Str(CSubF(A, B),0,4));

  WriteLn
    (OT, Cmp2Str(A,0,2) + ' * ' + Cmp2Str(B,0,2) + ' = ' +
      Cmp2Str(CMulF(A, B),0,4));

  WriteLn
    (OT, Cmp2Str(A,0,2) + ' / ' + Cmp2Str(B,0,2) + ' = ' +
      Cmp2Str(CDivF(A, B),0,4));

  C^.Re := 5.0; C^.Im :=  2.0;
  D^.Re := 3.0; D^.Im := -4.0;
  WriteLn
    (OT, Cmp2Str(C,0,2) + ' / ' + Cmp2Str(D,0,2) + ' = ' +
      Cmp2Str(CDivF(C, D),0,4));

  AnyKey;
  WriteLn(OT);

  WriteLn(OT, Center('NESTED CALLS AND INVERSE FUNCTIONS TEST',75));
  WriteLn(OT);

  WriteLn
    (OT, Cmp2Str(A,0,2) + ' + ' + Cmp2Str(B,0,2) + ' + ' +
     Cmp2Str(C,0,2) + ' + ' + Cmp2Str(D,0,2) + ' = ');

  WriteLn
    (OT, '':10, Cmp2Str(CAddF(A, CAddF(B, CAddF(C, D))),0,2));

  WriteLn
    (OT, Cmp2Str(A,0,2) + ' / ' + Cmp2Str(B,0,2) + ' * ' + Cmp2Str(B,0,2) +
     ' = ' + Cmp2Str(CMulF(CDivF(A, B), B), 0, 2));

  WriteLn
    (OT, Cmp2Str(A,0,2) + ' + ' + Cmp2Str(B,0,2) + ' - ' + Cmp2Str(B,0,2) +
     ' = ' + Cmp2Str(CAddF(CSubF(A, B), B), 0, 2));

  AnyKey;
  WriteLn(OT);

  WriteLn(OT, Center('COORDINATE SYSTEM TRANSFORMATION TEST',75));
  WriteLn(OT);

  A^.Re := sqrt(3.0)*0.5; A^.Im := 0.5; {FIRST QUADRANT}
  C2P(A, B);
  WriteLn(OT, Cmp2Str(A,0,2),' is ',CmpP2StrD(B,0,2));

  A^.Re := -sqrt(3.0)*0.5; A^.Im := 0.5; {SECOND QUADRANT}
  C2P(A, B);
  WriteLn(OT, Cmp2Str(A,0,2),' is ',CmpP2StrD(B,0,2));

  A^.Re := -sqrt(3.0)*0.5; A^.Im := -0.5; {THIRD QUADRANT}
  C2P(A, B);
  WriteLn(OT, Cmp2Str(A,0,2),' is ',CmpP2StrD(B,0,2));

  A^.Re := sqrt(3.0)*0.5; A^.Im := -0.5; {FOURTH QUADRANT}
  C2P(A, B);
  WriteLn(OT, Cmp2Str(A,0,2),' is ',CmpP2StrD(B,0,2));

  WriteLn(OT);

  A^.Re := 1.0;
  InitLB;
  for T1 := 0 to 36 do begin
    A^.Im := 10.0 * T1 * Pi / 180.0;
    C^ := C2PF(P2CF(A))^;
    Insert(CmpP2StrD(C,0,2), LB, BP);
    if (T1 mod 4) = 0 then begin
      WriteLn(OT, TrimTrail(LB));
      InitLB;
      end
    else
    BP := 20*(T1 mod 4);
    end;
  AnyKey;
  WriteLn(OT);

  WriteLn(OT, Center('POWER TEST',75));
  WriteLn(OT);

  A^.Re := 8.0; A^.Im := 0.0; Arad := 1.0/3.0;
  WriteLn(OT, CmpP2StrD(A,0,4),' ^ ',Arad);
  WriteLn(OT, CmpP2Str(A,0,4),' ^ ',Arad);

  for T1 := 0 to 3 do begin
    B^ := CpPwrRF(A, Arad)^;
    while B^.Im >= 2.0*Pi do B^.Im := B^.Im - 2.0*Pi;
    InitLB;
    Insert(CmpP2StrD(B,0,4), LB, 1);
    Insert('is '+ Cmp2Str(P2CF(B),0,4), LB, 25);
    Insert('is '+ CmpP2Str(B,0,4), LB, 50);
    WriteLn(OT, TrimTrail(LB));
    A^.Im := A^.Im + 2.0*Pi;
    end;

  WriteLn(OT);

  A^.Re := 125.0; A^.Im := 15.0*Pi/180.0;
  WriteLn(OT, CmpP2StrD(A,0,4),' ^ ',Arad);
  WriteLn(OT, CmpP2Str(A,0,4),' ^ ',Arad);

  for T1 := 0 to 3 do begin
    B^ := CpPwrRF(A, Arad)^;
    while B^.Im >= 2.0*Pi do B^.Im := B^.Im - 2.0*Pi;
    InitLB;
    Insert(CmpP2StrD(B,0,4), LB, 1);
    Insert('is '+ Cmp2Str(P2CF(B),0,4), LB, 25);
    Insert('is '+ CmpP2Str(B,0,4), LB, 50);
    WriteLn(OT, TrimTrail(LB));
    A^.Im := A^.Im + 2.0*Pi;
    end;

  AnyKey;
  Flush(OT);
  Dispose(D);
  Dispose(C);
  Dispose(B);
  Dispose(A);
  CmplxDeinit;
  end; {CmpxTest}
end.
